/****************************************************************************/
/* Rechnen mit Polynomen aus R[x,y,z]           (double - Genauigkeit)      */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/
#include<math.h>
#include"3dpoly.h"

#define max(a,b) ((a)>(b)?(a):(b))

void T3dpoly::setkoeff(double nkoeff, int nxdeg, int nydeg, int nzdeg)
{
  int i;
  for (i=0;i<koeffnum;++i)
  {
    if (xdeg[i]==nxdeg && ydeg[i]==nydeg && zdeg[i]==nzdeg)
    {
      koeffs[i]=nkoeff;
      optimize();
      return;
    }
  }
  xdeg[koeffnum]=nxdeg;
  ydeg[koeffnum]=nydeg;
  zdeg[koeffnum]=nzdeg;
  koeffs[koeffnum++]=nkoeff;
  optimize();
}

void T3dpoly::setdegs()
{
  int i;
  xdegree=ydegree=zdegree=0;
  for (i=0;i<koeffnum;++i)
  {
    if (xdeg[i]>xdegree) xdegree=xdeg[i];
    if (ydeg[i]>ydegree) ydegree=ydeg[i];
    if (zdeg[i]>zdegree) zdegree=zdeg[i];
  }
}

double T3dpoly::getkoeff(int rxdeg, int rydeg, int rzdeg)
{
  int i;
  for (i=0;i<koeffnum;++i)
  {
	if (xdeg[i]==rxdeg && ydeg[i]==rydeg && zdeg[i]==rzdeg)
	  return koeffs[i];
  }
  return 0;
}

void T3dpoly::optimize()
{
  int i;
  for (i=0;i<koeffnum;++i)
  {
	if (fabs(koeffs[i])<1e-20)
	{
	  koeffs[i]=koeffs[koeffnum-1];   //koeffs[i] lschen und dafr koeffs[koeffnum-1] einfgen
	  xdeg[i]=xdeg[koeffnum-1];
	  ydeg[i]=ydeg[koeffnum-1];
	  zdeg[i]=zdeg[koeffnum-1];
	  --koeffnum;
	}
  }
  setdegs();
}

T3dpoly T3dpoly::operator + (T3dpoly b)
{
  T3dpoly Erg;
  int i;

  for (i=0;i<koeffnum;++i)
	Erg.setkoeff(koeffs[i]+b.getkoeff(xdeg[i],ydeg[i],zdeg[i]),xdeg[i],ydeg[i],zdeg[i]);
  for (i=0;i<b.koeffnum;++i)
	Erg.setkoeff(b.koeffs[i]+getkoeff(b.xdeg[i],b.ydeg[i],b.zdeg[i]),b.xdeg[i],b.ydeg[i],b.zdeg[i]);

  Erg.optimize();
  return Erg;
}

T3dpoly T3dpoly::operator - (T3dpoly b)
{
  T3dpoly Erg;
  int i;

  for (i=0;i<koeffnum;++i)
	Erg.setkoeff(koeffs[i]-b.getkoeff(xdeg[i],ydeg[i],zdeg[i]),xdeg[i],ydeg[i],zdeg[i]);
  for (i=0;i<b.koeffnum;++i)
	Erg.setkoeff(-b.koeffs[i]+getkoeff(b.xdeg[i],b.ydeg[i],b.zdeg[i]),b.xdeg[i],b.ydeg[i],b.zdeg[i]);

  Erg.optimize();
  return Erg;
}

T3dpoly T3dpoly::operator * (T3dpoly b)
{
  T3dpoly Erg;
  int i,j;

  for (i=0;i<koeffnum;++i)
	for (j=0;j<b.koeffnum;++j)
	  Erg.setkoeff(Erg.getkoeff(xdeg[i]+b.xdeg[j],ydeg[i]+b.ydeg[j],zdeg[i]+b.zdeg[j])+koeffs[i]*b.koeffs[j],
				   xdeg[i]+b.xdeg[j],ydeg[i]+b.ydeg[j],zdeg[i]+b.zdeg[j]);
  Erg.optimize();
  return Erg;
}

T3dpoly T3dpoly::operator *= (T3dpoly b)
{
  *this=*this * b;
  return *this;
}

T3dpoly T3dpoly::operator += (T3dpoly b)
{
  *this=*this + b;
  return *this;
}

T3dpoly T3dpoly::operator -= (T3dpoly b)
{
  *this=*this - b;
  return *this;
}

T3dpoly T3dpoly::operator * (double f)
{
  T3dpoly Erg=*this;
  Erg*=f;
  Erg.optimize();
  return Erg;
}

T3dpoly T3dpoly::operator *= (double f)
{
  int i;
  for (i=0;i<koeffnum;++i)
	koeffs[i]*=f;
  return *this;
}

TPolynom T3dpoly::insert(TPolynom x, TPolynom y, TPolynom z)
{                          //Funktioniert noch nicht! NICHT GEBRAUCHEN!
  int i,j;
  TPolynom Erg,tmp,null;

  for (i=0;i<koeffnum;++i)
  {
    tmp=null;
    for (j=0;j<xdeg[i];++j)
      tmp*=x;
    for (j=0;j<ydeg[i];++j)
      tmp*=y;
    for (j=0;j<zdeg[i];++j)
      tmp*=z;
    Erg+=tmp;
  }
  return Erg;
}
