/****************************************************************************/
/* Rechnen mit Polynomen aus R[x,y,z]           (double - Genauigkeit)      */
/*              (c) 1997 by Martin Melcher, 4th Dimension Arts              */
/****************************************************************************/
#ifndef POLY3DHEADER

#include"polynome.h"

#define MAXKOEFFS3D 100

class T3dpoly
{
public:
  int xdegree,ydegree,zdegree;
  int koeffnum;
  double koeffs[MAXKOEFFS3D];
  int xdeg[MAXKOEFFS3D],ydeg[MAXKOEFFS3D],zdeg[MAXKOEFFS3D];
  T3dpoly() {xdegree=ydegree=zdegree=koeffnum=0;}
  void setkoeff(double nkoeff, int nxdeg, int nydeg, int nzdeg);
  double getkoeff(int rxdeg, int rydeg, int rzdeg);
  void optimize();
  void setdegs();
  T3dpoly operator + (T3dpoly b);
  T3dpoly operator +=(T3dpoly b);
  T3dpoly operator - (T3dpoly b);
  T3dpoly operator -=(T3dpoly b);
  T3dpoly operator * (T3dpoly b);
  T3dpoly operator *=(T3dpoly b);
  T3dpoly operator * (double f);
  T3dpoly operator *=(double f);
  TPolynom insert(TPolynom x, TPolynom y, TPolynom z);
};

typedef T3dpoly *PT3dpoly;

#define POLY3DHEADER

#endif
