/****************************************************************************/
/* BMP-Dateien schreiben                                                    */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/
#include<stdio.h>
#include<string.h>

class TBMPFile
{
  unsigned xsize,ysize;
  char bits;
  char filename[80];
  FILE *datei;
public:
  TBMPFile(char *name, unsigned xs, unsigned ys, char b)
    //b mu 8 oder 24 sein!
  {
    strcpy(filename,name);
    xsize=xs;
    ysize=ys;
    bits=b;
    datei=fopen(filename,"wb");
  }
  ~TBMPFile()
  {
    fclose(datei);
  }
  void writeheaders();
  void writepalette(char *palette);
  void writepixel(unsigned long pixel);
};

void fputw(int a, FILE *b)
{
  fputc(a&0xFF,b);
  fputc(a>>8,b);
}

void fputd(long a, FILE *b)
{
  fputw(a&0xFFFF,b);
  fputw(a>>16,b);
}

void TBMPFile::writeheaders()
{
  fputc('B',datei);
  fputc('M',datei);
  fputd((long)xsize*ysize*(bits==24?3:1)+14+40+(bits==8?1024:0),datei);
  fputd(0,datei);
  fputd(14+40+(bits==8?1024:0),datei);

  fputd(40,datei);
  fputd((long)xsize,datei);
  fputd((long)ysize,datei);
  fputw(1,datei);
  fputw(bits,datei),
  fputd(0,datei);
  fputd((long)xsize*ysize*(bits==24?3:1),datei);
  fputd(0,datei);
  fputd(0,datei);
  fputd(bits==24?0l:256l,datei);
  fputd(bits==24?0l:256l,datei);
}

void TBMPFile::writepalette(char *palette)
{
  int i;
  for (i=0;i<256;++i)
  {
    fputc(palette[i*3+2]<<2,datei);
    fputc(palette[i*3+1]<<2,datei);
    fputc(palette[i*3+0]<<2,datei);
    fputc(0,datei);
  }
}

void TBMPFile::writepixel(unsigned long pixel)
{
  if (bits==24)
  {
    fputc(pixel&0xFF,datei);
    fputc((pixel>>8)&0xFF,datei);
    fputc(pixel>>16,datei);
  }
  else fputc(pixel,datei);
}
