/****************************************************************************/
/* BUMPBASE.CPP - BumpMap-Basisalgorithmen                                  */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<math.h>
#include"bumpbase.h"

void TBump_Rings::modifynv(TVector const &point, TVector &norm)
{
  double dist,mangle;
  double angle;

  dist=(double)point;
  angle=acos(point.x/dist);
  if (point.z<0) angle*=-1;
  dist/=rads;
  mangle=cos(dist)*intens;
  mangle*=exp(-decrease*dist);
  norm.x+=mangle*cos(angle);
  norm.z+=mangle*sin(angle);
  norm.normalize();
}

void TBump_Sines::modifynv(TVector const &point, TVector &norm)
{
  norm.x+=intens*sin(point.x);
  norm.y+=intens*sin(point.y);
  norm.z+=intens*sin(point.z);
  norm.normalize();
}
