/****************************************************************************/
/* CAMERAS.CPP - Kameradefinitionen                                         */
/* Hier werden Kameras (evtl. mehrere mit verschiedenen Projektionen)       */
/* implementiert                                                            */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/
#include"tvector.h"
#include"ray20.h"
#include"cameras.h"

/*****TNormalCamera : Normale Kamera mit Rechteckiger Projektion*************/

TNormalCamera::TNormalCamera(double x, double y, double z, double xr, double yr, double zr, int xres, int yres, double pxsize,double pysize)
 :TCamera(x,y,z,xr,yr,zr,xres,yres)
{
  TVector t1,t2,left,bot;

  xsize=pxsize;ysize=pysize;

  t1.init(0,1,0);
  t2=refpoint-pos;
  left.init(t1,t2);
  bot.init(left,t2);
  left*=xsize/((double)left)/2.0;
  bot*=ysize/((double)bot)/2.0;
  v1=left-bot;
  v2=-left-bot;
  v3=bot-left;
  v4=left+bot;

  v1+=t2; v2+=t2; v3+=t2; v4+=t2;
}

TVector TNormalCamera::getvector(int x, int y)
{
  TVector tv1,tv2,v;
  double fx,fy;
  fx=(double)x/resx;
  fy=(double)y/resy;
  tv1.x=fx*v1.x+(1-fx)*v2.x;
  tv1.y=fx*v1.y+(1-fx)*v2.y;
  tv1.z=fx*v1.z+(1-fx)*v2.z;

  tv2.x=fx*v4.x+(1-fx)*v3.x;
  tv2.y=fx*v4.y+(1-fx)*v3.y;
  tv2.z=fx*v4.z+(1-fx)*v3.z;

  v.x=fy*tv1.x+(1-fy)*tv2.x;
  v.y=fy*tv1.y+(1-fy)*tv2.y;
  v.z=fy*tv1.z+(1-fy)*tv2.z;

  return v;
}
