/****************************************************************************/
/* DUST.CPP - Staubatmorphre                                               */
/* Atmosphrenobjekt - in festen Abstnden folgt immer ein Schnittpunkt     */
/* Dadurch werden auch Lichtkegel ermglicht                                */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include"ray20.h"
#include"tvector.h"
#include<math.h>
#include"objects.h"
#include<stdlib.h>
#include<stdarg.h>

TDust::TDust(double density, double reflection)
{
  disttohit=1.0/density;
  flat=reflection/density;
  trans=1;
  type=TYPE_DUST;
}

char TDust::Obj_NextCut(double &t)
{
  if (nodust) return 0;
  if (nmaxt!=DBL_MAX) return 0; //Bei Schattenberechnungen keine Schnittpunkte
  t=lastt+disttohit;
  return 1;
}

TVector TDust::Obj_GetNormVect(void)
{
  return TVector(0,0,0);
}
