/****************************************************************************/
/* EQNOBJS.CPP - Objekte mit beliebiger Oberflchengleichung                */
/* Alle Objekte verden mit Einheitsgre und im Ursprung berechnet,         */
/* Der Rest wird in RAY20.CPP besorgt                                       */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<math.h>
#include"polysolv.h"
#include"objects.h"

void TEqnObject::AddKoeff(double koeff, int pxdeg, int pydeg, int pzdeg)
{
  koeffs[koeffnum]=koeff;
  xdeg[koeffnum]=pxdeg;
  ydeg[koeffnum]=pydeg;
  zdeg[koeffnum]=pzdeg;
  if (pxdeg>xdegree) xdegree=pxdeg;
  if (pydeg>ydegree) ydegree=pydeg;
  if (pzdeg>zdegree) zdegree=pzdeg;
  ++koeffnum;
}

void TEqnObject::CalcPoly(void)
{
  int i;
  TPolynom TempPoly;

  if (XPoly!=NULL)
  { delete XPoly; delete YPoly; delete ZPoly; delete MySolver;}
  XPoly=new TPolynom[xdegree==0?1:xdegree];
  YPoly=new TPolynom[ydegree==0?1:ydegree];
  ZPoly=new TPolynom[zdegree==0?1:zdegree];

  XPoly[0]=TPolynom(1,nstart.x,ndir.x);
  YPoly[0]=TPolynom(1,nstart.y,ndir.y);
  ZPoly[0]=TPolynom(1,nstart.z,ndir.z);

  for (i=2;i<=xdegree;++i)
  {
    XPoly[i-1]=XPoly[i-2];
    XPoly[i-1]*=XPoly[0];
  }
  for (i=2;i<=ydegree;++i)
  {
    YPoly[i-1]=YPoly[i-2];
    YPoly[i-1]*=YPoly[0];
  }
  for (i=2;i<=zdegree;++i)
  {
    ZPoly[i-1]=ZPoly[i-2];
    ZPoly[i-1]*=ZPoly[0];
  }

  TPoly=TPolynom(0,0);

  for (i=0;i<koeffnum;++i)
  {
    TempPoly=TPolynom(0,koeffs[i]);
    if (xdeg[i]>0)
      TempPoly*=XPoly[xdeg[i]-1];
    if (ydeg[i]>0)
      TempPoly*=YPoly[ydeg[i]-1];
    if (zdeg[i]>0)
      TempPoly*=ZPoly[zdeg[i]-1];

    TPoly+=TempPoly;
  }
  MySolver=new TPolySolver(TPoly);
}

char TEqnObject::Obj_NextCut(double &t)
{
  if (isfirst)
  {
    CalcPoly();
  }

  if (!MySolver->has0(lastt, nmaxt))
    return 0;

  t=MySolver->first0(lastt,nmaxt,DIST/10.0);
  if (t+DIST>=nmaxt || t<DIST+lastt) // Der "Sicherheitsabstand" mmuss groesser als die
  {                                  // Genauigkeit sein!
    return 0;
  }
  if (t>1e6) return 0;       // Keine astronomischen Werte zulassen
  return 1;
}

TVector TEqnObject::Obj_GetNormVect(void)
{
  TVector cut,norm;
  double tmp;
  int i;

  cut=nstart+ndir*lastt;

  norm.x=0;
  for (i=0;i<koeffnum;++i)
  {
    if (xdeg[i]==0) continue;
    tmp=xdeg[i]*koeffs[i];
    if (xdeg[i]>1)
      tmp*=pow(cut.x,xdeg[i]-1);
    if (ydeg[i]>0)
      tmp*=pow(cut.y,ydeg[i]);
    if (zdeg[i]>0)
      tmp*=pow(cut.z,zdeg[i]);
    norm.x+=tmp;
  }
  norm.y=0;
  for (i=0;i<koeffnum;++i)
  {
    if (ydeg[i]==0) continue;
    tmp=ydeg[i]*koeffs[i];
    if (ydeg[i]>1)
      tmp*=pow(cut.y,ydeg[i]-1);
    if (xdeg[i]>0)
      tmp*=pow(cut.x,xdeg[i]);
    if (zdeg[i]>0)
      tmp*=pow(cut.z,zdeg[i]);
    norm.y+=tmp;
  }
  norm.z=0;
  for (i=0;i<koeffnum;++i)
  {
    if (zdeg[i]==0) continue;
    tmp=zdeg[i]*koeffs[i];
    if (zdeg[i]>1)
      tmp*=pow(cut.z,zdeg[i]-1);
    if (ydeg[i]>0)
      tmp*=pow(cut.y,ydeg[i]);
    if (xdeg[i]>0)
      tmp*=pow(cut.x,xdeg[i]);
    norm.z+=tmp;
  }

  norm.normalize();
  return norm;
}

char TEqnObject::Obj_InObject(double t)
{
/*  int i;
  double *xpow,*ypow,*zpow;
  double erg=0;
  double tmp;*/
  if (isfirst)
  {
    CalcPoly();
    isfirst=0;
  }


  return TPoly.eval(t)<0;

/*  xpow=new double[xdegree];
  ypow=new double[ydegree];
  zpow=new double[zdegree];

  xpow[0]=point.x;
  ypow[0]=point.y;
  zpow[0]=point.z;

  for (i=2;i<=xdegree;++i)
    xpow[i-1]=xpow[i-2]*xpow[0];
  for (i=2;i<=ydegree;++i)
    ypow[i-1]=ypow[i-2]*ypow[0];
  for (i=2;i<=zdegree;++i)
    zpow[i-1]=zpow[i-2]*zpow[0];

  for (i=0;i<koeffnum;++i)
  {
    tmp=koeffs[i];
    if (xdeg[i]>0)
      tmp*=xpow[xdeg[i]-1];
    if (ydeg[i]>0)
      tmp*=ypow[ydeg[i]-1];
    if (zdeg[i]>0)
      tmp*=zpow[zdeg[i]-1];
    erg+=tmp;
  }

  delete xpow;
  delete ypow;
  delete zpow;

  return (erg<0);*/
}

TSQEllipsoid :: TSQEllipsoid(int degree) : TEqnObject()
{
  AddKoeff(1,degree,0,0);
  AddKoeff(1,0,degree,0);
  AddKoeff(1,0,0,degree);
  AddKoeff(-1,0,0,0);
}

void TSQEllipsoid :: calcsphere()
{
  spherem.x=spherem.y=spherem.z=0;
  spherer2=3;
  spherecalculated=1;
}

void TSQEllipsoid::MakeBoundingObject()
{
  BoundingObject=new TCube();
  BoundingObject->scalex=BoundingObject->scaley=BoundingObject->scalez=2;
}

TTorus::TTorus(double pr1, double pr2)
{
/*
           __  .......................  __
         /    \                       /    \
        |      |          x<---r1--->|   <r2>
         \    /                       \    /
           ~~  .......................  ~~

Gleichung: x^4 + y^4 +z^4
+ 2*x^2*y^2 + 2*x^2*z^2 + 2*y^2*z^2
- 2*(r1^2 + r2^2)*x^2 + 2*(r1^2 - r2^2)*y^2 - 2*(r1^2 + r2^2)*z^2 + (r1^2 - r2^2
)^2 = 0*/

  r1=pr1;
  r2=pr2;
  AddKoeff(1, 4, 0, 0);
  AddKoeff(1, 0, 4, 0);
  AddKoeff(1, 0, 0, 4);
  AddKoeff(2, 2, 2, 0);
  AddKoeff(2, 2, 0, 2);
  AddKoeff(2, 0, 2, 2);
  AddKoeff(-2*(r1*r1+r2*r2), 2, 0, 0);
  AddKoeff(2*(r1*r1-r2*r2), 0, 2, 0);
  AddKoeff(-2*(r1*r1+r2*r2), 0, 0, 2);
  AddKoeff((r1*r1-r2*r2)*(r1*r1-r2*r2), 0, 0, 0);
}

void TTorus :: calcsphere()
{
  spherem.x=spherem.y=spherem.z=0;
  spherer2=(r1+r2)*(r1+r2);
  spherecalculated=1;
}

void TTorus::MakeBoundingObject()
{
  BoundingObject=new TTube((r1-r2)/(r1+r2));
  BoundingObject->scalex=BoundingObject->scalez=r1+r2;
  BoundingObject->scaley=r2;
}

TBlob::TBlob(double pborderintens)
{
  borderintens=pborderintens;
  srcnum=0;
}

TBlob::~TBlob()
{
  for (int i=0;i<srcnum;++i)
    delete Src[i];
}

void TBlob::AddSpherical(double px, double py, double pz, double pintens)
{
  T3dpoly xpoly,ypoly,zpoly;//,Temp,Eins;
  ++srcnum;
  Src[srcnum-1]=new T3dpoly();

  xpoly.setkoeff(1,1,0,0);
  ypoly.setkoeff(1,0,1,0);
  zpoly.setkoeff(1,0,0,1);
  xpoly.setkoeff(-px,0,0,0);
  ypoly.setkoeff(-py,0,0,0);
  zpoly.setkoeff(-pz,0,0,0);

/*  Eins.setkoeff(1,0,0,0);
  Temp=Eins-(xpoly*xpoly+ypoly*ypoly+zpoly*zpoly);
  Temp*=Temp*-pintens;
  *this+=Temp;*/

  *Src[srcnum-1]=xpoly*xpoly+ypoly*ypoly+zpoly*zpoly;
  intens[srcnum-1]=pintens;
}

void TBlob::AddCylindrical(TVector p1, TVector p2, double pintens)
{             //Abstand Punkt-Gerade wie im Buch (siehe auch vectors.cc)
  TVector v=p2-p1;
  v.normalize();
  T3dpoly xp1,yp1,zp1,xp2,yp2,zp2,ex,ey,ez;

  xp1.setkoeff(1,1,0,0);      //Erst den ersten Vektor (r2-r1 lt. Buch) berechnen
  xp1.setkoeff(-p1.x,0,0,0);
  yp1.setkoeff(1,0,1,0);
  yp1.setkoeff(-p1.y,0,0,0);
  zp1.setkoeff(1,0,0,1);
  zp1.setkoeff(-p1.z,0,0,0);
  
  xp2.setkoeff(v.x,0,0,0);
  yp2.setkoeff(v.y,0,0,0);
  zp2.setkoeff(v.z,0,0,0);
  
  //Krezuprodukt:
  ex=yp1*zp2-zp1*yp2;
  ey=zp1*xp2-xp1*zp2;
  ez=xp1*yp2-yp1*xp2;
  

  Src[srcnum]=new T3dpoly();
  *Src[srcnum]=ex*ex+ey*ey+ez*ez;  
  
  intens[srcnum++]=pintens;
}

void TBlob::AddPlanar(TVector p, TVector Normv, double pintens)
{
  Normv.normalize();
  T3dpoly P;
  P.setkoeff(Normv.x,1,0,0);
  P.setkoeff(Normv.y,0,1,0);
  P.setkoeff(Normv.z,0,0,1);
  P.setkoeff(-p*Normv,0,0,0);
 
  Src[srcnum]=new T3dpoly();
  *Src[srcnum]=P*P;
  intens[srcnum++]=pintens;
}

void TBlob::calculate()
{                     //Der Blob hat die Formel 1/Src[0]+1/Src[1]+... = borderintens
  int i,j;            //Dies wird auf den Hauptnenner Src[0]*Src[1]*... gebracht.
  T3dpoly Tmp,Eins;
  Eins.setkoeff(1,0,0,0);
  for (i=0;i<srcnum;++i)
  {
    Tmp=Eins;
    for (j=0;j<srcnum;++j)
    {
      if (j==i) continue;
      Tmp*=*Src[j];
    }
    Tmp*=intens[i];
    *this+=Tmp;
  }
  Tmp=Eins;
  for (i=0;i<srcnum;++i)
    Tmp*=*Src[i];
  Tmp*=-borderintens;
  *this+=Tmp;
  *this*=-1;
} 
