#include<string.h>
#include<stdlib.h>
#include<ctype.h>
#include<limits.h>
#include<math.h>
#include<stdio.h>
#include<iostream.h>
#include"exp_parser.h"

int exp_error=0;
char *exp_message;

TStringEntry *GlobalStringTable=NULL;

TExpression::TExpression(char *pline, TVariable *pvarlist, TUserFunction *pFuncList)
{
  varlist=pvarlist;
  line=(char *)malloc(strlen(pline)+1);
  strcpy(line, pline);
  FuncList=pFuncList;
}

TExpression::~TExpression()
{
  free(line);
}



void TExpression::strip()
{
  int leftpos=0;
  int rightpos=strlen(line)-1;
  int done=0;
  int pos, bracket;
  int removebracket;

  while (!done)
  {
    done=1;
    while (line[leftpos]==' ') {++leftpos; done=0;}
    while (line[rightpos]==' ') {--rightpos; done=0;}
    bracket=0;
    removebracket=1;
    for (pos=leftpos; pos<rightpos; ++pos)
    {
      if (line[pos]=='(') ++bracket;
      else if (line[pos]==')') {--bracket; if (bracket==0) removebracket=0;}
    }
    if (removebracket)
      if ((line[rightpos]==')')&&(line[leftpos]=='(')) {++leftpos; --rightpos; done=0;}

    if (leftpos>rightpos) done=1;
  }
  if (leftpos>rightpos) {exp_error=1; exp_message="Empty (sub)expression"; return;}
  memmove(line, line+leftpos, rightpos-leftpos+1);
  line[rightpos-leftpos+1]=0;
}

char *pre_opchars="(+-*/^%<>=";  //Hinter diesen Zeichen und am Anfang darf nur ein unrer Prfix-Operator stehen.
char *post_opchars=")*/^%<>=";   //Vor diesen Zeichen und am Ende darf nur ein unrer Postfix-Operator stehen
char *open_bracket="([";
char *close_bracket=")]";

char *notavar_chars="()[]+-*/^%<>=.\"";   //Diese Zeichen drfen in Variablennamen nicht vorkommen

#define min(a,b) ((a)<(b)?(a):(b))

void TExpression::preprocess()
{
  int i,j,k,bracket,instring;
  TVariable *varlauf, *myvar;
  char varname[VARNAME_MAXLENGTH+1];
  var4inc=var4dec=NULL; var4assign=NULL; incnum=decnum=0;


  strip();

//Achtung: Der Komma-Operator hat eine noch niedrige Prioritaet als alles andere!
  bracket=instring=0;
  for (i=0; i<strlen(line); ++i)
  {
    if (strchr(open_bracket, line[i])) ++bracket;
    if (strchr(close_bracket, line[i])) --bracket;
    if (line[i]=='\"'){
      if (!instring) instring=1;
      else { instring=0; if (i>0) if (line[i-1]=='\\') instring=1;}
    }
    if ((bracket==0)&&!instring&&(line[i]==',')) return; //Erstmal aufspalten!
  }

//Schritt I: Zuweisung suchen

  instring=0;
  for (i=0; i<strlen(line) && !strchr(open_bracket, line[i]); ++i)
  {
    if (instring)
    {
      if ((line[i]=='\"')&&(line[i-1]!='\\'))
        instring=0;
      continue;
    }
    else if (line[i]=='\"'){
      instring=1;
      continue;
    }
    if (line[i]=='=')
      if (i>0) if (strchr("!<>=",line[i-1])) continue;

    if ((line[i]=='=')&&(line[i+1]!='='))
    {
      for (k=i-1; (k>=0)&&(line[k]==' '); --k);
      memcpy(varname, line, min(VARNAME_MAXLENGTH,k+1));
      varname[min(VARNAME_MAXLENGTH,k+1)]=0;
      for (varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
      {
        if (!strcmp(varname, varlauf->varname))
        {
          if (varlauf->isconstant)
          { exp_error=1; exp_message="=: cannot change constant"; return; }
          var4assign=varlauf;
          memmove(line, line+i+1, strlen(line)-i);
          goto pre_step2;
        }
      } //Nix gefunden -> Neue Variable anlegen
      for (k=i-1; (k>=0)&&(line[k]==' '); --k);
      for (j=0; j<k; ++j)
        if (strchr(notavar_chars, line[j])) {exp_error=1; exp_message="=: Invalid variable name"; return;}
      memcpy(varname, line, min(k+1, VARNAME_MAXLENGTH));
      varname[min(k+1, VARNAME_MAXLENGTH)]=0;
      myvar=(TVariable *)malloc(sizeof(TVariable));
      myvar->next=NULL;
      myvar->isconstant=0;
      myvar->value.type=-1;
      strcpy(myvar->varname, varname);
      if (varlist==NULL) varlist=myvar;
      else { for (varlauf=varlist; varlauf->next!=NULL; varlauf=varlauf->next); varlauf->next=myvar;}
      var4assign=myvar;
      memmove(line, line+i+1, strlen(line)-i);
      goto pre_step2;
    }
    else if (line[i]=='=') ++i; //Hier steht ein "==", berspringen!
  }

pre_step2:
//Schritt II: Nach ++ und -- suchen
  for (i=0; i<strlen(line); ++i)
  {
    if (!strncmp(line+i,"++",2))
    {
//2.1: "++" als Praefixoperator?
      for (j=i+2; line[j]==' '; ++j);
      for (k=j; !strchr(notavar_chars, line[k]); ++k);
      for (varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
      {
        if (!strncmp(line+i+2, varlauf->varname, min(strlen(varlauf->varname),k-j))
            &&(strlen(varlauf->varname)<=k-j))
        {
          if (varlauf->value.type==VARTYPE_INTEGER) ++varlauf->value.value.intval;
          else if (varlauf->value.type==VARTYPE_DOUBLE) ++varlauf->value.value.dblval;
          else { exp_error=1; exp_message="++: Operand does not match"; return; }
          memmove(line+i, line+i+2, strlen(line+i+2)+1);
          goto pre_step2;
        }
      }
//2.2: "++" als Postfixoperator?
      for (j=i-1; (j>0)&&(line[j]==' '); --j);
      for (k=j; !strchr(notavar_chars, line[k])&&(k>=0); --k); ++k;
      for (varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
      {
        if (!strncmp(line+k, varlauf->varname, min(strlen(varlauf->varname),j-k+1))
            &&(strlen(varlauf->varname)<=j-k+1))
        {
          if (varlauf->value.type==VARTYPE_VECTOR) { exp_error=1; exp_message="++: Operand does not match"; return; }
          var4inc=(TVariable **)realloc(var4inc, ++incnum*sizeof(TVariable *));
          var4inc[incnum-1]=varlauf;
          memmove(line+i, line+i+2, strlen(line+i+2)+1);
          goto pre_step2;
        }
      }
      exp_error=1; exp_message="++: Undefined/invalid variable"; return;
    }
    if (!strncmp(line+i,"--",2))
    {
//2.1: "--" als Praefixoperator?
      for (j=i+2; line[j]==' '; ++j);
      for (k=j; !strchr(notavar_chars, line[k]); ++k);
      for (varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
      {
        if (!strncmp(line+i+2, varlauf->varname, min(strlen(varlauf->varname),k-j))
            &&(strlen(varlauf->varname)<=k-j))
        {
          if (varlauf->value.type==VARTYPE_INTEGER) --varlauf->value.value.intval;
          else if (varlauf->value.type==VARTYPE_DOUBLE) --varlauf->value.value.dblval;
          else { exp_error=1; exp_message="--: Operand does not match"; return; }
          memmove(line+i, line+i+2, strlen(line+i+2)+1);
          goto pre_step2;
        }
      }
//2.2: "--" als Postfixoperator?
      for (j=i-1; (j>0)&&(line[j]==' '); --j);
      for (k=j; !strchr(notavar_chars, line[k])&&(k>=0); --k); ++k;
      for (varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
      {
        if (!strncmp(line+k, varlauf->varname, min(strlen(varlauf->varname),j-k+1))
            &&(strlen(varlauf->varname)<=j-k+1))
        {
          if (varlauf->value.type==VARTYPE_VECTOR) { exp_error=1; exp_message="--: Operand does not match"; return; }
          var4dec=(TVariable **)realloc(var4dec, ++incnum*sizeof(TVariable *));
          var4dec[incnum-1]=varlauf;
          memmove(line+i, line+i+2, strlen(line+i+2)+1);
          goto pre_step2;
        }
      }
      exp_error=1; exp_message="--: Undefined/invalid variable"; return;
    }
  }
}

TValue TExpression::postprocess(TValue retval)
{
  int i;

  if (var4assign)
  {
    var4assign->value=retval;
/*    switch(var4assign->value.type)
    {
      case -1:
        var4assign->value=retval;
        break;
      case VARTYPE_INTEGER:
        if (retval.type!=VARTYPE_INTEGER)
        {
          exp_message="=: Cannot assign double to integer, typecast required";
          exp_error=1; free(var4inc); return retval;
        }
        else var4assign->value=retval;
        break;
      case VARTYPE_DOUBLE:
        if (retval.type==VARTYPE_INTEGER)
          var4assign->value.value.dblval=retval.value.intval;
        else if (retval.type=VARTYPE_DOUBLE)
          var4assign->value.value.dblval=retval.value.dblval;
        else {exp_error=1; exp_message="=: Type mismatch"; free(var4inc); return retval;}
        break;
      case VARTYPE_VECTOR:
        if (retval.type!=VARTYPE_VECTOR)
        { exp_error=1; exp_message="=: Type mismatch"; free(var4inc); return retval;}
        else var4assign->value=retval;
        break;
    }*/
  }
  for (i=0; i<incnum;++i)
  {
    if (var4inc[i]->value.type==VARTYPE_INTEGER) ++var4inc[i]->value.value.intval;
    else if (var4inc[i]->value.type==VARTYPE_DOUBLE) ++var4inc[i]->value.value.dblval;
    else { exp_error=1; exp_message="++/-- can be used with scalars only"; return retval;}
  }
  free(var4inc);
  return retval;
}


#define BINOP_COMMA    0
#define BINOP_AND      1
#define BINOP_OR       2
#define BINOP_EQ       3
#define BINOP_LEQ      4
#define BINOP_GEQ      5
#define BINOP_LESS     6
#define BINOP_GREATER  7
#define BINOP_NEQ      8
#define BINOP_PLUS     9
#define BINOP_MINUS   10
#define BINOP_MULT    11
#define BINOP_DOT     12
#define BINOP_DIV     13
#define BINOP_MOD     14
#define BINOP_EXP     15
char *binary_operators[]={",","&&","||","==","<=",">=", "<" ,">" ,"!=","+", "-", "*", ".", "/", "%", "^",NULL}; //Aufsteigend nach Prioritaet sortiert

#define PREOP_MINUS    0
#define PREOP_PLUS     1
#define PREOP_NOT      2
#define PREOP_DOUBLE   3
#define PREOP_INT      4
#define PREOP_STRING   5
char *prefix_operators[]={"-","+","!","(double)","(int)","(string)",NULL};

#define POSTOP_FAC     0
#define POSTOP_DEG     1
char *postfix_operators[]={"!","",NULL};

#define FUNC_SIN       0
#define FUNC_COS       1
#define FUNC_TAN       2
#define FUNC_ASIN      3
#define FUNC_ACOS      4
#define FUNC_ATAN      5
#define FUNC_SINH      6
#define FUNC_COSH      7
#define FUNC_TANH      8
#define FUNC_ASINH     9
#define FUNC_ACOSH    10
#define FUNC_ATANH    11
#define FUNC_EXP      12
#define FUNC_LOG      13
#define FUNC_LN       14
#define FUNC_SQRT     15

#define DBL_FUNC_NO   16

#define FUNC_NAMELEN   5
char *exp_functions[]={"sin","cos","tan","asin","acos","atan","sinh","cosh","tanh","asinh","acosh","atanh","exp","log","ln","sqrt",NULL};
int func_argno[]={     1,    1,    1,     1,     1,     1,     1,      1,    1,      1,      1,      1,    1,     1,   1     ,1};

char exp_tmpstr[STRING_LENGTH];

TValue TExpression::evaluate()
{
  TValue leftval, rightval;
  TValue ret,tmp;
  TExpression *leftexp, *rightexp;
  TVector leftvect, rightvect, retvect;
  TUserFunction *FuncPos;
  char *leftop, *rightop;
  int pos=0, i, j;
  int bracket=0, instring=0;
  int opallowed=0;
  int opfound=0;
  int binaryleftpos, binaryrightpos;
  int foundop=10000;
  int prefixpos, postfixpos;

  preprocess();
  strip();

  if (exp_error) return;

  if (strlen(line)==0) { exp_error=1; exp_message="Empty (sub)expression"; return ret;}

//Schritt I: Nach binaeren Operatoren suchen.
  while (pos<strlen(line))
  {
    while (line[pos]==' ') ++pos;
    if ((bracket==0)&&!instring)
    {
      opallowed=1;
      if (pos>=1)
      {
        if ((toupper(line[pos-1])=='E')&&isdigit(line[pos+1]))  // "-" in 1e-3 o.,
        {
          for (i=pos-2;(i>=0)&&isdigit(line[i]);--i);
          if (i<0)
            opallowed=0;
          else if (strchr(notavar_chars,line[i]))
            opallowed=0;
        }
      }

      if (opallowed)
        for (i=0; (binary_operators[i]!=NULL)&&(i<=foundop); ++i) //Nur nach Operatoren mit niedrigerer Prioritt als schon gefundene suchen
        {
          if (!strncmp(line+pos, binary_operators[i], strlen(binary_operators[i])))
          {  //Binrer Operator gefunden!

            opallowed=1;                                    //Darf hier berhaupt einer stehen?
            j=pos-1;  while ((j>=0)&&(line[j]==' ')) --j;
            if ((j<0)||(strchr(pre_opchars,line[j])))
              opallowed=0;
            j=pos+strlen(binary_operators[i]);  while ((j<strlen(line))&&(line[j]==' ')) ++i;
            if ((j>=strlen(line))||(strchr(post_opchars,line[j])))
              opallowed=0;

            if (!opallowed) continue;

            if ((i==BINOP_DOT)&&(pos>=1)) //Punkt zwischen zwei Zahlen ist kein Operator:
            {
              if (isdigit(line[pos-1])&&isdigit(line[pos+1]))
                continue;
            }
            foundop=i;
            opfound=1;
            binaryleftpos=pos-1;
            binaryrightpos=pos+strlen(binary_operators[i]);
          }
      }// for (i=0; ...
    } //if (bracket==0)
    if (!instring) {
      if (strchr(open_bracket,line[pos])) ++bracket;
      if (strchr(close_bracket,line[pos])) { --bracket; if (bracket<0) { exp_error=1; exp_message="Zu viele \")\""; } }
    }
    if (line[pos]=='\"') {
      if (!instring) instring=1;
      else if (line[pos-1]!='\\') instring=0;}
    ++pos;
  } // while (pos<strlen(line))
  if (opfound)
  { //Rekursionsschritt
    leftop=(char *)malloc(binaryleftpos+2);
    memcpy(leftop, line, binaryleftpos+1); leftop[binaryleftpos+1]=0;
    rightop=(char *)malloc(strlen(line)-binaryrightpos+2);
    memcpy(rightop, line+binaryrightpos, strlen(line)-binaryrightpos+1);
    leftexp=new TExpression(leftop, varlist, FuncList);
    rightexp=new TExpression(rightop, varlist, FuncList);
    leftval=leftexp->evaluate();
    rightval=rightexp->evaluate();
    delete leftexp; delete rightexp; free(leftop); free(rightop);
    if (exp_error) return ret;
    return postprocess(EvalBinaryOp(leftval, rightval, foundop));
  }

//Schritt II: Nach unaeren Praefixoperatoren suchen
  pos=0;foundop=10000;opfound=0;bracket=0;instring=0;
  while (pos<strlen(line))
  {
    while (line[pos]==' ') ++pos;
    if ((bracket==0)&&!instring)
    {
      opallowed=0;
      i=pos-1;  while ((i>=0)&&(line[i]==' ')) --i;
      if ((i<0)||(strchr(pre_opchars,line[i])))
        opallowed=1;

      if (opallowed)
      {
        for (i=0; (prefix_operators[i]!=NULL)&&(i<foundop); ++i) //Nur nach Operatoren mit niedrigerer Prioritt als schon gefundene suchen
        {
          if (!strncmp(line+pos, prefix_operators[i], strlen(prefix_operators[i])))
          {  //Binrer Operator gefunden!
            foundop=i;
            opfound=1;
            prefixpos=pos+strlen(prefix_operators[i]);
          }
        }// for (i=0; ...
      } //if (opallowed)
    } //if (bracket==0)
    if (!instring) {
      if (strchr(open_bracket,line[pos])) ++bracket;
      if (strchr(close_bracket,line[pos])) { --bracket; if (bracket<0) { exp_error=1; exp_message="missing brackets"; return ret;} }
    }
    if (line[pos]=='\"') {
      if (!instring) instring=1;
      else if (line[pos-1]!='\\') instring=0;}
    ++pos;
  } // while (pos<strlen(line))

  if (bracket!=0) { exp_error=1; exp_message="missing brackets"; return ret;}

  if (opfound)
  {
    rightop=(char *)malloc(strlen(line)-prefixpos+2);
    strcpy(rightop, line+prefixpos);
    rightexp=new TExpression(rightop, varlist, FuncList);
    rightval=rightexp->evaluate();
    delete rightexp; free(rightop);
    if (exp_error) return ret;
    return postprocess(EvalPrefixOp(rightval, foundop));
  }

//Schritt III: Nach unaeren Postfixoperatoren suchen
  pos=0;foundop=10000;opfound=0;bracket=0;instring=0;
  while (pos<strlen(line))
  {
    while (line[pos]==' ') ++pos;
    if ((bracket==0)&&!instring)
    {
      opallowed=0;
      i=pos+1;  while ((i<strlen(line))&&(line[i]==' ')) ++i;
      if ((i>=strlen(line))||(strchr(post_opchars,line[i])))
        opallowed=1;
      if (opallowed)
      {
        for (i=0; (postfix_operators[i]!=NULL)&&(i<foundop); ++i) //Nur nach Operatoren mit niedrigerer Prioritt als schon gefundene suchen
        {
          if (!strncmp(line+pos, postfix_operators[i], strlen(postfix_operators[i])))
          {  //Binaerer Operator gefunden!
            foundop=i;
            opfound=1;
            postfixpos=pos;
          }
        }// for (i=0; ...
      } //if (opallowed)
    } //if (bracket==0)
    if (!instring) {
      if (strchr(open_bracket,line[pos])) ++bracket;
      if (strchr(close_bracket,line[pos])) { --bracket; if (bracket<0) { exp_error=1; exp_message="Zu viele \")\""; } }
    }
    if (line[pos]=='\"') {
      if (!instring) instring=1;
      else if (line[pos-1]!='\\') instring=0;}
    ++pos;
  } // while (pos<strlen(line))
  if (opfound)
  {
    leftop=(char *)malloc(postfixpos+1);
    memcpy(leftop, line, postfixpos);
    leftop[postfixpos]=0;
    leftexp=new TExpression(leftop, varlist, FuncList);
    leftval=leftexp->evaluate();
    delete leftexp; free(leftop);
    if (exp_error) return ret;
    return postprocess(EvalPostfixOp(leftval, foundop));
  }

//Schrit IV: Funktionsaufrufe

  char funcname[FUNC_NAMELEN+1];
  for (i=0; (i<strlen(line))&&isalpha(line[i]); ++i) funcname[i]=line[i];
  funcname[i]=0;

//       IV.1: Fertige Funktionen
  for (i=0; exp_functions[i]!=NULL; ++i)
  {
    if (!strcmp(funcname, exp_functions[i]))
    {
      TValue *funcargs=(TValue *)malloc(func_argno[i]*sizeof(TValue));
      int mypos;

      leftop=(char *)malloc(strlen(line)+1);
      pos=strlen(exp_functions[i]);
      while (line[pos]==' ') ++pos;
      if (line[pos++]!='(') {exp_error=1; exp_message="\"(\" expected"; return ret; }
      for (j=0; j<func_argno[i];++j)
      {
        bracket=0;
        mypos=0;
        while (((j<func_argno[i]-1)&&(line[pos]!=','))||((j==func_argno[i]-1)&&(line[pos]!=')')))
        {
          leftop[mypos]=line[pos];
          if (strchr(open_bracket,line[pos])) ++bracket;
          while (bracket)
          {
            leftop[++mypos]=line[++pos];
            if (strchr(open_bracket,line[pos])) ++bracket;
            if (strchr(close_bracket,line[pos])) --bracket;
            if (pos==strlen(line)) { exp_error=1; exp_message="missing argument(s)"; return ret;}
          } //while (bracket)
          ++mypos; ++pos;
          if (pos==strlen(line)) { exp_error=1; exp_message="missing argument(s)"; return ret;}
        } //while ..!=',' ..
        leftop[mypos]=0;
        leftexp=new TExpression(leftop, varlist, FuncList);
        funcargs[j]=leftexp->evaluate();
        delete leftexp;
        if (exp_error) {free(funcargs); free(leftop); return ret;}
        ++pos;
      } //for (j=0;..-
      free(leftop);
      ret=EvalFunction(funcargs, i);
      free(funcargs);
      return postprocess(ret);
    } //if (!strncmp...
  }//for (i=0, ..

//        IV.2: User functions
  for (FuncPos=FuncList; FuncPos!=NULL; FuncPos=FuncPos->next)
  {
    if (!strcmp(funcname, FuncPos->funcname))
    {
      TValue *funcargs=(TValue *)malloc(FuncPos->argno*sizeof(TValue));
      int mypos;

      leftop=(char *)malloc(strlen(line)+1);
      pos=strlen(FuncPos->funcname);
      while (line[pos]==' ') ++pos;
      if (line[pos++]!='(') {exp_error=1; exp_message="\"(\" expected"; return ret; }
      for (j=0; j<FuncPos->argno;++j)
      {
        bracket=0;
        mypos=0;
        while ((j<FuncPos->argno-1)?(line[pos]!=','):(line[pos]!=')'))
        {
          leftop[mypos]=line[pos];
          if (strchr(open_bracket,line[pos])) ++bracket;
          if (line[pos]=='\"') instring=1;
          while (bracket||instring)
          {
            leftop[++mypos]=line[++pos];
            if (!instring){
              if (strchr(open_bracket,line[pos])) ++bracket;
              if (strchr(close_bracket,line[pos])) --bracket;
            }
            if (line[pos]=='\"') {
              if (!instring) instring=1;
              else if (line[pos-1]!='\\') instring=0;
            }
            if (pos==strlen(line)) { exp_error=1; exp_message="missing argument(s)"; return ret;}
          } //while (bracket)
          ++mypos; ++pos;
          if (pos==strlen(line)) { exp_error=1; exp_message="missing argument(s)"; return ret;}
          if (line[pos]==((j<FuncPos->argno-1)?')':',')){
            exp_error=1; exp_message=(j<FuncPos->argno-1)?"missing argument(s)":"too many arguments"; return ret;}
        } //while ..!=',' ..
        leftop[mypos]=0;
        leftexp=new TExpression(leftop, varlist, FuncList);
        funcargs[j]=leftexp->evaluate();
        if (funcargs[j].type==VARTYPE_DOUBLE)
        {
          if (FuncPos->argtype[j]=='D');
          else if (FuncPos->argtype[j]=='I') { funcargs[j].type=VARTYPE_INTEGER; funcargs[j].value.intval=(int)funcargs[j].value.dblval; }
          else if (FuncPos->argtype[j]=='S') { sprintf(exp_tmpstr,"%lg",funcargs[j].value.dblval); funcargs[j].type=VARTYPE_STRING; funcargs[j].value.stringno=AddStringToTable(exp_tmpstr);}
          else { exp_error=1; exp_message="Vector expected but double given";}
        }
        else if (funcargs[j].type==VARTYPE_INTEGER)
        {
          if (FuncPos->argtype[j]=='I');
          else if (FuncPos->argtype[j]=='D') { funcargs[j].type=VARTYPE_DOUBLE; funcargs[j].value.dblval=funcargs[j].value.intval; }
          else if (FuncPos->argtype[j]=='S') { sprintf(exp_tmpstr,"%ld",funcargs[j].value.intval); funcargs[j].type=VARTYPE_STRING; funcargs[j].value.stringno=AddStringToTable(exp_tmpstr);}
          else { exp_error=1; exp_message="Vector expected but integer given";}
        }
        else if (funcargs[j].type==VARTYPE_VECTOR)
        {
          if (FuncPos->argtype[j]=='V');
          else { exp_error=1; exp_message=FuncPos->argtype[j]=='S'?"String expected but vector given":"Scalar expected but vector given";}
        }
        else if (funcargs[j].type==VARTYPE_STRING)
        {
          if (FuncPos->argtype[j]!='S')
          { exp_error=1; exp_message=FuncPos->argtype[j]=='V'?"Vector expected but string given":"Scalar expected but string given";}
        }
        delete leftexp;
        if (exp_error) {free(funcargs); free(leftop); return ret;}
        ++pos;
      } //for (j=0;..-
      free(leftop);
      ret=FuncPos->EvalFunc(funcargs, FuncPos->data);
      free(funcargs);
      return postprocess(ret);
    } //if (!strncmp...
  }//for (i=0, ..

//Schritt V: Variable
  for (TVariable *varlauf=varlist; varlauf!=NULL; varlauf=varlauf->next)
  {
    if (!strncmp(line, varlauf->varname, VARNAME_MAXLENGTH))
      return postprocess(varlauf->value);
  }

//Schritt VI: Vektor
  if (line[0]=='[') //Vektor
  {
    int mypos=0;
    ret.type=VARTYPE_VECTOR;
    leftop=(char *)malloc(strlen(line)+1);
    pos=1;
    for (j=0; j<3;++j)
    {
      bracket=0;
      mypos=0;
      while (((j<2)&&(line[pos]!=','))||((j==2)&&(line[pos]!=']')))
      {
        leftop[mypos]=line[pos];
        if (strchr(open_bracket,line[pos])) ++bracket;
        while (bracket)
        {
          leftop[++mypos]=line[++pos];
          if (strchr(open_bracket,line[pos])) ++bracket;
          if (strchr(close_bracket,line[pos])) --bracket;
          if (pos==strlen(line)) { exp_error=1; exp_message="missing vector component"; return ret;}
        } //while (bracket)
        ++mypos; ++pos;
        if (pos==strlen(line)) { exp_error=1; exp_message="missing vector component"; return ret;}
      } //while ..!=',' ..
      leftop[mypos]=0;
      leftexp=new TExpression(leftop, varlist, FuncList);
      tmp=leftexp->evaluate();
      if (exp_error) {free(leftop); return ret;}
      if (tmp.type==VARTYPE_VECTOR) { exp_error=1; exp_message="vector given as vector component"; free(leftop); return ret;}
      else if (tmp.type==VARTYPE_INTEGER) {switch(j){case 0:ret.value.vectval.x=(double)tmp.value.intval;break;
                                                     case 1:ret.value.vectval.y=(double)tmp.value.intval;break;
                                                     case 2:ret.value.vectval.z=(double)tmp.value.intval;break;}}
      else if (tmp.type==VARTYPE_DOUBLE) {switch(j){case 0:ret.value.vectval.x=tmp.value.dblval;break;
                                                    case 1:ret.value.vectval.y=tmp.value.dblval;break;
                                                    case 2:ret.value.vectval.z=tmp.value.dblval;break;}}
      delete leftexp;
      ++pos;
    } //for (j=0;..-
    return postprocess(ret);
  }

//Schritt VII: String
  if (line[0]=='\"')
    return EvaluateString();

//Schritt VIII: Zahl

  if (!isdigit(line[0])) { exp_error=1; exp_message="unkwnown expression"; return ret; }
  if (!strchr(line,'.') && !strchr(line,'e') && !strchr(line,'E')) //reiner Integer
  {
    ret.type=VARTYPE_INTEGER;
    ret.value.intval=0;
    pos=0;
    while (pos<strlen(line))
    {
      if (!isdigit(line[pos])) {exp_error=1; exp_message="unkwown expression"; return ret;}
      if (ret.value.intval>=INT_MAX/10) goto eval_double; //Zahl zu gross fr Int -> double draus machen
      ret.value.intval*=10;
      ret.value.intval+=(int)(line[pos]-'0');
      if (ret.value.intval<0) goto eval_double; //Ueberlauf -> als double-Zahl interpretieren
      ++pos;
    }
    return postprocess(ret);
  }
eval_double:

  pos=0;
  double mantissa=0;
  int exp=0, expsign=1, myexp=0;
  while ((pos<strlen(line))&&(toupper(line[pos])!='E')&&(line[pos]!='.'))
  {
    if (!isdigit(line[pos])) {exp_error=1; exp_message="unkwown expression"; return ret;}
    mantissa*=10.0;
    mantissa+=(double)(line[pos]-'0');
    ++pos;
  }
  if (line[pos]=='.')
  {
    ++pos;
    while ((pos<strlen(line))&&(toupper(line[pos])!='E'))
    {
      if (!isdigit(line[pos])) {exp_error=1; exp_message="unkwown expression"; return ret;}
      mantissa*=10.0;
      mantissa+=(double)(line[pos]-'0');
      myexp--;
      ++pos;
    }
  }
  if (toupper(line[pos])=='E')
  {
    ++pos;
    if (line[pos]=='-') {expsign=-1; ++pos;}
    else if (line[pos]=='+') {expsign=1; ++pos;}
    while (pos<strlen(line))
    {
      if (!isdigit(line[pos])) {exp_error=1; exp_message="unkwown expression"; return ret;}
      exp*=10;
      exp+=(int)(line[pos]-'0');
      ++pos;
    }
  }
  if (exp*expsign+myexp!=0)
    mantissa*=pow(10.0, (double)(exp*expsign+myexp));
  ret.type=VARTYPE_DOUBLE;
  ret.value.dblval=mantissa;
  return postprocess(ret);
}


TValue TExpression::EvaluateString(void)
{
  int pos=0;
  int strpos=0;
  char str[STRING_LENGTH];
  TValue ret;

  ++pos; //An 0 steht '"'
  while ((line[pos]!='\"')&&(pos<strlen(line))&&(strpos<STRING_LENGTH-2))
  {
    if (line[pos]!='\\') str[strpos++]=line[pos++];
    else{
      switch(line[pos+1])
      {
        case '\\': str[strpos++]='\\'; break;
        case '\"': str[strpos++]='\"'; break;
        case 'n' : str[strpos++]='\n'; break;
        case 'r' : str[strpos++]='\r'; break;
        default  : str[strpos++]=line[pos+1]; break;
      }
      pos+=2;
    }
  }
  if (pos>=strlen(line))
  { exp_error=1; exp_message="Unterminated string constant"; return ret;}
  if (strpos>=STRING_LENGTH-2)
  { exp_error=1; exp_message="String constant too long"; return ret;}
  str[strpos]=0;
  ret.type=VARTYPE_STRING;
  ret.value.stringno=AddStringToTable(str);
  return ret;
}

TValue TExpression::EvalFunction(TValue *args, int funcid)
{
  double op;
  TValue ret;
  double &dblret=ret.value.dblval;

  if (funcid<DBL_FUNC_NO)
  {
    if (args[0].type==VARTYPE_INTEGER) op=(double)(args[0].value.intval);
    else if (args[0].type==VARTYPE_DOUBLE) op=args[0].value.dblval;
    else {exp_error=1; exp_message="Bad arguments to function"; return ret;}
    ret.type=VARTYPE_DOUBLE;
    switch(funcid)
    {
      case FUNC_SIN:  dblret=sin(op); break;
      case FUNC_COS:  dblret=cos(op); break;
      case FUNC_TAN:  dblret=tan(op); break;
      case FUNC_ASIN: dblret=asin(op);break;
      case FUNC_ACOS: dblret=asin(op);break;
      case FUNC_ATAN: dblret=atan(op);break;
      case FUNC_SINH: dblret=sinh(op);break;
      case FUNC_COSH: dblret=cosh(op);break;
      case FUNC_TANH: dblret=tanh(op);break;
      case FUNC_ASINH:dblret=asinh(op);break;
      case FUNC_ACOSH:dblret=acosh(op);break;
      case FUNC_ATANH:dblret=atanh(op);break;
      case FUNC_EXP:  dblret=exp(op); break;
      case FUNC_LOG:  dblret=log10(op);break;
      case FUNC_LN:   dblret=log(op); break;
      case FUNC_SQRT: dblret=sqrt(op);break;
    }
  }
  return ret;
}

TValue TExpression::EvalPostfixOp(TValue leftval, int opid)
{
  TValue ret;
  int i;

  if (leftval.type==VARTYPE_STRING)
  {
    exp_error=1; exp_message="No arithmetics allowed with strings"; return ret;
  }

  switch(opid)
  {
    case POSTOP_FAC:
      if (leftval.type!=VARTYPE_INTEGER) { exp_error=1; exp_message="!: Operand does not match"; return ret;}
      else { ret.type=VARTYPE_INTEGER; ret.value.intval=1; for (i=2; i<=leftval.value.intval;++i) ret.value.intval*=i;}
      break;
    case POSTOP_DEG:
      ret.type=VARTYPE_DOUBLE;
      if (leftval.type==VARTYPE_INTEGER) ret.value.dblval=(double)leftval.value.intval*M_PI/180.0;
      else if (leftval.type==VARTYPE_DOUBLE) ret.value.dblval=leftval.value.dblval*M_PI/180.0;
      else { exp_error=1; exp_message=": Operand does not mach"; return ret;}
      break;
  }
  return ret;
}

TValue TExpression::EvalPrefixOp(TValue rightval, int opid)
{
  TValue ret=rightval;

  if (rightval.type==VARTYPE_STRING)
  {
    exp_error=1; exp_message="No arithmetics allowed with strings"; return ret;
  }

  switch(opid)
  {
    case PREOP_PLUS:
      return rightval;
    case PREOP_MINUS:
      switch(rightval.type)
      {
        case VARTYPE_INTEGER: ret.value.intval*=-1; break;
        case VARTYPE_DOUBLE:  ret.value.dblval*=-1; break;
        case VARTYPE_VECTOR:  ret.value.vectval.x*=-1;
                              ret.value.vectval.y*=-1;
                              ret.value.vectval.z*=-1; break;
      }
      break;
    case PREOP_NOT:
      if (rightval.type!=VARTYPE_INTEGER)
      { exp_error=1; exp_message="!: Operand does not match"; }
      else ret.value.intval=!ret.value.intval;
      break;
    case PREOP_DOUBLE:
      ret.type=VARTYPE_DOUBLE;
      switch(rightval.type)
      {
        case VARTYPE_INTEGER: ret.value.dblval=(double)ret.value.intval; break;
        case VARTYPE_DOUBLE:  break;
        case VARTYPE_VECTOR:  ret.value.dblval=sqrt(ret.value.vectval.x*ret.value.vectval.x
                                                   +ret.value.vectval.y*ret.value.vectval.y
                                                   +ret.value.vectval.z*ret.value.vectval.z);
      }
      break;
    case PREOP_INT:
      ret.type=VARTYPE_INTEGER;
      switch(rightval.type)
      {
        case VARTYPE_INTEGER: break;
        case VARTYPE_DOUBLE:  ret.value.intval=(int)ret.value.dblval; break;
        case VARTYPE_VECTOR:  exp_error=1; exp_message="(int): Operand does not match"; break;
      }
      break;
    case PREOP_STRING:
      ret.type=VARTYPE_STRING;
      char *s=(char *)malloc(STRING_LENGTH);
      switch(rightval.type)
      {
        case VARTYPE_INTEGER: sprintf(s,"%ld",rightval.value.intval); break;
        case VARTYPE_DOUBLE:  sprintf(s,"%lg",rightval.value.dblval); break;
        case VARTYPE_VECTOR:  sprintf(s,"[%lg,%lg,%lg]",rightval.value.vectval.x, rightval.value.vectval.y, rightval.value.vectval.z); break;
        case VARTYPE_STRING:  free(s); return ret; break;
      }
      ret.value.stringno=AddStringToTable(s); free(s);
      break;
  }
  return ret;
}


TValue TExpression::EvalBinaryOp(TValue leftval, TValue rightval, int opid)
{
  TValue ret;
  TVector leftvect, rightvect, retvect;
  double &leftdbl=leftval.value.dblval, &rightdbl=rightval.value.dblval;
  int &leftint=leftval.value.intval, &rightint=rightval.value.intval;
  double dbl1, dbl2, retdbl;
  char *s1, *s2;

  if ((leftval.type==VARTYPE_STRING)||(rightval.type==VARTYPE_STRING))
  {
    if ((leftval.type==VARTYPE_STRING)&&(rightval.type==VARTYPE_STRING)&&(opid==BINOP_PLUS))
    {
      s1=GetStringFromTable(leftval.value.stringno);
      s2=GetStringFromTable(rightval.value.stringno);
      if (strlen(s1)+strlen(s2)>=STRING_LENGTH-1) {exp_error=1; exp_message="String length overflow"; return ret;}
      char *s3=(char *)malloc(STRING_LENGTH);
      strcpy(s3,s1);
      strcat(s3,s2);
      ret.type=VARTYPE_STRING;
      ret.value.stringno=AddStringToTable(s3);
      free(s3);
      return ret;
    }
    else {exp_error=1; exp_message="No arithmetics allowed with strings"; return ret;}
  }

  if (leftval.type==VARTYPE_VECTOR)
    leftvect.init(leftval.value.vectval.x, leftval.value.vectval.y, leftval.value.vectval.z);
  if (rightval.type==VARTYPE_VECTOR)
    rightvect.init(rightval.value.vectval.x, rightval.value.vectval.y, rightval.value.vectval.z);

  if (leftval.type==VARTYPE_INTEGER) dbl1=leftval.value.intval; else dbl1=leftval.value.dblval;
  if (rightval.type==VARTYPE_INTEGER) dbl2=rightval.value.intval; else dbl2=rightval.value.dblval;

  switch(opid)
  {
    case BINOP_COMMA:
      return rightval;
      break;
    case BINOP_EQ:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint==rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl==(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint==rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl==rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(rightvect==leftvect);
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_NEQ:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint!=rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl!=(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint!=rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl!=rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(((leftval.value.vectval.x!=rightval.value.vectval.x))
                                                                                                 &&((leftval.value.vectval.y!=rightval.value.vectval.y))
                                                                                                 &&((leftval.value.vectval.z!=rightval.value.vectval.z)));
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_LEQ:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint<=rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl<=(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint<=rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl<=rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(((leftval.value.vectval.x<=rightval.value.vectval.x))
                                                                                                 &&((leftval.value.vectval.y<=rightval.value.vectval.y))
                                                                                                 &&((leftval.value.vectval.z<=rightval.value.vectval.z)));
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_GEQ:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint>=rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl>=(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint>=rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl>=rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(((leftval.value.vectval.x>=rightval.value.vectval.x))
                                                                                                 &&((leftval.value.vectval.y>=rightval.value.vectval.y))
                                                                                                 &&((leftval.value.vectval.z>=rightval.value.vectval.z)));
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_LESS:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint<rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl<(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint<rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl<rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(((leftval.value.vectval.x<rightval.value.vectval.x))
                                                                                                 &&((leftval.value.vectval.y<rightval.value.vectval.y))
                                                                                                 &&((leftval.value.vectval.z<rightval.value.vectval.z)));
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_GREATER:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint>rightint);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftdbl>(double)rightint);
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=((double)leftint>rightdbl);
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) ret.value.intval=(leftdbl>rightdbl);
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) ret.value.intval=(((leftval.value.vectval.x>rightval.value.vectval.x))
                                                                                                 &&((leftval.value.vectval.y>rightval.value.vectval.y))
                                                                                                 &&((leftval.value.vectval.z>rightval.value.vectval.z)));
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_AND:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint&&rightint);
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_OR:
      ret.type=VARTYPE_INTEGER;
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) ret.value.intval=(leftint||rightint);
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_PLUS:
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=leftint+rightint;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl+rightint;}
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftint+rightdbl;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl+rightdbl;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_VECTOR; retvect=leftvect+rightvect;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_MINUS:
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=leftint-rightint;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl-rightint;}
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftint-rightdbl;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl-rightdbl;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_VECTOR; retvect=leftvect-rightvect;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_MULT:
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=leftint*rightint;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl*rightint;}
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftint*rightdbl;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl*rightdbl;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_VECTOR; retvect.init(leftvect,rightvect);}
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_VECTOR; retvect=rightvect*(double)leftint;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_VECTOR; retvect=rightvect*leftdbl;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_VECTOR; retvect=leftvect*(double)rightint;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_VECTOR; retvect=leftvect*rightdbl;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_DIV:
      if (rightval.type==VARTYPE_INTEGER)
        if (rightint==0) {exp_error=1; exp_message="Division durch 0"; return ret;}
      if (rightval.type==VARTYPE_DOUBLE)
        if (rightdbl==0) {exp_error=1; exp_message="Division durch 0"; return ret;}
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=leftint/rightint;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl/rightint;}
      else if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftint/rightdbl;}
      else if ((leftval.type==VARTYPE_DOUBLE)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftdbl/rightdbl;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_VECTOR; retvect=leftvect/(double)rightint;}
      else if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_DOUBLE)) {ret.type=VARTYPE_VECTOR; retvect=leftvect/rightdbl;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_DOT:
      if ((leftval.type==VARTYPE_VECTOR)&&(rightval.type==VARTYPE_VECTOR)) {ret.type=VARTYPE_DOUBLE; ret.value.dblval=leftvect*rightvect;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_MOD:
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=leftint%rightint;}
      else {exp_error=1; exp_message="Operands to not match"; return ret; }
      break;
    case BINOP_EXP:
      if ((leftval.type==VARTYPE_VECTOR)||(rightval.type==VARTYPE_VECTOR))
        {exp_error=1; exp_message="Operands to not match"; return ret; }
      retdbl=pow(dbl1, dbl2);
      if ((leftval.type==VARTYPE_INTEGER)&&(rightval.type==VARTYPE_INTEGER)) {ret.type=VARTYPE_INTEGER; ret.value.intval=(int)retdbl; }
      else {ret.type=VARTYPE_DOUBLE; ret.value.dblval=retdbl;}
  }
  if (ret.type==VARTYPE_VECTOR)
  {
    ret.value.vectval.x=retvect.x;
    ret.value.vectval.y=retvect.y;
    ret.value.vectval.z=retvect.z;
  }
  return ret;
}

///////////////////////////////////////////////////////////////////////////////


int CurGlobalStringtableID=0;

int AddStringToTable(char *str)
{
  TStringEntry *MyEntry=(TStringEntry*)malloc(sizeof(TStringEntry));
  MyEntry->next=GlobalStringTable;
  if (GlobalStringTable!=NULL) GlobalStringTable->pre=MyEntry;
  GlobalStringTable=MyEntry;
  MyEntry->stringno=++CurGlobalStringtableID;
  strcpy(MyEntry->string, str);
  return CurGlobalStringtableID;
}

void StringTableGarbageCollect(TVariable *varlist)
{
  TStringEntry *CurEntry=GlobalStringTable, *Temp;
  TVariable *CurVar;
  while(CurEntry!=NULL)
  {
    CurEntry->mark=1;
    CurEntry=CurEntry->next;
  }
  for(CurVar=varlist; CurVar!=NULL; CurVar=CurVar->next)
  {
    if (CurVar->value.type!=VARTYPE_STRING) continue;
    for (CurEntry=GlobalStringTable; CurEntry!=NULL; CurEntry=CurEntry->next)
      if (CurEntry->stringno==CurVar->value.value.stringno) CurEntry->mark=0;
  }
  for (CurEntry=GlobalStringTable; CurEntry!=NULL;)
  {
    if (!CurEntry->mark) {CurEntry=CurEntry->next; continue;}
    if (CurEntry->pre==NULL) {
      GlobalStringTable=CurEntry->next;
      free(CurEntry);
    } else {
      CurEntry->pre->next=CurEntry->next;
      CurEntry->next->pre=CurEntry->pre;
      free(CurEntry);
    }
  }
}

char *GetStringFromTable(int stringno)
{
  TStringEntry *CurEntry=GlobalStringTable;
  while (CurEntry!=NULL)
  {
    if (CurEntry->stringno==stringno) return CurEntry->string;
    CurEntry=CurEntry->next;
  }
  return "";
}