#ifndef EXP_PARSER_H

#define EXP_PARSER_H

#include"tvector.h"

/******************** Teil I : Syntaxanalyse fr Ausdrcke ************************/

#define VARNAME_MAXLENGTH 20  //Auf dieser Lnge werden Variablennamen unterschieden
#define STRING_LENGTH    255  //Lnge von String-Variablen

#define VARTYPE_DOUBLE  1
#define VARTYPE_VECTOR  2
#define VARTYPE_INTEGER 3
#define VARTYPE_STRING  4

typedef struct{
  double x; double y; double z;
} tinyvect;

typedef struct tagStringEntry {
  int stringno;
  char string[STRING_LENGTH];
  struct tagStringEntry *next, *pre;
  char mark;
} TStringEntry;

extern TStringEntry *GlobalStringTable;


typedef struct{
  int type;
  union {
    double dblval;
    tinyvect vectval;
    int intval;
    int stringno;
  } value;
} TValue;


typedef struct tagVariable{
  char varname[VARNAME_MAXLENGTH+1];
  TValue value;
  struct tagVariable *next;
  int isconstant;
} TVariable;

typedef struct tagUserFunction{
  char *funcname;
  int argno;
  char *argtype; //I:Integer, V:Vector, D:Double
  void *data;    //Hier knnen noch Benutzerdaten gespeichert sein
  TValue (*EvalFunc)(TValue *vals, void *data);
  struct tagUserFunction *next;
} TUserFunction;


extern int exp_error;
extern char *exp_message;

int AddStringToTable(char *str);
void StringTableGarbageCollect(TVariable *varlist);
char *GetStringFromTable(int stringno);


class TExpression {
  TVariable *varlist;
  char *line;
  TVariable **var4inc; int incnum;
  TVariable **var4dec; int decnum;
  TVariable *var4assign;
  TUserFunction *FuncList;

  void strip();        //Leerzeichen am Anfang und am Ende, sowie ( und ) entfernen
  TValue EvalBinaryOp(TValue leftval, TValue rightval, int opid);
  TValue EvalPrefixOp(TValue rightval, int opid);
  TValue EvalPostfixOp(TValue leftval, int opid);
  TValue EvalFunction(TValue *args, int funcid);

  void preprocess();
  TValue postprocess(TValue retval);
  TValue EvaluateString(void);
public:
  TExpression (char *pline, TVariable *pvarlist, TUserFunction *pFuncList);
  ~TExpression();
  TValue evaluate();
};

#endif