/****************************************************************************/
/* HIGHFIEL - Hhenfelder - Landschaften, Funktioneplots etc.               */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<math.h>
#include<stdlib.h>
#include<stdarg.h>
#include"tvector.h"
#include"ray20.h"
#include"objects.h"
#include"syntax.h"
#include"readbmp.h"

#define sqr(x) ((x)*(x))
#define max(a,b) ((a)>(b)?(a):(b))

THeightField::THeightField(int pxpoints, int pypoints)
{
  heights=(double*)malloc(sizeof(double)*(xpoints=pxpoints)*(ypoints=pypoints));
  TheCube=new TCube;
  needssubprocessing=1;
}

THeightField::~THeightField()
{
  free(heights);
  delete TheCube;
}


#define getheight(x,y) (heights[(int)(y)*xpoints+(int)(x)])
#define getmapx(x) (((x)+0.5)*(xpoints-1))
#define getmapy(y) (((y)+0.5)*(ypoints-1))
#define getrealx(x) ((double)(x)/(xpoints-1)-0.5)
#define getrealy(y) ((double)(y)/(ypoints-1)-0.5)


#define getside(x,y,z) (getheight(x,y)<(z))               //1 wenn der Punkt unter der Flche liegt

void THeightField::SubProcessRay()
{
  TheCube->SetRay(nstart, ndir, nmaxt);
}


char THeightField::Obj_NextCut(double &t)
/* Funktionsweise: Alle Polygone, die der Lichtstrahl bequert, werden per 2D-Linien-Algorithmus */
/* ermittelt. Jedes Polygon wird dann im Speicher erzeugt und der Schnittpunkt wird ausgerechnet.*/
{
  TVector curpoint;                                       //Aktuell zu bearbeitender Punkt auf der Linie
  double mapx,mapy;                                       //x/y - Pos, projiziert auf Landkarte
  double xyst,yxst;                                       //Steigungen: x/y und y/x
  double tmpx,tmpy;                                       //Zwischenvariablen
  double deltaheight;                                     //Hhenunterschied/Schritt
  double curheight;
  int x,y;
  int i1,i2,oldmap;
  char side;
  
  TTriangle *TheTriangle;
  TVector v1,v2,v3,v4;

  TheCube->SetStart(lastt);

  if (nstart.x>-0.5 && nstart.x<0.5 && nstart.y>-0.5 && nstart.y<0.5 && nstart.z>-0.5 && nstart.z<0.5)
    curpoint=nstart;                                       //Wenn der Startpunkt im Wrfel ist, direkt loslogen
  else
    if (!TheCube->NextCut(t))                              //Ansonten: Umgebender Wrfel -> Startpunkt
      return 0;                                            //Lichtstrahl geht "woanders" her

  curpoint=nstart+ndir*t;
  mapx=getmapx(curpoint.x);
  mapy=getmapy(curpoint.z);
  tmpx=getmapx(curpoint.x+ndir.x);
  tmpy=getmapy(curpoint.z+ndir.z);
  curheight=curpoint.y;
  side=Obj_InObject(t);
  if (fabs(tmpx-mapx)>fabs(tmpy-mapy))                     //X-Werte ndern sich schneller
  {
    yxst=(tmpy-mapy)/fabs(tmpx-mapx);
    if (tmpx>mapx) xyst=1; else xyst=-1;
    deltaheight=ndir.y*xyst/(xpoints-1)/ndir.x;
    curheight+=deltaheight;
    oldmap=mapy;
    for (x=mapx;x<xpoints-1 && x>=0 && mapy<ypoints-1 && mapy>=0;x+=xyst,mapy+=yxst,curheight+=deltaheight)
    {
      if (curheight-2*deltaheight>0.5 && deltaheight>0) return 0;
      if (curheight+2*deltaheight<-0.5 && deltaheight<0) return 0;
      i1=(mapy<oldmap?mapy:oldmap)-1;
      i2=(mapy>oldmap?mapy:oldmap)+1;
      oldmap=mapy;

      for (y=i1;y<=i2;++y)
      {
        if (y<0) continue;
        if (y>=ypoints-1) continue;
        v1.init(getrealx(x),getheight(x,y),getrealy(y));
        v2.init(getrealx(x+1),getheight(x+1,y),getrealy(y));
        v3.init(getrealx(x+1),getheight(x+1,y+1),getrealy(y+1));
        v4.init(getrealx(x),getheight(x,y+1),getrealy(y+1));
        if (getside(x,y,curheight)==side)
        if (getside(x+1,y,curheight)==side)
        if (getside(x+1,y+1,curheight)==side)
        if (getside(x,y+1,curheight)==side)
          continue;
        TheTriangle=new TTriangle(v3,v2,v1);
        TheTriangle->SetRay(nstart, ndir, nmaxt);
        TheTriangle->SetStart(lastt);
        if (TheTriangle->Obj_NextCut(t))
        {
          normvect=TheTriangle->Obj_GetNormVect();
          delete TheTriangle;
          return 1;
        }
        delete TheTriangle;
        TheTriangle=new TTriangle(v4,v3,v1);
        TheTriangle->SetRay(nstart, ndir, nmaxt);
        TheTriangle->SetStart(lastt);
        if (TheTriangle->Obj_NextCut(t))
        {
          normvect=TheTriangle->Obj_GetNormVect();
          delete TheTriangle;
          return 1;
        }
        delete TheTriangle;
      }
    }
    return 0;
  }
  else                                                     //Y-Werte ndern sich schneller
  {
    xyst=(tmpx-mapx)/fabs(tmpy-mapy);
    if (tmpy>mapy) yxst=1; else yxst=-1;
    deltaheight=ndir.y*yxst/(ypoints-1)/ndir.z;
    curheight+=deltaheight;
    oldmap=mapx;
    for (y=mapy;y<ypoints-1 && y>=0 && mapx<xpoints-1 && mapx>=0;y+=yxst, mapx+=xyst, curheight+=deltaheight)
    {
      if (curheight-2*deltaheight>0.5 && deltaheight>0) return 0;
      if (curheight+2*deltaheight<-0.5 && deltaheight<0) return 0;
      i1=(mapx<oldmap?mapx:oldmap)-1;
      i2=(mapx>oldmap?mapx:oldmap)+1;
      oldmap=mapx;
      for (x=i1;x<=i2;++x)
      {
        if (x<0) continue;
        if (x>=xpoints-1) continue;
        v1.init(getrealx(x),getheight(x,y),getrealy(y));
        v2.init(getrealx(x+1),getheight(x+1,y),getrealy(y));
        v3.init(getrealx(x+1),getheight(x+1,y+1),getrealy(y+1));
        v4.init(getrealx(x),getheight(x,y+1),getrealy(y+1));
        if (getside(x,y,curheight)==side)
        if (getside(x+1,y,curheight)==side)
        if (getside(x+1,y+1,curheight)==side)
        if (getside(x,y+1,curheight)==side)
          continue;
        TheTriangle=new TTriangle(v3,v2,v1);
        TheTriangle->SetRay(nstart, ndir, nmaxt);
        TheTriangle->SetStart(lastt);
        if (TheTriangle->NextCut(t))
        {
          normvect=TheTriangle->GetNormVect();
          delete TheTriangle;
          return 1;
        }
        delete TheTriangle;
        TheTriangle=new TTriangle(v4,v3,v1);
        TheTriangle->SetRay(nstart, ndir, nmaxt);
        TheTriangle->SetStart(lastt);
        if (TheTriangle->NextCut(t))
        {
          normvect=TheTriangle->GetNormVect();
          delete TheTriangle;
          return 1;
        }
        delete TheTriangle;
      }
    }
    return 0;
  }
}

TVector THeightField::Obj_GetNormVect(void)
{
  return normvect;
}

char THeightField::Obj_InObject(double t)
{
  TTriangle *ThePolygon;
  TVector v1,v2,v3,v4;
  TVector p=nstart+ndir*t;
  int x,y;
  char erg;
     
  if (p.x>0.5) return 0;
  if (p.x<-0.5) return 0;
  if (p.y>0.5) return 0;
  if (p.y<-0.5) return 0;
  if (p.z>0.5) return 0;
  if (p.z<-0.5) return 0;
  x=getmapx(p.x);
  y=getmapy(p.z);
  if (x>=xpoints-1) return 0;
  if (y>=ypoints-1) return 0;
  v1.init(getrealx(x),getheight(x,y),getrealy(y));
  v2.init(getrealx(x+1),getheight(x+1,y),getrealy(y));
  v3.init(getrealx(x+1),getheight(x+1,y+1),getrealy(y+1));
  v4.init(getrealx(x),getheight(x,y+1),getrealy(y+1));
  if (p.x-getrealx(x)>p.z-getrealy(y))
    ThePolygon=new TTriangle(v3,v2,v1);
  else
    ThePolygon=new TTriangle(v4,v3,v1);
  ThePolygon->SetRay(nstart, ndir, nmaxt);
  if (ThePolygon->InObject(t)) erg=1;
  else erg=0;
  delete ThePolygon;
 
  return erg;
}

T3dPlot::T3dPlot(int pxpoints, int pypoints, char *function, double x1, double y1, double x2, double y2, int &retval):THeightField(pxpoints,pypoints)
{
  double value,max=-DBL_MAX,min=DBL_MAX;
  int x,y;
  TMathElement *NormList, *UpnList;
  int NormNum, UpnNum;
  if (!makeelemlist(function,&NormList, &NormNum))
  {
    retval=0;
    delete this;
    return;
  }
  klammern(&NormList, NormNum);
  if (!toupn(NormList, NormNum, UpnList, UpnNum))
  {
    retval=0;
    free(NormList);
    free(UpnList);
    delete this;
    return;
  }
  if (tused)
  {
    retval=0;
    free(NormList);
    free(UpnList);
    delete this;
    return;
  }
  retval=1;
  free(NormList);
  for (x=0;x<xpoints;++x)
    for (y=0;y<ypoints;++y)
    {
      value=evaluatexyt(&UpnList, UpnNum,x1+(double)x*(x2-x1)/xpoints,y1+(double)y*(y2-y1)/ypoints);
      getheight(x,y)=value; //getheight ist ein Makro fr den Arrayzugriff
      if (value>max) max=value;
      if (value<min) min=value;
    }
  free(UpnList);
  if (fabs(max-min)<1e-8) max+=0.001;
  for (x=0;x<xpoints;++x)    // auf -0.5 .. 0.5 skalieren
    for (y=0;y<ypoints;++y)
      getheight(x,y)=((getheight(x,y)-min)/(max-min)-0.5)/1.1; // /1.1 wg. "Sicherheitsabstand"
}


/*************************Fraktale Landschaften******************************/
double normrand(double factor)        //Normalverteilter Zufallswert
{
  factor++;
  return (2*( rand()*factor/RAND_MAX+rand()*factor/RAND_MAX+rand()*factor/RAND_MAX  )-3*(factor-1))/32.0;
};

double TLandscape::pointof3(int x1, int y1, int x2, int y2, int x3, int y3, double delta)
{
  double erg;
  erg=(getheight(x1,y1)+getheight(x2,y2)+getheight(x3,y3))/3.0+normrand(delta);
  if (erg>100) erg=100;
  if (erg<-100) erg=-100;
  return erg;
}

double TLandscape::pointof4(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4, double delta)
{
  double erg;
  erg=(getheight(x1,y1)+getheight(x2,y2)+getheight(x3,y3)+getheight(x4,y4))/4.0+normrand(delta);
  if (erg>100) erg=100;
  if (erg<-100) erg=-100;
  return erg;
}

void TLandscape::calcmidsdiag(int space)
{
  int x,y;
  for (x=space;x<xpoints;x+=2*space)
    for (y=space;y<ypoints;y+=2*space)
      getheight(x,y)=pointof4(x-space,y-space, x+space,y-space, x-space,y+space, x+space,y+space, delta);
}

void TLandscape::calcmidshv(int space)
{
  int x,y;

  for (x=space;x<xpoints;x+=2*space)
    for (y=2*space; y<ypoints-space; y+=2*space)
      getheight(x,y)=pointof4(x,y-space, x,y+space, x-space,y, x+space,y, delta);

  for (x=2*space;x<xpoints-space;x+=2*space)
    for (y=space;y<ypoints;y+=2*space)
      getheight(x,y)=pointof4(x,y-space, x,y+space, x-space,y, x+space,y, delta);
    
}

void TLandscape::calcmidsborder(int space)
{
  int i;
  for (i=space;i<xpoints;i+=2*space)
  {
    getheight(i,0)=pointof3(i-space,0, i,space, i+space,0, delta);  //Oberer Rand
    getheight(0,i)=pointof3(0,i-space, space,i, 0,i+space, delta);  //Linker Rand
    getheight(i,ypoints-1)=pointof3(i-space,ypoints-1, i,ypoints-1-space, i+space,ypoints-1, delta); //Unterer Rand
    getheight(xpoints-1,i)=pointof3(xpoints-1,i-space, xpoints-1-space,i, xpoints-1,i+space, delta); //Rechter Rand
  }
}


TLandscape::TLandscape(int size, double fracdim, double pdelta, int psrand, double h1, double h2, double h3, double h4)
 : THeightField(pow(2,size)+1,pow(2,size)+1)
{
  double fracdimval;
  int x,y,i;
  getheight(0,0)=h1;
  getheight(xpoints-1,0)=h2;
  getheight(xpoints-1,ypoints-1)=h3;
  getheight(0,ypoints-1)=h4;
  fracdimval=pow(0.5,(3.0-fracdim)/2.0);
  srand(psrand);
  delta=pdelta;

  for (i=xpoints/2;i>=1;i/=2)
  {
    delta*=fracdimval;
    calcmidsdiag(i);
    delta*=fracdimval;
    calcmidshv(i);
    calcmidsborder(i);
  }

  for (x=0;x<xpoints;++x)
    for (y=0;y<ypoints;++y)
      heights[y*xpoints+x]/=200.0;
}

/*************************Hhenwerte aus BMP-Datei***************************/
TBMPHeightField::TBMPHeightField(int pxpoints, int pypoints, char *filename, int &retval) : THeightField(pxpoints, pypoints)
{
  int x,y;
  int r,g,b;
  TBMPInput *Bmp=new TBMPInput(filename);
  if (Bmp->rgb==NULL)
  {
    retval=0;
    delete Bmp;
    delete this;
    return;
  }
  for (x=0;x<xpoints;++x)
    for (y=0;y<ypoints;++y)
    {
      Bmp->GetPixel(x*Bmp->xsize/xpoints, y*Bmp->ysize/ypoints, r, g, b);
      getheight(x,y)=(r+g+b-3.0*128.0)/(3.0*128.0+2.0)/2.0; //+2.0 fr "Sicherheitsabstand"
    }
  delete Bmp;
  retval=1;
}

/***************************Hoehenwerte werden von aussen festgelegt**********/
TUserHeightField::TUserHeightField(int pxpoints, int pypoints): THeightField(pxpoints,pypoints)
{
  for (int x=0; x<pxpoints; ++x)
    for (int y=0; y<pypoints; ++y)
      getheight(x,y)=0;
}

void TUserHeightField::SetHeight(int x, int y, double height)
{
  double h=height;
  if (h<-0.49) h=-0.49;
  if (h>0.49) h=0.49;
  getheight(x,y)=h;
}