/****************************************************************************/
/* LIGHTS.CPP - Lichtquellen                                                */
/* Hier werden die verschiedensten Lichtquellen implementiert               */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/
#include"tvector.h"
#include"ray20.h"
#include"lights.h"

#define sqr(x) ((x)*(x))

void TOmniLight::getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type)
{
  double distance,distmult;
  double cosvect;
  TVector distvect;

  distvect=cut-pos;
  distance=(double)distvect;
  distmult=intensity/sqr(distance);

  distvect/=distance;
  if (Object->type==TYPE_DUST || Object->subtype==TYPE_DUST)
    cosvect=1;
  else
  {
    cosvect=-distvect*normvect;
    if (cosvect<0)
    {
      red=green=blue=0;
      return;
    }
  }
  if (type==LIGHT)
  {
    cosvect=pow(cosvect,1.0/Object->phongsize);
    red=green=blue=255;
  }
  else
  {
    red=Object->clrred;
    green=Object->clrgreen;
    blue=Object->clrblue;
  }
  red*=clrred*distmult*cosvect/255.0;
  green*=clrgreen*distmult*cosvect/255.0;
  blue*=clrblue*distmult*cosvect/255.0;
}

#pragma warn -par
void TAmbientLight::getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type)
{
  if (type==LIGHT || Object->type==TYPE_DUST || Object->subtype==TYPE_DUST)
  {
    red=green=blue=0;
    return;
  }
  red=Object->clrred;
  green=Object->clrgreen;
  blue=Object->clrblue;

  red*=clrred/255.5;
  green*=clrgreen/255.0;
  blue*=clrblue/255.0;
}
#pragma warn .par

void TSpotLight::getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type)
{
  double distance,distmult;
  double cosvect;
  TVector distvect;

  distvect=cut-pos;
  distance=(double)distvect;
  distmult=intensity/sqr(distance);

  distvect/=distance;
  if (distvect*direct<coslimit)
  {
    red=green=blue=0;
    return;
  }
  if (Object->type==TYPE_DUST || Object->subtype==TYPE_DUST)
    cosvect=1;
  else
  {
    cosvect=-distvect*normvect;
    if (cosvect<0)
    {
      red=green=blue=0;
      return;
    }
  }
  if (type==LIGHT)
  {
    cosvect=pow(cosvect,1.0/Object->phongsize);
    red=green=blue=255;
  }
  else
  {
    red=Object->clrred;
    green=Object->clrgreen;
    blue=Object->clrblue;
  }
  red*=clrred*distmult*cosvect/255.0;
  green*=clrgreen*distmult*cosvect/255.0;
  blue*=clrblue*distmult*cosvect/255.0;
}
