#include"ray20.h"
#ifdef RTPREVIEW
#include"RT/3dstuff.h"  //Echtzeit-Preview
#include"RT/polygons.h" //Echtzeit-Preview
#endif
#include<math.h>


/*****TOmniLight : Punktfrmige Lichtquelle (strahlt in alle Richtungen)****/
class TOmniLight : public TLightSource
{
public:
  TOmniLight(int r, int g, int b, double intens, double x, double y, double z)
    : TLightSource(r,g,b,intens,x,y,z) {type=TYPE_OMNI;};
//r,g,b:Lichtfarbe
//intens: Intensitt des Lichtes
//x,y,z: Position

  void getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type=DIFFUS);
#ifdef RTPREVIEW
  void RT_Create(TLightData *LightData);
#endif
};

/*****TAmbientLight : Ambientes (Hintergrund-) Licht************************/
class TAmbientLight : public TLightSource
{
public:
  TAmbientLight(int r, int g, int b)
    :  TLightSource(r,g,b,0,0,0,0) {shadows=0;type=TYPE_AMBIENT;}
//r,g,b:Lichtfarbe

  void getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type=DIFFUS);
#ifdef RTPREVIEW
  void RT_Create(TLightData *LightData);
#endif
};

/*****TSpotLight : Wie TOmniLight, jedoch nur in bestimmte Richtung*********/
class TSpotLight : public TLightSource
{
public:
  double coslimit;
  TVector direct;
  TSpotLight(int r, int g, int b, double intens, double x, double y, double z, double xr, double yr, double zr, double angle)
    : TLightSource(r,g,b,intens,x,y,z)
//r,g,b:Lichtfarbe
//intens:Lichtintensitt
//x,y,z:Position
//xr,yr,zr: Da Strahlt die Lichtquelle hin
//angle: Winkelbereich, wo hingestrahlt wird
  {
    direct.init(xr-x,yr-y,zr-z);
    direct.normalize();
    coslimit=cos(angle);
    type=TYPE_SPOT;
  }

  void getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type=DIFFUS);
};
