/****************************************************************************/
/* METABALL.C - Metaballs (Blobs)                                           */
/* Basierend auf implizit definierten Oberflchen ("eqnobjs.cc")            */
/* Alle Objekte verden mit Einheitsgre und im Ursprung berechnet,         */
/* Der Rest wird in RAY20.CPP besorgt                                       */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<stdlib.h>
#include<math.h>
#include"objects.h"

#define DIST 2e-3

TMetaBall::TMetaBall(double pborderintens)
{
  type=TYPE_METABALL;
  borderintens=pborderintens;
  srcnum=0;
  Borderpoly=new T3dpoly();
  Borderpoly->setkoeff(borderintens, 0, 0, 0);
  needssubprocessing=1;
}

TMetaBall::~TMetaBall()
{
  for (int i=0; i<srcnum; ++i)
  {
    delete Sphere[i];
    delete SimpleSphere[i];
    delete Src[i];
  }
  delete Borderpoly;
}


void TMetaBall::AddSpherical(double px, double py, double pz, double pintens, double prad)
{
  T3dpoly mb_xpoly, mb_ypoly, mb_zpoly, mb_eins, mb_dist, mb_temp;
  Sphere[srcnum]=new TSphere();
  Sphere[srcnum]->scalex=Sphere[srcnum]->scaley=Sphere[srcnum]->scalez=prad;
  Sphere[srcnum]->pos.x=px; Sphere[srcnum]->pos.y=py; Sphere[srcnum]->pos.z=pz;

  SimpleSphere[srcnum]=new TSphere();
  SimpleSphere[srcnum]->scalex=SimpleSphere[srcnum]->scaley=SimpleSphere[srcnum]->scalez=
    sqrt(prad*prad*(1-sqrt(borderintens/pintens))); //Herzuleiten aus der Oberflaechengleichung fr ein Kugel-Metaball
    
  SimpleSphere[srcnum]->pos.x=px; SimpleSphere[srcnum]->pos.y=py; SimpleSphere[srcnum]->pos.z=pz;
  
  intens[srcnum]=pintens;
  Src[srcnum]=new T3dpoly();
  mb_xpoly.setkoeff(1, 1, 0, 0); mb_xpoly.setkoeff(-px, 0, 0, 0);
  mb_ypoly.setkoeff(1, 0, 1, 0); mb_ypoly.setkoeff(-py, 0, 0, 0);
  mb_zpoly.setkoeff(1, 0, 0, 1); mb_zpoly.setkoeff(-pz, 0, 0, 0);
  mb_eins.setkoeff(1, 0, 0, 0);
  mb_dist=mb_xpoly*mb_xpoly;
  mb_dist+=mb_ypoly*mb_ypoly;
  mb_dist+=mb_zpoly*mb_zpoly;
  mb_dist*=1.0/(prad*prad);
  mb_temp=mb_eins-mb_dist;
  mb_temp*=mb_temp;
  mb_temp*=pintens;
  *(Src[srcnum])=mb_temp;
  ++srcnum;
}

int dblcompare( const void *op1, const void *op2 )
{
  const double *p1 = (const double *) op1;
  const double *p2 = (const double *) op2;
  if (*p1<*p2) return -1;
  return 1;
}

void TMetaBall::SubProcessRay()
{
  for (int i=0; i<srcnum; ++i){
    Sphere[i]->SetRay(nstart, ndir, nmaxt);
    SimpleSphere[i]->SetRay(nstart, ndir, nmaxt);
  }
}

char TMetaBall::Obj_NextCut(double &t)
{
  TEqnObject *MyObject;
  TVector tmpcut, tmpcut2, v, unused;
  int i, j;
  int areanum=0;
  int onlysphere;
  char interesting;
  double *dist=new double[2*srcnum+1];
  double *areastart=new double[2*srcnum+1];
  double *areamid=new double[2*srcnum+1];

  for (i=0; i<srcnum;++i)
  {
    Sphere[i]->SetStart(lastt);
    SimpleSphere[i]->SetStart(lastt);
  }

//Zuerst alle Schnittpunkte mit allen Kugeln bestimmen
  dist[0]=2*DIST; areanum=1; //Hier fangen wir an
  for (i=0;i<srcnum;++i)
  {
    if (!Sphere[i]->NextCut(dist[areanum])) continue; else ++areanum;
    if (!Sphere[i]->NextCut(dist[areanum])) continue; else ++areanum;
  }

  if (areanum==1)
  {
    delete dist; delete areastart; delete areamid;
    return 0; //Kein Schnittpunkt mit irgendeiner Kugel
  }

//Dann aufsteigend sortieren
  qsort(dist, areanum, sizeof(double), dblcompare);

//Array areastart, areamid mit Werten fllen
  for (i=0;i<areanum;++i)
  {
    areastart[i]=dist[i]-DIST;  //Damit ggf. der erste Schnittpunkt nicht verpasst wird, etwas vorher anfangen
  }
  areamid[areanum-1]=areastart[areanum-1]+1;            //Letzter Bereich ist hinter dem letzten Schnittpunkt
  for (i=0; i<areanum-1;++i)
  {
    areamid[i]=(areastart[i+1]+areastart[i])/2.0;
    if (dist[i]>nmaxt)  //Was noch weiter hinten kommt ist nicht mehr interessant
      areanum=i;
  }

//Jetzt alle Bereiche durchgehen
  for (i=0; i<areanum; ++i)
  {
  //Zuerst die Oberflchengleichung fr diesen Bereich bauen
    MyObject=new TEqnObject();
    interesting=0;
    onlysphere=-2;
    for (j=0; j<srcnum; ++j)
    {
      if (Sphere[j]->InObject(areamid[i]))
      {
        *((T3dpoly*)MyObject)+=*(Src[j]);
        interesting=1;
        if (onlysphere>=-1) onlysphere=-1; else onlysphere=j;
      }
    }
    if (!interesting) //Der Punkt liegt ausserhalb aller interessanten Bereiche
    {
      delete MyObject;
      continue;
    }
  //Gibt es in diesem Bereich einen gueltigen Schnittpunkt?
    *((T3dpoly*)MyObject)-=*Borderpoly;
    if (onlysphere>=0) //Hier ist nur ein einziges Objekt wirksam
    {
      SimpleSphere[onlysphere]->SetStart(areastart[i]<lastt?lastt:areastart[i]);
      if (SimpleSphere[onlysphere]->NextCut(t))
        if (t<dist[i+1])
        { //Fertig!
          norm=SimpleSphere[onlysphere]->GetNormVect();
          delete MyObject;
          delete dist; delete areastart; delete areamid;
          return 1;
        }
    }
    else{
      MyObject->SetRay(nstart, ndir, nmaxt);
      MyObject->SetStart(areastart[i]<lastt?lastt:areastart[i]);
      if (MyObject->NextCut(t))
        if (t<dist[i+1])
        { //Fertig!
          norm=-MyObject->Obj_GetNormVect();
          delete MyObject;
          delete dist; delete areastart; delete areamid;
          return 1;
        }
    }
    delete MyObject;
  }
//Nichts gefunden
  delete dist; delete areastart; delete areamid;
  return 0;
}

TVector TMetaBall::Obj_GetNormVect(void)
{
  return norm;
}

char TMetaBall::Obj_InObject(double t)
{
  TEqnObject *MyObject;
  char interesting, retval;
  int j;
  int onlysphere=-2;

  //Im Einflussbereich welcher Quellen liegt der Punkt p?
  MyObject=new TEqnObject();
  interesting=0;
  for (j=0; j<srcnum; ++j)
  {
    if (Sphere[j]->InObject(t))
    {
      *((T3dpoly*)MyObject)+=*(Src[j]);
      interesting=1;
      if (onlysphere>=-1) onlysphere=-1; else onlysphere=j;
    }
  }
  if (!interesting) //Der Punkt liegt ausserhalb aller interessanten Bereiche
  {
    delete MyObject;
    return 0;
  }
  if (onlysphere>=0) //Hier ist nur ein einziges Objekt wirksam
  {
    delete MyObject;
    return SimpleSphere[onlysphere]->InObject(t);
  }
//Oberflchengleichung fertig machen und berprfen
  *((T3dpoly*)MyObject)-=*Borderpoly;
  retval=MyObject->InObject(t);
  delete MyObject;
  return !retval; //Oberflchengleichung hat falsches Vorzeichen, daher hier nochmal umkehren.
}
