/****************************************************************************/
/* minigauss.cc  -  kleiner Gaussalgorithmus fuer inhomogene                */
/*                  Gleichungssysteme (3 Gleichungen, 3 Variablen;          */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include"tvector.h"

void Gauss_Transform1(TVector v[4], int z1, int z2, double factor) //Addiere das factor-fache von Zeile z1 auf Zeile z2
{
  for (int i=0;i<4;++i)
  {
    double *num=(double *)(&(v[i]));
    num[z2]+=factor*num[z1];
  }
}

void Gauss_Transform2(TVector v[4], int z, double factor) //Multipliziere Zeile z mit factor
{
  for (int i=0; i<4; ++i)
  {
    double *num=(double *)(&(v[i]));
    num[z]*=factor;
  }
}

void Gauss_Xchange(TVector v[4], int z1, int z2) //Vertausche die Zeilen z1 und z2
{
  double tmp;
  for (int i=0; i<4; ++i)
  {
    double *num=(double *)(&(v[i]));
    tmp=num[z1]; num[z1]=num[z2]; num[z2]=tmp;
  }
}

char MiniGauss(TVector v1, TVector v2, TVector v3, TVector v4, TVector &ergvect)
{
  TVector v[4]={v1, v2, v3, v4}; //Bemerkung: Bei v[i][j] ist v[i] das Element im Array v[], (v[i])[j] ruft den []-Operator von TVector auf!
  int i,j;

//1. Bringe das Gleichungssystem auf Diagonalgestalt

  for (i=0;i<3;++i)
  {
//1.1 Tausche so, dass oben links keine Null steht
    if (fabs(v[i][i])<1e-10)
    {
      for (j=i+1; j<3; ++j)
      {
        if (fabs(v[i][j])>=1e-10)
        { Gauss_Xchange(v, i, j); j=3; /*Schleife verlassen*/}
      }
    }

//1.2 Mache aus dem, was da steht, eine eins
    if (fabs(v[i][i])<1e-10) return 0;
    Gauss_Transform2(v, i, 1.0/v[i][i]);

//1.3 Darunter Nullen generieren
    for (j=i+1; j<3; ++j)
      Gauss_Transform1(v, i, j, -v[i][j]);
  }

//Jetzt stehen auf der Hauptdiagonalen einsen
//2. Oberhalb der Hauptdiagonalen Nullen generieren
  for (i=2; i>=0; --i)
  {
    for (j=i-1; j>=0; --j)
      Gauss_Transform1(v, i, j, -v[i][j]);
  }

//3. Fertig!
  ergvect=v[3];
  return 1;
}
