/****************************************************************************/
/* minigauss.cc  -  kleiner Gaussalgorithmus fuer inhomogene                */
/*                  Gleichungssysteme (3 Gleichungen, 3 Variablen;          */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include"tvector.h"

#ifndef MINIGAUSS_H
#define MINIGAUSS_H

char MiniGauss(TVector v1, TVector v2, TVector v3, TVector v4, TVector &ergvect);
     /* Loese das Gleichungssystem a*v1+b*v2+c*v3=v4, Speichere (a,b,c) in erg. */
     /* Rueckgabe: 1, wenn es eine Loesung gibt, sonst 0                          */

#endif

