/****************************************************************************/
/* MODIFIER.CPP - Koordinatenmodifizierer (Rotation, Noise etc.)            */
/*  Copyright (c) 1999 Martin Melcher                                       */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<math.h>
#include<stdlib.h>
#include"modifier.h"

void TMod_Translate::modify3d(TVector &p)
{
  p.x-=xd;
  p.y-=yd;
  p.z-=zd;
}

void TMod_Scale::modify3d(TVector &p)
{
  p.x/=xf;
  p.y/=yf;
  p.z/=zf;
}

void TMod_Scale::unmodifynv(TVector &nv)
{
  nv.x*=xf;
  nv.y*=yf;
  nv.z*=zf;
  nv.normalize();
}

void TMod_Rotate::modify3d(TVector &p)
{
  TVector temp;

  if (rotatebits&1) /*Roteatex!=0*/
  {
    temp=p;
    p.y=temp.y*rotcosx-temp.z*rotsinx;
    p.z=temp.y*rotsinx+temp.z*rotcosx;
  }

  if (rotatebits&2) /*Rotatey!=0*/
  {
    temp=p;
    p.x=temp.x*rotcosy+temp.z*rotsiny;
    p.z=-temp.x*rotsiny+temp.z*rotcosy;
  }

  if (rotatebits&4) /*Rotatez!=0*/
  {
    temp=p;
    p.x=temp.x*rotcosz-temp.y*rotsinz;
    p.y=temp.x*rotsinz+temp.y*rotcosz;
  }
}

void TMod_Rotate::unmodifynv(TVector &nv)
{
  TVector temp;

  if (rotatebits&4) /*Rotatez!=0*/
  {
    temp=nv;
    nv.x=temp.x*rotcosz+temp.y*rotsinz;
    nv.y=-temp.x*rotsinz+temp.y*rotcosz;
  }

  if (rotatebits&2) /*Rotatey!=0*/
  {
    temp=nv;
    nv.x=temp.x*rotcosy-temp.z*rotsiny;
    nv.z=temp.x*rotsiny+temp.z*rotcosy;
  }

  if (rotatebits&1) /*Roteatex!=0*/
  {
    temp=nv;
    nv.y= temp.y*rotcosx+temp.z*rotsinx;
    nv.z=-temp.y*rotsinx+temp.z*rotcosx;
  }
}

#ifndef M_PI
#define M_PI 3.1415927
#endif

void TMod_Rotate::optimize()
{
  rotatebits=0;
  if (fabs(ax)>1e-10)
    rotatebits|=1;
  if (fabs(ay)>1e-10)
    rotatebits|=2;
  if (fabs(az)>1e-10)
    rotatebits|=4;

  rotsinx=sin(-ax);//*M_PI/180.0);
  rotcosx=cos(ax);//*M_PI/180.0);
  rotsiny=sin(-ay);//*M_PI/180.0);
  rotcosy=cos(ay);//*M_PI/180.0);
  rotsinz=sin(-az);//*M_PI/180.0);
  rotcosz=cos(az);//*M_PI/180.0);
}


#define getnoise(a,b,c,d) (noise[(a)*n*n*n+(b)*n*n+(c)*n+(d)])

TMod_Noise::TMod_Noise(int pn, double pmax)
{
//Dreidimensionales Datenfeld anlegen
  int i,j,k,l;

  srand(0);
  n=pn;
  max=pmax;
  noise=(signed char *)malloc(3*n*n*n*sizeof(char));
  for (i=0;i<3;++i)
    for (j=0;j<n;++j)
      for (k=0;k<n;++k)
        for (l=0;l<n;++l)
          getnoise(i,j,k,l)=(rand()/256)-127;
}


TMod_Noise::~TMod_Noise()
{
  free(noise);
}

void TMod_Noise::calcnoise(TVector &p, TVector &noisevec)
{
  int ax,bx,ay,by,az,bz;
  double dx,dy,dz;
  double nx,ny,nz;
  ax=p.x; if (p.x<0) --ax; //Immer abrunden, auch wenn <0
  ay=p.y; if (p.y<0) --ay; //Immer abrunden, auch wenn <0
  az=p.z; if (p.z<0) --az; //Immer abrunden, auch wenn <0
  dx=p.x-ax;
  dy=p.y-ay;
  dz=p.z-az;
  ax%=n;if (ax<0) ax+=n; bx=(ax+1)%n;
  ay%=n;if (ay<0) ay+=n; by=(ay+1)%n;
  az%=n;if (az<0) az+=n; bz=(az+1)%n;
  nx=getnoise(0,ax,ay,az)*(1-dx)*(1-dy)*(1-dz)+getnoise(0,bx,ay,az)*dx*(1-dy)*(1-dz)
    +getnoise(0,ax,by,az)*(1-dx)*dy*(1-dz)    +getnoise(0,bx,by,az)*dx*dy*(1-dz)
    +getnoise(0,ax,ay,bz)*(1-dx)*(1-dy)*dz    +getnoise(0,bx,ay,bz)*dx*(1-dy)*dz
    +getnoise(0,ax,by,bz)*(1-dx)*dy*dz        +getnoise(0,bx,by,bz)*dx*dy*dz;
  ny=getnoise(1,ax,ay,az)*(1-dx)*(1-dy)*(1-dz)+getnoise(1,bx,ay,az)*dx*(1-dy)*(1-dz)
    +getnoise(1,ax,by,az)*(1-dx)*dy*(1-dz)    +getnoise(1,bx,by,az)*dx*dy*(1-dz)
    +getnoise(1,ax,ay,bz)*(1-dx)*(1-dy)*dz    +getnoise(1,bx,ay,bz)*dx*(1-dy)*dz
    +getnoise(1,ax,by,bz)*(1-dx)*dy*dz        +getnoise(1,bx,by,bz)*dx*dy*dz;
  nz=getnoise(2,ax,ay,az)*(1-dx)*(1-dy)*(1-dz)+getnoise(2,bx,ay,az)*dx*(1-dy)*(1-dz)
    +getnoise(2,ax,by,az)*(1-dx)*dy*(1-dz)    +getnoise(2,bx,by,az)*dx*dy*(1-dz)
    +getnoise(2,ax,ay,bz)*(1-dx)*(1-dy)*dz    +getnoise(2,bx,ay,bz)*dx*(1-dy)*dz
    +getnoise(2,ax,by,bz)*(1-dx)*dy*dz        +getnoise(2,bx,by,bz)*dx*dy*dz;
  nx*=max/127.0/8.0;
  ny*=max/127.0/8.0;
  nz*=max/127.0/8.0;
  noisevec.x=nx;
  noisevec.y=ny;
  noisevec.z=nz;
}

void TMod_Noise::modify3d(TVector &p)
{
  TVector temp;
  calcnoise(p,temp);
  p+=temp;
}


void TMod_Turbulence::modify3d(TVector &p)
{
  TVector noisev;
  TVector turbulence(0,0,0);
  TVector curv=p;
  int i,f;


  f=1;
  for (i=0;i<n;++i)
  {
    calcnoise(curv,noisev);
    noisev/=f;
    curv*=2.0;
    turbulence+=noisev;
    f*=2;
  }
  p+=turbulence;
}
