#ifndef MODIFIERS_H

#include"tvector.h"

class TModifier
{
public:
  virtual void modify3d(TVector &p)=0;
  virtual void unmodifynv(TVector &nv) {}
};

typedef TModifier *PTModifier;

class TMod_Translate: public TModifier
{
  double xd,yd,zd;
public:
  void modify3d(TVector &p);
  TMod_Translate(double px, double py, double pz)
  {
    xd=px;yd=py;zd=pz;
  }
};

class TMod_Scale: public TModifier
{
  double xf,yf,zf;
public:
  void modify3d(TVector &p);
  void unmodifynv(TVector &nv);
  TMod_Scale(double px, double py, double pz)
  {
    xf=px;yf=py;zf=pz;
  }
};

class TMod_Rotate: public TModifier
{
  double ax,ay,az;
  char rotatebits;
  double rotsinx,rotcosx,rotsiny,rotcosy,rotsinz,rotcosz;
public:
  void modify3d(TVector &p);
  void unmodifynv(TVector &nv);
  TMod_Rotate(double px, double py, double pz)
  {
    ax=px;ay=py;az=pz;
    optimize();
  }
  void optimize(); //Extra Prozedur wg. Animationen (Neuberechnung)
};

class TMod_Noise: public TModifier
{
  signed char *noise; //Je ein Feld fr x,y,z, dann jeweils dreidimensional
public:
  int n;
  double max;
  TMod_Noise(int pn, double pmax);
  ~TMod_Noise();
  void calcnoise(TVector &p, TVector &noisevec);
  void modify3d(TVector &p);
};

class TMod_Turbulence: public TMod_Noise
{
public:
  TMod_Turbulence(int pn, double pmax):TMod_Noise(pn,pmax) {};
  void modify3d(TVector &p);
};

#define MODIFIERS_H

#endif
