#ifndef OBJECTSHEADER

#include"ray20.h"
#include"polynome.h"
#include"3dpoly.h"
#include"polysolv.h"
#ifdef RTPREVIEW
#include"RT/3dstuff.h"
#include"RT/polygons.h"
#endif

class TSphere: public T3dObject
{
  double t1, t2;
  char onecut;
public:
  TSphere() {type=TYPE_SPHERE;}
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);

  void calcsphere();
#ifdef RTPREVIEW
  TObject_RT *RT_Create(T3dData *Data, TLightData *Lights, int detail);
#endif
};

class TPolygon: public T3dObject
{
public:
  TVector *p;
  TVector normvect;
  int numpoint;

  TPolygon();
  TPolygon(TVector *point1, TVector *point2, TVector *point3, ...);
  ~TPolygon();
  void addpoint(TVector &p);

  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

class TTriangle: public T3dObject //nur fr internen Gebrauch
{
  TVector normvect;
  TVector v1,v2,v3,p1,p2,p3; //p1..3: Punkte; v1=p2-p1, v2=p3-p2, v3=p1-p3
public:
  TTriangle(TVector &point1, TVector &point2, TVector &point3);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

class TIntersection : public T3dObject
{
public:
  int found;

  PT3dObject *Object;
  int numobj;
  TIntersection();
  ~TIntersection();
  void addobject(PT3dObject NewObject);

  void SubProcessRay();
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);

  void calcsphere();
};

class TContainer : public TIntersection
{
public:
  TContainer():TIntersection() {type=TYPE_CONTAINER;}
  char Obj_NextCut(double &t);
  char Obj_InObject(double t);
  void calcsphere();
};

class TUnion : public TIntersection
{
public:
  TUnion():TIntersection() {type=TYPE_UNION;}
  char Obj_NextCut(double &t);
  char Obj_InObject(double t);
  void calcsphere();
};

class TDisk : public T3dObject
{
public:
  double innerr2;
  TDisk(double p=0):T3dObject(){innerr2=p*p;type=TYPE_DISK;}
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void calcsphere();
};

class TCylinder : public T3dObject
{
  TVector cut;
  double t1, t2;

  public:
  TCylinder() {type=TYPE_CYLINDER;}
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void calcsphere();
};

class TSimpleQuad : public T3dObject //Quadrat 1x1 Mitte im Ursprung
{
  public:
  int ebene;
  TVector normvect;
  TSimpleQuad(int e);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void calcsphere();
};
#define ebene_xyv 1 //XY-Ebene Normvektor nach vorne
#define ebene_xyh 2 //XY-Ebene Normvektor nach hinten
#define ebene_xzo 3 //XZ-Ebene Normvektor nach oben
#define ebene_xzu 4 //    "        "        "  unten
#define ebene_yzl 5 //YZ-Ebene     "        "  links
#define ebene_yzr 6 //    "        "        "  rechts

class TCube : public TContainer
{
public:
  TCube();
  char Obj_InObject(double t);
  char Obj_NextCut(double &t);
  void calcsphere();
#ifdef RTPREVIEW
  TObject_RT *RT_Create(T3dData *Data, TLightData *Lights, int detail);
#endif
};

class TTube : public TContainer
{
  char nullradi;
public:
  TTube(double radi);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void calcsphere();
};

class TSubtraction : public T3dObject
{
  int found;
public:
  int assignednum; //Steht zur Verfgung (z.B. fr RayScript)
  PT3dObject Obja,Objb;
  TSubtraction(PT3dObject a, PT3dObject b) {type=TYPE_SUBTRACTION;Obja=a;Objb=b;assignednum=0;}
  TSubtraction() {type=TYPE_SUBTRACTION;assignednum=0;Obja=Objb=NULL;needssubprocessing=1;}
  ~TSubtraction();
  void SubProcessRay();
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void calcsphere();
};

class TCone : public T3dObject //Kegel
{
  double t1,t2;
  TVector cut;

public:
  double y1,y2;
  double n,m; //Geradengleichung
  TCone(double px1, double py1, double px2, double py2);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

class TRotobj : public T3dObject //Rotationskrper
{
  int found;
public:

  char *swapped;
  int numpoint;
  double lastx, lasty;
  TCone **cone;

  TRotobj() {type=TYPE_ROTOBJ;cone=NULL;numpoint=0;swapped=NULL;needssubprocessing=1;}
  ~TRotobj();
  void SubProcessRay();
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void add(double x, double y);
};

class TEqnObject : public T3dObject,public T3dpoly //Beliebige Oberflchengleichung
{

  TPolynom TPoly;
  TPolynom *XPoly;
  TPolynom *YPoly;
  TPolynom *ZPoly;
  TPolySolver *MySolver;
public:
// Gleichung : koeffs[0]*x^xdeg[0]*y^ydeg[0]*z^zdeg[0]+koeffs[1]*x^xdeg[1]*....

  TEqnObject() {type=TYPE_EQNOBJ;  XPoly=YPoly=ZPoly=NULL;MySolver=NULL;}
  ~TEqnObject() {if (XPoly!=NULL) {delete XPoly; delete YPoly; delete ZPoly;}}
  void AddKoeff(double koeff, int pxdeg, int pydeg, int pzdeg);
  void CalcPoly(void);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

class TSQEllipsoid : public TEqnObject //SuperQuadric Ellipsoid
{
public:
  TSQEllipsoid(int degree);
  void calcsphere();
  void MakeBoundingObject();
};

class TTorus : public TEqnObject
{
public:
  double r1, r2;
  TTorus(double pr1, double pr2);
  void calcsphere();
  void MakeBoundingObject();
};

class TSorSegment : public TEqnObject //Teil eines "Surface of Revolution" = rotiertes kubisches 1dimensionales Bezier-Spline
{
  double ri, ra; //Zum Optimieren in MakeBoundingObject
  double a,b,c,d;
public:
  TSorSegment(double pa, double pb, double pc, double pd);
  char Obj_NextCut(double &t);
  char Obj_InObject(double t);
  void MakeBoundingObject();
};

class TSor : public TContainer
{
public:
  TSor(int pointno, double *xvals, double *yvals); //yvals mssen streng monoton steigend sein
  char Obj_NextCut(double &t);
//  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

#define BLOBMAXNUM 10

class TBlob : public TEqnObject //Blobs - Kraftfeldlinien
{
  double borderintens;
  int srcnum;
  PT3dpoly Src[BLOBMAXNUM];
  double intens[BLOBMAXNUM];
public:
  TBlob(double pborderintens);
  ~TBlob();
  void AddSpherical(double px, double py, double pz, double pintens);
  void AddCylindrical(TVector p1, TVector p2, double pintens);
  void AddPlanar(TVector p, TVector Normv, double pintens);
  void calculate();
};

class TMetaBall : public T3dObject //Blobs 2. Typs ("offizielle" Blobs)
{
  PT3dpoly Src[BLOBMAXNUM];        //Oberflchengleichungen fr die einzelnen Objekte
  TSphere* Sphere[BLOBMAXNUM];     //Diese Objekte gibt den Wirkungsbereich der Blobs an
  TSphere* SimpleSphere[BLOBMAXNUM];//Diese Objekte werden da verwendet, wo sich die Wirkungsbereiche nicht ueberschneiden
  double intens[BLOBMAXNUM];
  int srcnum;
  double borderintens;
  PT3dpoly Borderpoly;
  TVector norm;
public:
  TMetaBall(double pborderintens);
  ~TMetaBall();
  void AddSpherical(double px, double py, double pz, double pintens, double prad);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void SubProcessRay();
};


class TDust : public T3dObject //Staubatmosphre
{
  double disttohit;
public:
  TDust(double density, double reflection);
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t) {return 0;}
};

class T3dPlot;
class TLandscape;
class TBMPHeightField;
class TUserHeightField;

class THeightField : public T3dObject //Basisobjekt fr Landschaften, Funktionsplots etc.
{
  int xpoints,ypoints;
  double *heights;
  TCube *TheCube;
  TVector normvect;

  friend T3dPlot;
  friend TLandscape;
  friend TBMPHeightField;
  friend TUserHeightField;

  double getinterheight(double x, double y); //Hhenwert an x,y, interpoliert
public:
  THeightField(int pxpoints, int pypoints);
  ~THeightField();
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
  void SubProcessRay();
  //Kein MakeBOundingObject bentigt, da schon berprfung in firstcut
};

class TUserHeightField : public THeightField
{
public:
  void SetHeight(int x, int y, double height);
  TUserHeightField(int pxpoints, int pypoints);
};

class T3dPlot : public THeightField //3D-Funktionsplot (mit Syntaxanalyse)
{
public:
  T3dPlot(int pxpoints, int pypoints, char *function, double x1, double y1, double x2, double y2, int &retval);
};

class TLandscape : public THeightField //Fraktale Landschaft
{
  double delta;
  double pointof3(int x1, int y1, int x2, int y2, int x3, int y3, double delta);
  double pointof4(int x1, int y1, int x2, int y2, int x3, int y3, int  x4, int y4, double delta);
  void calcmidsdiag(int space);  //Diagonal Mitteln+Noise
  void calcmidshv(int space);    //Horizontal/Vertikal Mitteln+Noise
  void calcmidsborder(int space);//An den Rndern Mitteln+Noise

public:
  TLandscape(int size, double fracdim, double pdelta, int psrand, double h1=0, double h2=0, double h3=0, double h4=0);
};

class TBMPHeightField : public THeightField //Hhenmuster aus einem Bitmap
{
public:
  TBMPHeightField(int pxpoints, int pypoints, char *filename, int &retval);
};


struct TMeshTriangle {
	int p1, p2, p3;
	TVector transformed_ex, transformed_ey, transformed_ez; //Die Einheitsvektoren, dargestellt durch Linearkombinationen von p1, p2, p3
	TVector norm;
	double dist;
	int rayid;
};

struct TBoundingCube
{
  TCube *Cube;
  int subcube[8]; //Die vier Unterwuerfel; Indizes in der Liste (BoundingCube)! -1 fr leere Cubes bzw. bei keiner weiteren Unterteilung

  int firsttri, lasttri; //Zugehrige Dreiecke; Indizes in der Liste (cube_tri, NICHT triangle!)
                         //Ist der Wuerfel weiter unterteilt, so ist firsttri=-1
  int rayid;
};

class TMesh : public T3dObject
{
  int vertexno, trino;
  TVector *vertex, *normal;
  TVector min, max;           //Begrenzungen des Startwrfels
  TVector lastnorm;

  int *cube_tri;           //Hier sind die Nummern der Dreiecke, die zu den BoundingCubes gehren, nacheinander fr alle BoundingCubes
  int cubetri_no;          //Anzahl

  TMeshTriangle *triangle; //a,b,c: Indizes in vertex; Unsortierte Liste aller Dreiecke
  TBoundingCube *BoundingCube; //Liste, bergeordneter Wrfel an erster Stelle
  int BoundingCube_no;         //Anzahl

  int lastvertex;          //Beim Hinzufgen neuer Flchen wird erst ab hier nach bereits hinzugefgten Punkten gesucht
                           // (ntzlich fr Kanten, an denen der Normalenvektor springen soll)

  int rayid;

  int AddVertex(TVector const &p, TVector const &norm);

  int AddCubeTriangle(int trino);    //Dreieck trino in cube_tri eintragen (Speicher reservieren etc.), Index zurueckliefern.
  int AddBoundingCube(TCube *Cube, int *FoundTris, int FoundNo);
                                     //Speicherplatz fr Cube reservieren, in die Liste eintragen, Index in der Liste zurueckliefern,
                                     //zugehoerige Dreiecke raussuchen und eintragen, ggf. weiter unterteilen mittels SplitCube
                                     //FoundTris kann eine Liste von interessanten Dreiecken enthalten (Indizes in triangle[]), oder NULL sein

  void SplitCube(int CubeNo, int *FoundTris, int FoundNo);
                                     //Einen Wuerfel durch 8 Teilen, AddBoundingCube aufrufen
                                     //FoundTris kann eine Liste von interessanten Dreiecken enthalten (Indizes in triangle[]), oder NULL sein

  void NormalizeVects(void);         //Normalenvektoren in der Liste skalieren
  void InitCubes(void);              //Bounding-Cubes-Hierarchie bauen


  char triangle_firstcut(int firsttri, int lasttri, TVector const &start, TVector const &dir, TVector &cut, TVector &norm, double &p_t, double maxt);
                                     //Schnittpunktberechnung, aber nur die Dreiecke firsttri..lasttri

  char cube_firstcut(int cubeno, TVector const &start, TVector const &dir, TVector &cut, TVector &norm, double &p_t, double maxt);
                                     //Schnittpunktberechnung mit den Polygonen eines Wuerfels, ggf. Rekursion!

public:
  TMesh();
  ~TMesh();
  void AddTriangle(TVector &p1, TVector &p2, TVector &p3);
  void Done(void);                   //Alle Dreiecke hinzugefgt; Jetzt alles frs Raytracen vorbereiten!
  void NewSurface(void);             //Neue Oberflche (bergang zu den anderen Oberflchen als harte Kanten)
  char Obj_NextCut(double &t);
  TVector Obj_GetNormVect(void);
  char Obj_InObject(double t);
};

TMesh *CreateTorus(double r1, double r2, int segments, int slices);


#define OBJECTSHEADER

#endif
