#include<stdio.h>
#include<string.h>
#include<stdlib.h>
#include<stdarg.h>
#include"parser.h"
#include"tvector.h"
#include"ray20.h"
#include"objects.h"
#include"lights.h"
#include"cameras.h"
#include"textures.h"
#include"textbase.h"
#include"modifier.h"


int parse_error=0;
void (*MessageFunc)(char *filename, int lineno, int debuglevel, char *str, ...);
int resx, resy; //Fr die Kameras

int parser_containerno=0, parser_objectno=0, parser_lightno=0; //Statistiken
void parser_resetcounters(void) {parser_containerno=parser_objectno=parser_lightno=0;}

TMacro *parser_macros=NULL;

TRaytracer *Parser_TheTracer=NULL;

TScope::TScope(char *pfilename, TVariable *pGlobalVars, TUserFunction *pFuncs, TScope *pparent)
{
  FILE *datei;
  int len;

  strcpy(filename, pfilename);

  datei=fopen(filename,"r");

  if (datei==NULL)
  {
    parse_error=1;
    MessageFunc(filename, 0, 0, "File not found");
    return;
  }
  fseek(datei, 0, SEEK_END);
  text=(char *)malloc((len=ftell(datei))+1);
  fseek(datei, 0, SEEK_SET);
  if (text==NULL)
  {
    parse_error=1;
    fclose(datei);
    MessageFunc(filename, 0, 0, "Not enough memory/file too large");
    return;
  }
  fread(text, 1, len, datei);
  fclose(datei);
  text[len]=0;
  firstline=0;
  textpos=0;
  GlobalVars=pGlobalVars;
  MyVars=GlobalVars;
  MyFuncs=GlobalFuncs=pFuncs;
  RefPointNo=0;
  RefPoints=NULL;
  parent=pparent;
}

TScope::TScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pFuncs, TScope *pparent)
{
  text=ptext;
  if (text==NULL)
  {
    parse_error=1;
    MessageFunc(filename, pfirstline, 0, "Not enough memory/file too large");
    return;
  }
  firstline=pfirstline;
  strcpy(filename,pfilename);
  textpos=0;
  GlobalVars=pGlobalVars;
  MyVars=GlobalVars;
  MyFuncs=GlobalFuncs=pFuncs;
  RefPointNo=0;
  RefPoints=NULL;
  parent=pparent;
}


TScope::~TScope()
{
  TVariable *VarLauf, *v;
  TUserFunction *FuncLauf, *f;

  free(text);

  VarLauf=MyVars;
  while (VarLauf!=GlobalVars)
  {
    v=VarLauf->next;
    free(VarLauf);
    VarLauf=v;
  }

  FuncLauf=MyFuncs;
  while (FuncLauf!=GlobalFuncs)
  {
    f=FuncLauf->next;
    free(FuncLauf);
    FuncLauf=f;
  }

  if (RefPoints!=NULL)
    free(RefPoints);
}


int TScope::getpos(void)
{
  return textpos;
}

void TScope::setpos(int newpos)
{
  textpos=newpos;
}

int TScope::eof(void)
{
  int pos=getpos();
  int r;
  Skip();
  r=(getchar()<0);
  setpos(pos);
  return r;
}

void TScope::AddUserFunction(char *name, int argno, char *argtype, TValue (*TheFunc)(TValue *x, void *data), void *data)
{
  TUserFunction *NewFunc=(TUserFunction *)malloc(sizeof(TUserFunction));
  NewFunc->funcname=name;
  NewFunc->argno=argno;
  NewFunc->argtype=argtype;
  NewFunc->EvalFunc=TheFunc;
  NewFunc->next=MyFuncs;
  NewFunc->data=data;
  MyFuncs=NewFunc;
}

void TScope::AddLocalVar_double(char *name, double init)
{
  TVariable *v;
  v=(TVariable *)malloc(sizeof(TVariable));
  strcpy(v->varname, name);
  v->value.type=VARTYPE_DOUBLE;
  v->value.value.dblval=init;
  v->isconstant=0;
  v->next=MyVars;
  MyVars=v;
}

void TScope::AddLocalVar_int(char *name, int init)
{
  TVariable *v;
  v=(TVariable *)malloc(sizeof(TVariable));
  strcpy(v->varname, name);
  v->value.type=VARTYPE_INTEGER;
  v->value.value.intval=init;
  v->isconstant=0;
  v->next=MyVars;
  MyVars=v;
}

void TScope::AddLocalVar_vect(char *name, TVector init)
{
  TVariable *v;
  v=(TVariable *)malloc(sizeof(TVariable));
  strcpy(v->varname, name);
  v->value.type=VARTYPE_VECTOR;
  v->value.value.vectval.x=init.x;
  v->value.value.vectval.y=init.y;
  v->value.value.vectval.z=init.z;
  v->isconstant=0;
  v->next=MyVars;
  MyVars=v;
}


double TScope::GetLocalVar_double(char *name)
{
  TVariable *varlauf=MyVars;

  for(;varlauf!=NULL;varlauf=varlauf->next)
  {
    if (!strcmp(varlauf->varname, name))
    {
      if (varlauf->value.type==VARTYPE_INTEGER)
        return (double)varlauf->value.value.intval;
      else if (varlauf->value.type==VARTYPE_DOUBLE)
        return varlauf->value.value.dblval;
      else {parse_error=1; MessageFunc(filename, getlineno(), 0, "%s: Bad type", name); return 0;}
    }
  }
}

int TScope::GetLocalVar_int(char *name)
{
  TVariable *varlauf=MyVars;

  for(;varlauf!=NULL;varlauf=varlauf->next)
  {
    if (!strcmp(varlauf->varname, name))
    {
      if (varlauf->value.type==VARTYPE_INTEGER)
        return varlauf->value.value.intval;
      else if (varlauf->value.type==VARTYPE_DOUBLE)
        return (int)varlauf->value.value.dblval;
      else {parse_error=1; MessageFunc(filename, getlineno(), 0, "%s: Bad type", name); return 0;}
    }
  }
}

TVector TScope::GetLocalVar_vect(char *name)
{
  TVariable *varlauf=MyVars;
  TVector ret;

  for(;varlauf!=NULL;varlauf=varlauf->next)
  {
    if (!strcmp(varlauf->varname, name))
    {
      if (varlauf->value.type==VARTYPE_VECTOR)
      {
        ret.x=varlauf->value.value.vectval.x;
        ret.y=varlauf->value.value.vectval.y;
        ret.z=varlauf->value.value.vectval.z;
        return ret;
      }
      else {parse_error=1; MessageFunc(filename, getlineno(), 0, "%s: Bad type", name); return ret;}
    }
  }
  return ret;
}

void TScope::AddRefPoint(char *name, TVector pos)
{
  RefPoints=(TRefPoint *)realloc(RefPoints, sizeof(TRefPoint)*++RefPointNo);
  strcpy(RefPoints[RefPointNo-1].name, name);
  RefPoints[RefPointNo-1].pos=pos;
}

TValue TScope::GetRefPoint(char *name)
{
  TValue ret;
  ret.type=VARTYPE_VECTOR;
  for (int i=0;i<RefPointNo; ++i)
  {
    if (!strcmp(name, RefPoints[i].name))
    {
      ret.value.vectval.x=RefPoints[i].pos.x;
      ret.value.vectval.y=RefPoints[i].pos.y;
      ret.value.vectval.z=RefPoints[i].pos.z;
      return ret;
    }
  }
  if (parent!=NULL)
    return parent->GetRefPoint(name);
  else
  {
    parse_error=1;
    MessageFunc(filename, getlineno(), 0, "Refpoint \"%s\" undefined", name);
    return ret;
  }
}

int TScope::VarExists(char *name)
{
  TVariable *varlauf=MyVars;
  for (;varlauf!=NULL;varlauf=varlauf->next)
    if (!strcmp(varlauf->varname, name)) return 1;
  return 0;
}

void TScope::Skip(int OnlyComments)
{
  int mypos;
  int c1,c2;
  int done=1;

  do{
    if (!OnlyComments)
    {
      do{
        mypos=getpos();
        c1=getchar();
      } while (strchr(" \r\n",c1));
      setpos(mypos);
    } else mypos=getpos();
    if (c1!='/') return;
    c1=getchar();
    c2=getchar();
    if (c2=='/') // Kommentar "//"
      while(!strchr("\r\n",getchar()));
    else if (c2=='*') //Kommentar "/*"
    {
      do{
        c1=c2;
        c2=getchar();
      }while (((c1!='*')||(c2!='/'))&&(c2>0));
    }
    else {setpos(mypos); return;}
  } while(1);
}

void TScope::GetSpecialChar(char c)
{
  int c2;

  Skip();
  c2=getchar();
  if (c2<0) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Unexpected end of scope"); return;}
  if (c2!=c) {parse_error=1; MessageFunc(filename, getlineno(), 0, "\'%c\' expected but \'%c\' received", c, c2); return;}
}

void TScope::GetString(char *dest, int maxlen)
{
  int c;
  int destpos=0;

  GetSpecialChar('\"');
  if (parse_error) return;
  do{
    c=getchar();
    if (c=='\"') break;
    if (c=='\\')
    {
      c=getchar();
      while (strchr("\x0A\x0C",c)) c=getchar();
    }
    if (c<0) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Unexpected end of scope"); return;}
    dest[destpos++]=c;
    if (destpos-1>=maxlen) {parse_error=1; MessageFunc(filename, getlineno(), 0, "String too long"); return;}
  } while (1);
  dest[destpos]=0;
  return;
}

void TScope::GetExpressionUntil(char *dest, unsigned char c)
{
  int destpos=0;
  int c2, last=0;
  int bracket=0, instring=0;

  do{
    if (!instring) Skip();
    last=c2;
    c2=getchar();
    if (c2<0) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Unexpected end of scope"); return;}
    if (!instring)
      if (strchr("{}",c2)) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Unknown expression"); return;}
    if (bracket||(c2!=c)||instring)
    {
      if (!instring){
        if (strchr("[(",c2)) ++bracket;
        if (strchr("])",c2)) --bracket;
      }
      if (c2=='\"') {
        if (!instring) instring=1;
        else if (last!='\\') instring=0;
      }
    } else break;
    dest[destpos++]=c2;
    if (destpos-1>=PARSE_EXPRESSION_LEN) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Expression too long"); return;}
  } while(1);
  dest[destpos]=0;
}


unsigned char *keywords[]={"new","light","camera","for","if","#include","macro","local","else",NULL};
#define PARSE_KEYWORD_NEW       0
#define PARSE_KEYWORD_LIGHT     1
#define PARSE_KEYWORD_CAMERA    2
#define PARSE_KEYWORD_FOR       3
#define PARSE_KEYWORD_IF        4
#define PARSE_KEYWORD_INCLUDE   5
#define PARSE_KEYWORD_MACRO     6
#define PARSE_KEYWORD_LOCAL     7
#define PARSE_KEYWORD_ELSE      8

int TScope::GetKeyword()
{
  int startpos,i,j,c;
  char name[PARSE_IDLEN+1];

  Skip();
  startpos=getpos();

  GetName(name);

  for (i=0; keywords[i]!=NULL; ++i)
  {
    if (!strcmp(name,keywords[i]))
      return i;
  }
  setpos(startpos);
  return -1;
}

TMacro *TScope::GetMacro()
{
  int startpos,j,c;
  TMacro *MacroLauf=parser_macros;
  char name[PARSE_IDLEN+1];

  Skip();
  startpos=getpos();

  GetName(name);

  for (; MacroLauf!=NULL; MacroLauf=MacroLauf->next)
  {
    if (!strcmp(name,MacroLauf->name))
      return MacroLauf;
  }
  setpos(startpos);
  return NULL;
}

void TScope::GetSubScope(unsigned char *&dest, int &startline)
{
  int bracket1, bracket2,instring;
  int c,last=0;
  int destpos=0;
  int bracketfirst=0;

  dest=(char *)malloc(strlen(text)+1); //Erstmal ganz viel Speicher reservieren
  if (dest==NULL) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Out of memory"); return;}

  bracket1=bracket2=instring=0;
  Skip();

  startline=-1;

  c=getchar();

  if (c=='{') { bracketfirst=1; c=getchar(); ++bracket2;}
  startline=getlineno();

  while(1)
  {
    if (!instring) {
      Skip(1); //Leerzeichen und Zeilenumbrche drinlassen, nur Kommentare berspringen
      if (c=='(') ++bracket1;
      if (c==')') --bracket1;
      if ((c==';') && !bracket1 && !bracket2)
      {
        dest[destpos++]=c; //Das Semikolon noch anhngen
        dest[destpos]=0;
        dest=(char *)realloc(dest, destpos+1);
        return;
      }
      if (c=='{') ++bracket2;
      if (c=='}')
      {
        --bracket2;
        if (bracket2==0)
        {
          if (bracket1)
          {
            parse_error=1; free(dest);
            MessageFunc(filename, getlineno(), 0, "Missing \")\"");
            return;
          }
          if (!bracketfirst) dest[destpos++]=c;
          dest[destpos]=0;
          dest=(char *)realloc(dest, destpos+1);
          return;
        }
      }
    } //if (!instring)
    if (c=='\"'){
      if (!instring) instring=1;
      else if (last!='\\') instring=0;
    }
    dest[destpos++]=c;
    last=c;
    c=getchar();
    if (c<0) {parse_error=1; free(dest); MessageFunc(filename, getlineno(), 0, "Unexpected end of scope"); return;}
  }
}

int TScope::getchar(void)
{
  int c=text[textpos++];
  if (c==0) {--textpos; return -1;}
  return c;
}

int TScope::getlineno(void)
{
  int i,l;

  for (i=l=0; i<textpos; ++i)
    if (text[i]=='\x0A') ++l;

  return l+firstline;
}

void TScope::GetName(char *dest)
{
  int c,destpos=0;
  int mypos;

  Skip();

  mypos=getpos();
  c=getchar();
  while (!strchr(" ;\\=+-*/%!\"^.()[]{}\n\r",c))
  {
    mypos=getpos();
    if (destpos-1>=PARSE_IDLEN) dest[destpos]=0;
    else  dest[destpos++]=c;
    c=getchar(); if (c<0) c=';';
  }
  dest[destpos]=0;
  setpos(mypos);
}


void TScope::AddObject(T3dObject *NewObj)
{
  if (parent!=NULL) parent->AddObject(NewObj);
  else  Parser_TheTracer->addobject(NewObj);
}


/*****************************************************************************/

void TScope::Run()
{
  int done=0;
  char name[PARSE_IDLEN+1];
  char fname[PARSE_FILENAMELEN+1];
  char *expr1, *expr2, *expr3;
  unsigned char *buffer,*buffer2;
  int startline,startline2;
  int i,j;
  int mypos;
  TScope *SubScope;
  TMacro *MyMacro;
  TExpression *MyExpr;
  TValue v;

  do{
    Skip();
    if (eof()) break;

    i=GetKeyword();
    if (i>=0)
    {
      switch(i)
      {
        case PARSE_KEYWORD_NEW:
          GetName(name);
          if (!strcmp(name,"heightmap"))
            GetString(fname, PARSE_FILENAMELEN);
          GetSubScope(buffer, startline);
          if (parse_error) return;
          SubScope=new TObjectScope(name, buffer, filename, startline, GlobalVars, MyFuncs, this, fname);
          SubScope->Run();
          if (!parse_error) AddObject(((TObjectScope*)SubScope)->GetObject());
          delete SubScope;
          if (parse_error) return;
          break; //KEYWORD_NEW
        case PARSE_KEYWORD_LIGHT:
          GetName(name);
          GetSubScope(buffer, startline);
          if (parse_error) return;
          SubScope=new TLightScope(name, buffer, filename, startline, GlobalVars, MyFuncs, this);
          SubScope->Run();
          if (!parse_error) Parser_TheTracer->addlight(((TLightScope *)SubScope)->GetLight());
          delete SubScope;
          if (parse_error) return;
          break; //KEYWORD_NEW
        case PARSE_KEYWORD_CAMERA:
          if (Parser_TheTracer->Camera!=NULL)
          {  parse_error=1; MessageFunc(filename, 0, getlineno(), "Only one camera may be defined"); return; }
          GetSubScope(buffer, startline);
          if (parse_error) return;
          SubScope=new TCameraScope(buffer, filename, startline, GlobalVars, MyFuncs, this);
          SubScope->Run();
          if (!parse_error) Parser_TheTracer->createcamera(((TCameraScope *)SubScope)->GetCamera());
          delete SubScope;
          if (parse_error) return;
          break; //KEYWORD_NEW
        case PARSE_KEYWORD_FOR:
          GetSpecialChar('('); if (parse_error) return;
          expr1=(char *)malloc(PARSE_EXPRESSION_LEN+1);
          expr2=(char *)malloc(PARSE_EXPRESSION_LEN+1);
          expr3=(char *)malloc(PARSE_EXPRESSION_LEN+1);
          GetExpressionUntil(expr1, ';'); if (parse_error) {free(expr1); free(expr2); free(expr3); return;}
          GetExpressionUntil(expr2, ';'); if (parse_error) {free(expr1); free(expr2); free(expr3); return;}
          GetExpressionUntil(expr3, ')'); if (parse_error) {free(expr1); free(expr2); free(expr3); return;}
          GetSubScope(buffer, startline); if (parse_error) {free(expr1); free(expr2); free(expr3); return;}
          SubScope=new TForScope(buffer, filename, startline, MyVars, MyFuncs, expr1, expr2, expr3, this);
          SubScope->Run();
          delete SubScope;
          free(expr1);free(expr2);free(expr3);
          if (parse_error) return;
          break; //KEYWORD_FOR
        case PARSE_KEYWORD_IF:
          GetSpecialChar('('); if (parse_error) return;
          expr1=(char *)malloc(PARSE_EXPRESSION_LEN+1);
          GetExpressionUntil(expr1, ')'); if (parse_error) {free(expr1); return;}
          MyExpr=new TExpression(expr1, MyVars, MyFuncs);
          v=MyExpr->evaluate();
          delete MyExpr;
          if (exp_error) { parse_error=1; MessageFunc(filename, getlineno(), 0, exp_message); free(expr1); return; }
          if (v.type!=VARTYPE_INTEGER) { parse_error=1; MessageFunc(filename, getlineno(), 0, "if: Integer expression expected!"); free(expr1); return;  }

          GetSubScope(buffer, startline); if (parse_error) {free(expr1); return;}
          mypos=getpos();
          if (GetKeyword()==PARSE_KEYWORD_ELSE)
          {
            GetSubScope(buffer2, startline2); if (parse_error) {free(expr1); return;}
          } else {
            setpos(mypos);
            buffer2=NULL;
          }
          if (v.value.intval)
          {
            SubScope=new TScope(buffer, filename, startline, MyVars, MyFuncs, this);
            SubScope->Run();
            delete SubScope;
          }
          else if (buffer2!=NULL)
          {
            SubScope=new TScope(buffer2, filename, startline2, MyVars, MyFuncs, this);
            SubScope->Run();
            delete SubScope;
          }
          free(expr1);
          if (parse_error) return;
          break; //KEYWORD_IF
        case PARSE_KEYWORD_INCLUDE:
          GetString(fname, PARSE_FILENAMELEN); if (parse_error) return;
          SubScope=new TScope(fname, MyVars, MyFuncs, this);  if (parse_error) return;
          SubScope->Run();
          delete SubScope;
          if (parse_error) return;
          break; //KEYWORD_INCLUDE
        case PARSE_KEYWORD_MACRO:
          GetName(name); if (parse_error) return;
          GetSubScope(buffer, startline); if (parse_error) return;
          MyMacro=(TMacro *)malloc(sizeof(TMacro));
          strcpy(MyMacro->name, name);
          strcpy(MyMacro->filename, filename);
          MyMacro->text=buffer;
          MyMacro->firstline=startline;
          MyMacro->next=parser_macros;
          parser_macros=MyMacro;
          break; //KEYWORD_MACRO
        case PARSE_KEYWORD_LOCAL:
          GetName(name); if (parse_error) return;
          AddLocalVar_double(name,0.0);
          GetSpecialChar(';');
          break; //PARSE_KEYWORD_LOCAL
        case PARSE_KEYWORD_ELSE:
          parse_error=1;
          MessageFunc(filename, 0, getlineno(), "else without if");
          break; //PARSE_KEYWORD_ELSE
     }
      continue;
    } //if (i)   (Keyword found)

    MyMacro=GetMacro();
    if (MyMacro!=NULL)
    {
      GetSpecialChar(';');
      if (parse_error) return;
      buffer=(unsigned char *)malloc(strlen(MyMacro->text)+1);
      strcpy(buffer, MyMacro->text);
      SubScope=new TScope(buffer, MyMacro->filename, MyMacro->firstline, MyVars, MyFuncs, this);
      SubScope->Run();
      delete SubScope;
      if (parse_error) return;
      continue;
    }

    if (eof()) break;

    expr1=(char *)malloc(PARSE_EXPRESSION_LEN+1);
    GetExpressionUntil(expr1, ';');
    if (parse_error) {free(expr1); return;}
    MyExpr=new TExpression(expr1, MyVars, MyFuncs);
    MyExpr->evaluate();
    delete MyExpr;
    free(expr1);
    if (exp_error) {parse_error=1; MessageFunc(filename, getlineno(), 0, exp_message);}
  } while (!eof());
}


/*****************************************************************************/
TForScope::TForScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pFuncs, char *pinitexpr, char *pbreakexpr, char *ploopexpr, TScope *pparent)
:TScope(ptext, pfilename, pfirstline, pGlobalVars, pFuncs, pparent)
{
  TExpression *MyExpr;
  TValue v;

  initexpr=pinitexpr;
  breakexpr=pbreakexpr;
  loopexpr=ploopexpr;
  MyExpr=new TExpression(initexpr, MyVars, MyFuncs);
  MyExpr->evaluate();
  delete MyExpr;
  if (exp_error)
  {
    parse_error=1; MessageFunc(filename, pfirstline, 0, exp_message);
    return;
  }
  MyExpr=new TExpression(breakexpr, MyVars, MyFuncs);

  v=MyExpr->evaluate();
  delete MyExpr;
  if (exp_error)
  {
    parse_error=1; MessageFunc(filename, pfirstline, 0, exp_message);
    return;
  }
  if (v.type!=VARTYPE_INTEGER)
  {
    parse_error=1; MessageFunc(filename, pfirstline, 0, "for: Integer expression expected!");
    return;
  }

  if (v.value.intval) done=0; else done=1;
  evalloop=1;
}

int TForScope::getchar(void)
{
  if (done) return -1;
  int c=text[textpos++];
  while (c==0)
  {
    TValue v;
    TExpression *MyExpr;
    if (evalloop)
    {
      MyExpr=new TExpression(loopexpr, MyVars, MyFuncs);
      MyExpr->evaluate();
      delete MyExpr;
      if (exp_error) { parse_error=1; MessageFunc(filename, firstline, 0, exp_message);   return; }
    }
    MyExpr=new TExpression(breakexpr, MyVars, MyFuncs);
    v=MyExpr->evaluate();
    if (exp_error) { parse_error=1; MessageFunc(filename, firstline, 0, exp_message);   return; }
    if (v.type!=VARTYPE_INTEGER)  { parse_error=1; MessageFunc(filename, firstline, 0, "for: Integer expression expected!"); return; }
    if (!v.value.intval) { done=1; return -1;}
    else { textpos=0; c=text[textpos++];}
    evalloop=1;
  }
  return c;
}

int TForScope::getpos(void)
{
  return textpos;
}

void TForScope::setpos(int newpos)
{
  if (newpos>textpos) evalloop=0;
  textpos=newpos;
}

/*****************************************************************************/
TVector VectFromVal(TValue x)
{
  return TVector(x.value.vectval.x, x.value.vectval.y, x.value.vectval.z);
}

TValue PolygonAddPointFunc(TValue *x, void *data)
{ TVector r=VectFromVal(x[0]); TPolygon *p=(TPolygon *)data; p->addpoint(r); return x[0];}

TValue RotobjAddPointFunc(TValue *x, void *data)
{ TRotobj *r=(TRotobj *)data; r->add(x[0].value.dblval, x[1].value.dblval); return x[0];}

TValue EqnobjAddKoeffFunc(TValue *x, void *data)
{ TEqnObject *e=(TEqnObject *)data; e->AddKoeff(x[0].value.dblval, x[1].value.intval, x[2].value.intval, x[3].value.intval); return x[0];}

typedef struct {double *x, *y; int n;} TSorStruct;

TValue SorAddPointFunc(TValue *x, void *data)
{ TSorStruct *s=(TSorStruct *)data;
  s->x=(double *)realloc(s->x, (s->n+1)*sizeof(double));
  s->y=(double *)realloc(s->y, (s->n+1)*sizeof(double));
  s->x[s->n]=x[0].value.dblval;
  s->y[s->n++]=x[1].value.dblval; return x[0];}

typedef struct { TVector *v1, *v2; double *intens; char *type; int n;} TBlobStruct;

TValue BlobAddSphericalFunc(TValue *x, void *data)
{ TBlobStruct *b=(TBlobStruct *)data;
  b->v1=(TVector *)realloc(b->v1, (b->n+1)*sizeof(TVector));
  b->v2=(TVector *)realloc(b->v2, (b->n+1)*sizeof(TVector));
  b->intens=(double *)realloc(b->intens, (b->n+1)*sizeof(double));
  b->type=(char *)realloc(b->type, (b->n+1)*sizeof(char));
  b->v1[b->n]=VectFromVal(x[0]);
  b->intens[b->n]=x[1].value.dblval;
  b->type[b->n++]='S'; return x[0];}
TValue BlobAddCylindricalFunc(TValue *x, void *data)
{ TBlobStruct *b=(TBlobStruct *)data;
  b->v1=(TVector *)realloc(b->v1, (b->n+1)*sizeof(TVector));
  b->v2=(TVector *)realloc(b->v2, (b->n+1)*sizeof(TVector));
  b->intens=(double *)realloc(b->intens, (b->n+1)*sizeof(double));
  b->type=(char *)realloc(b->type, (b->n+1)*sizeof(char));
  b->v1[b->n]=VectFromVal(x[0]);
  b->v2[b->n]=VectFromVal(x[1]);
  b->intens[b->n]=x[2].value.dblval;
  b->type[b->n++]='C'; return x[0];}
TValue BlobAddPlanarFunc(TValue *x, void *data)
{ TBlobStruct *b=(TBlobStruct *)data;
  b->v1=(TVector *)realloc(b->v1, (b->n+1)*sizeof(TVector));
  b->v2=(TVector *)realloc(b->v2, (b->n+1)*sizeof(TVector));
  b->intens=(double *)realloc(b->intens, (b->n+1)*sizeof(double));
  b->type=(char *)realloc(b->type, (b->n+1)*sizeof(char));
  b->v1[b->n]=VectFromVal(x[0]);
  b->v2[b->n]=VectFromVal(x[1]);
  b->intens[b->n]=x[2].value.dblval;
  b->type[b->n++]='P'; return x[0];}

typedef struct {TVector *p; double *intens, *rad; int n;} TMetaballStruct;

TValue MetaballAddSphericalFunc(TValue *x, void *data)
{ TMetaballStruct *m=(TMetaballStruct *)data;
  m->p=(TVector *)realloc(m->p, (m->n+1)*sizeof(TVector));
  m->intens=(double *)realloc(m->intens, (m->n+1)*sizeof(double));
  m->rad=(double *)realloc(m->rad, (m->n+1)*sizeof(double));
  m->p[m->n]=VectFromVal(x[0]);
  m->intens[m->n]=x[1].value.dblval;
  m->rad[m->n++]=x[2].value.dblval;
  return x[0];}

TValue HeightFieldSetSizeFunc(TValue *x, void *data)
{ TUserHeightField *MyField=new TUserHeightField(x[0].value.intval, x[1].value.intval);
  *((TUserHeightField **)data)=MyField;}
TValue HeightFieldSetHeightFunc(TValue *x, void *data)
{ TUserHeightField *MyField=*((TUserHeightField**)data);
  if (data==NULL) {parse_error=1; MessageFunc("heightfield scope", 0, 0, "Set size of heightfield before setting height values"); return x[0];}
  MyField->SetHeight(x[0].value.intval, x[1].value.intval, x[2].value.dblval);
  return x[0];}


TValue TextureAddBaseCubesFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyText->BaseAlgo=new TText_Cubes(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z,
                                   x[1].value.vectval.x,x[1].value.vectval.y,x[1].value.vectval.z);
  return x[0];
}
TValue TextureAddBaseMarbleFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyText->BaseAlgo=new TText_Marble(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z,
                                    x[1].value.vectval.x,x[1].value.vectval.y,x[1].value.vectval.z, x[2].value.dblval);
  return x[0];
}
TValue TextureAddBaseWoodFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyText->BaseAlgo=new TText_Wood(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z,
                                  x[1].value.vectval.x,x[1].value.vectval.y,x[1].value.vectval.z);
  return x[0];
}
TValue TextureAddBaseCloudFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyText->BaseAlgo=new TText_Cloud(x[0].value.dblval);
  return x[0];
}
TValue TextureAddBaseStarFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyText->BaseAlgo=new TText_Star(x[0].value.dblval, x[1].value.dblval);
  return x[0];
}
TValue TextureAddBaseMapXYFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data; TText_MapBmpXY *MyBase;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyBase=new TText_MapBmpXY(GetStringFromTable(x[0].value.stringno));
  if (MyBase->Bmp==NULL) {delete MyText; parse_error=1; MessageFunc("texture scope", 0, 0, "File not found: %s",GetStringFromTable(x[0].value.stringno)); return x[0];}
  MyText->BaseAlgo=MyBase;
  return x[0];
}
TValue TextureAddBaseMapCylindricalFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data; TText_MapBmpCylindrical *MyBase;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyBase=new TText_MapBmpCylindrical(GetStringFromTable(x[0].value.stringno));
  if (MyBase->Bmp==NULL) {delete MyText; parse_error=1; MessageFunc("texture scope", 0, 0, "File not found: %s",GetStringFromTable(x[0].value.stringno)); return x[0];}
  MyText->BaseAlgo=MyBase;
  return x[0];
}
TValue TextureAddBaseMapSphericalFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data; TText_MapBmpSpherical *MyBase;
  if (MyText->BaseAlgo!=NULL) {parse_error=1; MessageFunc("texture scope", 0, 0, "Cannot have multiple base algorithms in the same texture"); return x[0];}
  MyBase=new TText_MapBmpSpherical(GetStringFromTable(x[0].value.stringno));
  if (MyBase->Bmp==NULL) {delete MyText; parse_error=1; MessageFunc("texture scope", 0, 0, "File not found: %s",GetStringFromTable(x[0].value.stringno)); return x[0];}
  MyText->BaseAlgo=MyBase;
  return x[0];
}
TValue TextureAddTranslateModifierFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  MyText->addmodifier(new TMod_Translate(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z)); return x[0];}
TValue TextureAddScaleModifierFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  MyText->addmodifier(new TMod_Scale(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z)); return x[0];}
TValue TextureAddRotateModifierFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  MyText->addmodifier(new TMod_Rotate(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z)); return x[0];}
TValue TextureAddNoiseModifierFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  MyText->addmodifier(new TMod_Noise(x[0].value.intval,x[1].value.dblval)); return x[0];}
TValue TextureAddTurbulenceModifierFunc(TValue *x, void *data)
{ TTexture *MyText=(TTexture *)data;
  MyText->addmodifier(new TMod_Turbulence(x[0].value.intval,x[1].value.dblval)); return x[0];}

TValue MeshAddTriangleFunc(TValue *x, void *data)
{ TVector v1, v2, v3;
  v1=VectFromVal(x[0]); v2=VectFromVal(x[1]); v3=VectFromVal(x[2]);
  ((TMesh*)data)->AddTriangle(v1, v2, v3);}
TValue MeshNewSurfaceFunc(TValue *x, void *data)
{ ((TMesh*)data)->NewSurface(); }


TValue SetRefpointFunc(TValue *x, void *data)
{
  TObjectScope *o=(TObjectScope *)data;
  TVector v;
  char *name=GetStringFromTable(x[0].value.stringno);
  if (strlen(name)>PARSE_IDLEN)
  {
    parse_error=1;
    MessageFunc(o->filename, o->getlineno(), 0, "Name too long: %s", name);
    return x[1];
  }
  v.x=x[1].value.vectval.x; v.y=x[1].value.vectval.y; v.z=x[1].value.vectval.z;
  o->AddRefPoint(GetStringFromTable(x[0].value.stringno), v);
  return x[1];
}

TValue GetRefpointFunc(TValue *x, void *data)
{
  TObjectScope *o=(TObjectScope *)data;
  return o->GetRefPoint(GetStringFromTable(x[0].value.stringno));
}


TObjectScope::TObjectScope(char *ptype, unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent, void *paramdata)
:TScope(ptext, pfilename, pfirstline, pGlobalVars, pGlobalFuncs, pparent)
{
  strcpy(type, ptype);

  iscontainer=0;
  if (!strcmp(type,"sphere"))
    MyObject=new TSphere();
  else if (!strcmp(type,"test"))
    MyObject=CreateTorus(1.0,0.2,10,10);
  else if (!strcmp(type,"polygon"))
  { MyObject=new TPolygon(); AddUserFunction("addpoint",1,"V", PolygonAddPointFunc, (void *)MyObject); }
  else if (!strcmp(type,"intersection"))
  { MyObject=new TIntersection(); iscontainer=1;}
  else if (!strcmp(type,"container"))
  { MyObject=new TContainer(); iscontainer=1;}
  else if (!strcmp(type,"union"))
  { MyObject=new TUnion(); iscontainer=1;}
  else if (!strcmp(type,"subtraction"))
  { MyObject=new TSubtraction(); iscontainer=1;}
  else if (!strcmp(type,"disk"))
    AddLocalVar_double("radi",0.0);
  else if (!strcmp(type,"cylinder"))
    MyObject=new TCylinder();
  else if (!strcmp(type,"cube"))
    MyObject=new TCube();
  else if (!strcmp(type,"tube"))
    AddLocalVar_double("radi",0.0);
  else if (!strcmp(type,"cone")) {
    AddLocalVar_double("x1",0.0); AddLocalVar_double("y1",-1.0);
    AddLocalVar_double("x2",1.0); AddLocalVar_double("y2",0.0);}
  else if (!strcmp(type,"rotobj")) {
    MyObject=new TRotobj(); AddUserFunction("addpoint",2,"DD",RotobjAddPointFunc, (void *)MyObject); }
  else if (!strcmp(type,"implicit")) {
    MyObject=new TEqnObject(); AddUserFunction("addcoeff",4,"DIII",EqnobjAddKoeffFunc, (void *)MyObject); }
  else if (!strcmp(type,"sqellipsoid"))
    AddLocalVar_int("degree",4);
  else if (!strcmp(type,"torus")) {
    AddLocalVar_double("rad1",1.0); AddLocalVar_double("rad2",0.2);}
  else if (!strcmp(type,"sor")) {
    TSorStruct *x=(TSorStruct *)malloc(sizeof (TSorStruct)); x->n=0; x->x=x->y=NULL; data=(void *)x;
    AddUserFunction("addpoint",2,"DD",SorAddPointFunc, data); }
  else if (!strcmp(type,"blob")) {
    TBlobStruct *b=(TBlobStruct *)malloc(sizeof(TBlobStruct)); b->n=0; b->v1=b->v2=NULL; b->intens=NULL; b->type=NULL; data=(void *)b;
    AddUserFunction("addspherical",2,"VD",BlobAddSphericalFunc, data);
    AddUserFunction("addcylindrical",3,"VVD",BlobAddCylindricalFunc, data);
    AddUserFunction("addplanar",3,"VVD",BlobAddPlanarFunc, data);
    AddLocalVar_double("border",1.0); }
  else if (!strcmp(type,"metaball")) {
    TMetaballStruct *m=(TMetaballStruct *)malloc(sizeof(TMetaballStruct)); m->n=0; m->p=NULL, m->rad=m->intens=NULL; data=(void *)m;
    AddUserFunction("addspherical",3,"VDD",MetaballAddSphericalFunc, data);
    AddLocalVar_double("border",1.0); }
  else if (!strcmp(type,"dust")) {
    AddLocalVar_double("density",10);
    AddLocalVar_double("reflection",0.02);}
  else if (!strcmp(type,"heightfield")) {
    data=malloc(sizeof(TUserHeightField*));
    AddUserFunction("setsize",2,"II",HeightFieldSetSizeFunc, data);
    AddUserFunction("setheight",3,"IID",HeightFieldSetHeightFunc, data);}
  else if (!strcmp(type,"landscape")) {
    AddLocalVar_int("size",9);
    AddLocalVar_double("delta",4000);
    AddLocalVar_double("fracdim",2.3);
    AddLocalVar_int("srand",0);
    AddLocalVar_double("h1",0.0);
    AddLocalVar_double("h2",0.0);
    AddLocalVar_double("h3",0.0);
    AddLocalVar_double("h4",0.0);}
  else if (!strcmp(type,"heightmap")) {
    data=paramdata;
    AddLocalVar_int("xpoints",100);
    AddLocalVar_int("ypoints",100);}
  else if (!strcmp(type,"texture")) {
    iscontainer=1;
    MyObject=new TTexture(); data=(void *)MyObject;
    AddUserFunction("cubes",2,"VV",TextureAddBaseCubesFunc, data);
    AddUserFunction("marble",3,"VVD",TextureAddBaseMarbleFunc, data);
    AddUserFunction("wood",2,"VV",TextureAddBaseWoodFunc, data);
    AddUserFunction("cloud",1,"D",TextureAddBaseCloudFunc, data);
    AddUserFunction("star",2,"DD",TextureAddBaseStarFunc, data);
    AddUserFunction("mapxy",1,"S",TextureAddBaseMapXYFunc, data);
    AddUserFunction("mapcylindrical",1,"S",TextureAddBaseMapCylindricalFunc, data);
    AddUserFunction("mapspherical",1,"S",TextureAddBaseMapSphericalFunc, data);
    AddUserFunction("textscale",1,"V",TextureAddScaleModifierFunc, data);
    AddUserFunction("textrotate",1,"V",TextureAddRotateModifierFunc, data);
    AddUserFunction("texttranslate",1,"V",TextureAddTranslateModifierFunc, data);
    AddUserFunction("textnoise",2,"ID",TextureAddNoiseModifierFunc, data);
    AddUserFunction("textturbulence",2,"ID",TextureAddTurbulenceModifierFunc, data); }
  else if (!strcmp(type,"mesh")){
    MyObject=new TMesh();
    data=(void *)MyObject;
    AddUserFunction("addtriangle",3,"VVV",MeshAddTriangleFunc, data);
    AddUserFunction("newsurface",0,"",MeshNewSurfaceFunc, data);
  }



  else {parse_error=1; MessageFunc(filename, getlineno(), 0, "%s: Unknown object type", type); return;}

  AddLocalVar_vect("pos",TVector(0,0,0));
  AddLocalVar_vect("rotate",TVector(0,0,0));
  AddLocalVar_vect("scale",TVector(1,1,1));

  AddUserFunction("setrefpoint",2,"SV", SetRefpointFunc, (void *)this);
  AddUserFunction("getrefpoint",1,"S", GetRefpointFunc, (void *)this);

  if (!iscontainer){
    ++parser_objectno;
    AddLocalVar_vect("color",TVector(255,255,255));
    AddLocalVar_double("reflect",VarExists("reflect")?GetLocalVar_double("reflect"):0.0);
    AddLocalVar_double("trans",VarExists("trans")?GetLocalVar_double("trans"):0.0);
    AddLocalVar_double("flat",VarExists("flat")?GetLocalVar_double("flat"):1.0);
    AddLocalVar_double("phong",VarExists("phong")?GetLocalVar_double("phong"):0.0);
    AddLocalVar_double("phongsize",VarExists("phongsize")?GetLocalVar_double("phongsize"):0.0);
    AddLocalVar_double("fraction",VarExists("fraction")?GetLocalVar_double("fraction"):1.0);
  }
  else ++parser_containerno;
}

T3dObject *TObjectScope::GetObject()
{
  TVector v;
  int isdust=0; //Sonderbehandlung fr Staub

  if (!strcmp(type,"disk"))
    MyObject=new TDisk(GetLocalVar_double("radi"));
  else if (!strcmp(type,"tube"))
    MyObject=new TTube(GetLocalVar_double("radi"));
  else if (!strcmp(type,"cone"))
    MyObject=new TCone(GetLocalVar_double("x1"), GetLocalVar_double("y1"),
                       GetLocalVar_double("x2"), GetLocalVar_double("y2"));
  else if (!strcmp(type,"sqellipsoid"))
    MyObject=new TSQEllipsoid(GetLocalVar_int("degree"));
  else if (!strcmp(type,"torus"))
    MyObject=new TTorus(GetLocalVar_double("rad1"), GetLocalVar_double("rad2"));
  else if (!strcmp(type,"sor"))
  { TSorStruct *p=(TSorStruct *)data;
    MyObject=new TSor(p->n, p->x, p->y);
    free(p->x); free(p->y); free(p); }
  else if (!strcmp(type, "blob"))
  { TBlobStruct *b=(TBlobStruct *)data;
    MyObject=new TBlob(GetLocalVar_double("border"));
    TBlob *Blob=(TBlob *)MyObject;
    for (int i=0; i<b->n; ++i) {
      switch(b->type[i]){
        case 'S': Blob->AddSpherical(b->v1[i].x, b->v1[i].y, b->v1[i].z, b->intens[i]); break;
        case 'C': Blob->AddCylindrical(b->v1[i], b->v2[i], b->intens[i]); break;
        case 'P': Blob->AddPlanar(b->v1[i], b->v2[i], b->intens[i]); break;
      }
    }
    Blob->calculate();
    free(b->v1); free(b->v2); free(b->type); free(b->intens); free(b); }
  else if (!strcmp(type,"metaball"))
  { TMetaballStruct *m=(TMetaballStruct *)data;
    MyObject=new TMetaBall(GetLocalVar_double("border"));
    TMetaBall *Metaball=(TMetaBall *)MyObject;
    for (int i=0; i<m->n; ++i)
      Metaball->AddSpherical(m->p[i].x, m->p[i].y, m->p[i].z, m->intens[i], m->rad[i]);
    free(m->p); free(m->intens); free(m->rad); free(m);  }
  else if (!strcmp(type,"dust")) {
    MyObject=new TDust(GetLocalVar_double("density"), GetLocalVar_double("reflection")); isdust=1;}
  else if (!strcmp(type,"heightfield")){
    if (*((TUserHeightField **)data)==NULL) { parse_error=1; MessageFunc(filename, getlineno(), 0, "Size of heightfield undefined"); return;}
    MyObject=*((TUserHeightField **)data);
    free(data);}
  else if (!strcmp(type,"landscape"))
    MyObject=new TLandscape(GetLocalVar_int("size"), GetLocalVar_double("fracdim"), GetLocalVar_double("delta"), GetLocalVar_int("srand"),
                            GetLocalVar_double("h1"), GetLocalVar_double("h2"), GetLocalVar_double("h3"), GetLocalVar_double("h4"));

  else if (!strcmp(type,"heightmap")) {
    int ret;
    MyObject=new TBMPHeightField(GetLocalVar_int("xpoints"), GetLocalVar_int("ypoints"), (char *)data, ret);
    if (!ret) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Error in bitmap %s or file not found", (char *)data); return;}}
  else if (!strcmp(type,"mesh")) {
    ((TMesh*)MyObject)->Done();
  }

  v=GetLocalVar_vect("color");
  MyObject->clrred=v.x;
  MyObject->clrgreen=v.y;
  MyObject->clrblue=v.z;
  MyObject->pos=GetLocalVar_vect("pos");
  v=GetLocalVar_vect("rotate");
  MyObject->rotatex=v.x;
  MyObject->rotatey=v.y;
  MyObject->rotatez=v.z;
  v=GetLocalVar_vect("scale");
  MyObject->scalex=v.x;
  MyObject->scaley=v.y;
  MyObject->scalez=v.z;

  for (int i=0; i<RefPointNo; ++i)
  {
    v=RefPoints[i].pos;
    v.x*=MyObject->scalex;
    v.y*=MyObject->scaley;
    v.z*=MyObject->scalez;
    v.rotate(0, 0, MyObject->rotatez);
    v.rotate(0, MyObject->rotatey, 0);
    v.rotate(MyObject->rotatex, 0, 0);
    v+=MyObject->pos;
    parent->AddRefPoint(RefPoints[i].name, v);
  }

  MyObject->reflect=GetLocalVar_double("reflect");
  if (!isdust) MyObject->trans=GetLocalVar_double("trans");
  if (!isdust) MyObject->flat=GetLocalVar_double("flat");
  MyObject->light=GetLocalVar_double("phong");
  MyObject->phongsize=GetLocalVar_double("phongsize");
  MyObject->brech=GetLocalVar_double("fraction");

  if (!strcmp(type,"polygon"))
  {
    TPolygon *p=(TPolygon *)MyObject;
    if (p->numpoint<3) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Polygon must have at least 3 corners"); return;}
  } else if (!strcmp(type,"subtraction"))
  { if (((TSubtraction*)MyObject)->Objb==NULL) {parse_error=1; MessageFunc(filename, getlineno(), 0, "You have to add two objects to a subtraction object"); return;}
  } else if (!strcmp(type,"rotobj"))
  { if (((TRotobj *)MyObject)->numpoint<2) {parse_error=1; MessageFunc(filename, getlineno(), 0, "Rotobj must have add least 2 points"); return;}
  }


  MessageFunc(filename, getlineno(), 1, "Added %s pos=[%lg,%lg,%lg]", type, MyObject->pos.x, MyObject->pos.y, MyObject->pos.z);

  return MyObject;
}

void TObjectScope::AddObject(T3dObject *NewObj)
{
  if (!iscontainer){
    parse_error=1;
    MessageFunc(filename, getlineno(), 0, "Cannot add an object to %s object", type);
    delete NewObj;
    return;
  }
  if (strcmp(type,"subtraction"))
  {
    ((TIntersection *)MyObject)->addobject(NewObj);
  } else
  {
    TSubtraction *MySub=(TSubtraction *)MyObject;
    if (MySub->Obja==NULL) MySub->Obja=NewObj;
    else if (MySub->Objb==NULL) MySub->Objb=NewObj;
    else {parse_error=1; MessageFunc(filename, getlineno(), 0, "Cannot add more than two objects to subtraction"); delete NewObj;}
  }
}

/*****************************************************************************/

TLightScope::TLightScope(char *ptype, unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent)
:TScope(ptext, pfilename, pfirstline, pGlobalVars, pGlobalFuncs, pparent)
{
  strcpy(type, ptype);
  AddLocalVar_vect("color",TVector(255,255,255));
  AddLocalVar_vect("pos",TVector(0,0,0));
  AddLocalVar_double("intensity",100.0);
  AddLocalVar_int("shadows",1);

  if (!strcmp(type,"ambient"));
  else if (!strcmp(type,"omni"));
  else if (!strcmp(type,"spot")) {AddLocalVar_vect("to",TVector(0,0,1));AddLocalVar_double("angle",0.1);}
  else {parse_error=1; MessageFunc(filename, getlineno(), 0, "%s: Unknown light type", type); return;}

  ++parser_lightno;
}

TLightSource *TLightScope::GetLight()
{
  TVector v1,v2;
  int r, g, b;
  double intens; int shadows;
  double angle;

  v1=GetLocalVar_vect("color");
  r=(int)v1.x;g=(int)v1.y;b=(int)v1.z;
  v1=GetLocalVar_vect("pos");
  intens=GetLocalVar_double("intensity");
  shadows=GetLocalVar_int("shadows");


  if (!strcmp(type,"ambient"))
    MyLight=new TAmbientLight(r,g,b);
  else if (!strcmp(type,"omni"))
  {
    MyLight=new TOmniLight(r, g, b, intens, v1.x, v1.y, v1.z);
    MyLight->shadows=shadows;
  }
  else if (!strcmp(type,"spot"))
  {
    v2=GetLocalVar_vect("to");
    angle=GetLocalVar_double("angle");
    MyLight=new TSpotLight(r, g, b, intens, v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, angle);
    MyLight->shadows=shadows;
  }


  return MyLight;
}

void TLightScope::AddObject(T3dObject *NewObj)
{
  parse_error=1;
  MessageFunc(filename, getlineno(), 0, "Cannot add an object to light source");
  delete NewObj;
}


TCameraScope::TCameraScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent)
:TScope(ptext, pfilename, pfirstline, pGlobalVars, pGlobalFuncs, pparent)
{
  AddLocalVar_vect("pos",TVector(0,0,0));
  AddLocalVar_vect("to",TVector(0,0,10));
  AddLocalVar_double("xsize",4);
  AddLocalVar_double("ysize",3);
}

TCamera *TCameraScope::GetCamera()
{
  TVector v1,v2;
  double xsize, ysize;


  v1=GetLocalVar_vect("pos");
  v2=GetLocalVar_vect("to");
  xsize=GetLocalVar_double("xsize");
  ysize=GetLocalVar_double("ysize");

  return new TNormalCamera(v1.x, v1.y, v1.z, v2.x, v2.y, v2.z, resx, resy, xsize, ysize);
}

void TCameraScope::AddObject(T3dObject *NewObj)
{
  parse_error=1;
  MessageFunc(filename, getlineno(), 0, "Cannot add an object to a camera");
  delete NewObj;
}
