#ifndef PARSER_H
#define PARSER_H

#include<stdio.h>
#include"exp_parser.h"
#include"tvector.h"
#include"ray20.h"

#define PARSE_FILENAMELEN  80
#define PARSE_EXPRESSION_LEN 1000
#define PARSE_IDLEN     30


extern void (*MessageFunc)(char *filename, int lineno, int debuglevel, char *str, ...);
extern int parse_error;

extern TRaytracer *Parser_TheTracer;

extern int resx, resy;

extern int parser_containerno, parser_objectno, parser_lightno;

void parser_resetcounters(void);

typedef struct tagMacro
{
  unsigned char name[PARSE_IDLEN+1];
  char filename[PARSE_FILENAMELEN+1];
  unsigned char *text;
  int firstline;
  struct tagMacro *next;
} TMacro;

extern TMacro *parser_macros;

typedef struct
{
  char name[PARSE_IDLEN+1];
  TVector pos;
} TRefPoint;


class TScope
{
public:
  TScope *parent;

  unsigned char *text;
  int textpos, firstline;
  char filename[PARSE_FILENAMELEN+1];

  TUserFunction *MyFuncs;     //Verkettete Liste
  TUserFunction *GlobalFuncs; //    "        "
  TVariable *MyVars;          //    "        "
  TVariable *GlobalVars;      //    "        "
  TRefPoint *RefPoints;       //Array!
  int RefPointNo;

  void AddUserFunction(char *name, int argno, char *argtype, TValue (*TheFunc)(TValue *x, void *data), void *data);
  void AddLocalVar_double(char *name, double init);
  void AddLocalVar_int(char *name, int init);
  void AddLocalVar_vect(char *name, TVector init);
  double GetLocalVar_double(char *name);
  int GetLocalVar_int(char *name);
  TVector GetLocalVar_vect(char *name);
  void AddRefPoint(char *name, TVector pos);
  TValue GetRefPoint(char *name);

  int VarExists(char *name);

  void Skip(int OnlyComments=0); //Kommentare, Zeilenumbrche etc. berspringen
  void GetSpecialChar(char c);   //berprfe ob da das Zeichen c steht
  void GetString(char *dest, int maxlen);  //z.B. in #include"..."
  void GetExpressionUntil(char *dest, unsigned char c);
  int GetKeyword(void);
  TMacro *GetMacro(void);
  void GetName(char *dest);

  void GetSubScope(unsigned char *&dest, int &startline);//Fr dest wird Speicher reserviert!

  virtual int getchar(void); //Lowlevel-Funktion zum einlesen eines Zeichens; -1=End of Scope
  virtual int getpos(void);
  virtual void setpos(int pos);
  int getlineno(void);
  int eof(void);

  TScope(char *pfilename, TVariable *pGlobalVars, TUserFunction *pFuncs, TScope *pparent=NULL);
  TScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pFuncs, TScope *pparent);
  void Run(void);
  ~TScope();

  virtual void AddObject(T3dObject *NewObj);
};

class TForScope: public TScope
{
  char *initexpr, *breakexpr, *loopexpr;
  char done;
  char evalloop;

  virtual int getchar(void);
  virtual int getpos(void);
  virtual void setpos(int pos);

public:
  TForScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pFuncs, char *pinitexpr, char *pbreakexpr, char *ploopexpr, TScope *pparent);
  ~TForScope();
};



/*****************************************************************************/

class TObjectScope: public TScope
{
  char type[PARSE_IDLEN+1];

  T3dObject *MyObject;
  int iscontainer;
  void *data;


public:
  TObjectScope(char *ptype, unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent, void *paramdata=NULL);

  T3dObject *GetObject(void);
  virtual void AddObject(T3dObject *NewObj);
};

class TLightScope: public TScope
{
  char type[PARSE_IDLEN+1];
  TLightSource *MyLight;

public:
  TLightScope(char *ptype, unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent);
  TLightSource *GetLight(void);
  virtual void AddObject(T3dObject *NewObj);
};

class TCameraScope: public TScope
{
public:
  TCameraScope(unsigned char *ptext, char *pfilename, int pfirstline, TVariable *pGlobalVars, TUserFunction *pGlobalFuncs, TScope *pparent);
  TCamera *GetCamera(void);
  virtual void AddObject(T3dObject *NewObj);
};

TUserFunction *InitFuncLib(void);
void ClearFuncLib(void);


#endif
