#include"parser.h"
#include"tvector.h"

TUserFunction *FuncLib=NULL;


void AddFunctionToFunclib(char *name, int argno, char *argtype, TValue (*TheFunc)(TValue *x, void *data))
{
  TUserFunction *NewFunc=(TUserFunction *)malloc(sizeof(TUserFunction));
  NewFunc->funcname=name;
  NewFunc->argno=argno;
  NewFunc->argtype=argtype;
  NewFunc->EvalFunc=TheFunc;
  NewFunc->next=FuncLib;
  NewFunc->data=NULL;
  FuncLib=NewFunc;
}

typedef struct{
  double *values;
  int firstindex, lastindex;
  char name[STRING_LENGTH];
} TFLArray;

TFLArray *FL_MyArrays=NULL;
int FL_ArrayNum=0;


void ClearFuncLib(void)
{
  TUserFunction *CurFunc=FuncLib, *Tmp;
  while(CurFunc!=NULL)
  {
    Tmp=CurFunc->next; free(CurFunc); CurFunc=Tmp;
  }
  FuncLib=NULL;

  for (int i=0; i<FL_ArrayNum; ++i)
    free(FL_MyArrays[i].values);
  free(FL_MyArrays);
  FL_MyArrays=NULL;
  FL_ArrayNum=0;
}

TValue FLPrintFunc(TValue *x, void *data)
{
  MessageFunc("",0,1,"%s",GetStringFromTable(x[0].value.stringno));
  return x[0];
}

void ResizeArray(TFLArray *TheArray, int newfirstind, int newlastind)
{
  TheArray->values=(double *)realloc(TheArray->values,sizeof(double)*(newlastind-newfirstind+1));
  memmove(TheArray->values+TheArray->firstindex-newfirstind, TheArray->values, sizeof(double)*(TheArray->lastindex-TheArray->firstindex+1));
  TheArray->firstindex=newfirstind;
  TheArray->lastindex=newlastind;
}

TValue FLArraySetFunc(TValue *x, void *data)
{
  int i,j=x[1].value.intval;
  char *s=GetStringFromTable(x[0].value.stringno);
  for (i=0; i<FL_ArrayNum;++i)
  {
    if (!strcmp(s, FL_MyArrays[i].name))
    {
      if (j<FL_MyArrays[i].firstindex)
        ResizeArray(FL_MyArrays+i, j, FL_MyArrays[i].lastindex);
      else if (j>FL_MyArrays[i].lastindex)
        ResizeArray(FL_MyArrays+i, FL_MyArrays[i].firstindex, j);
      FL_MyArrays[i].values[j-FL_MyArrays[i].firstindex]=x[2].value.dblval;
      return x[2];
    }
  }
  FL_ArrayNum++;
  FL_MyArrays=(TFLArray*)realloc(FL_MyArrays, sizeof(TFLArray)*FL_ArrayNum);
  FL_MyArrays[FL_ArrayNum-1].firstindex=FL_MyArrays[FL_ArrayNum-1].lastindex=j;
  FL_MyArrays[FL_ArrayNum-1].values=(double *)malloc(sizeof(double));
  FL_MyArrays[FL_ArrayNum-1].values[0]=x[2].value.dblval;
  strcpy(FL_MyArrays[FL_ArrayNum-1].name, s);
  return x[2];
}

TValue FLArrayGetFunc(TValue *x, void *data)
{
  int i,j=x[1].value.intval;
  char *s=GetStringFromTable(x[0].value.stringno);
  TValue ret;
  ret.type=VARTYPE_DOUBLE;

  for (i=0; i<FL_ArrayNum;++i)
  {
    if (!strcmp(s, FL_MyArrays[i].name))
    {
      if ((j<FL_MyArrays[i].firstindex)||(j>FL_MyArrays[i].lastindex))
      {
        MessageFunc("",0,0,"Array index exceeds Limits: array(\"%s\",%d)",s,j);
        parse_error=1;
        return;
      }
      ret.value.dblval=FL_MyArrays[i].values[j-FL_MyArrays[i].firstindex];
      return ret;
    }
  }
  parse_error=1;
  MessageFunc("",0,0,"Undefined array: \"%s\"",s);
}

TValue FLRotateFunc(TValue *x, void *data)
{
  TVector p1(x[0].value.vectval.x,x[0].value.vectval.y,x[0].value.vectval.z);
  TVector p2(x[1].value.vectval.x,x[1].value.vectval.y,x[1].value.vectval.z);
  TVector p3=p1-p2;
  double ax=x[2].value.vectval.x;
  double ay=x[2].value.vectval.y;
  double az=x[2].value.vectval.z;
  TValue ret;

  p3.rotate(ax,ay,az);
  p3+=p2;
  ret.type=VARTYPE_VECTOR;
  ret.value.vectval.x=p3.x;
  ret.value.vectval.y=p3.y;
  ret.value.vectval.z=p3.z;
  return ret;
}


TUserFunction *InitFuncLib(void)
{
  AddFunctionToFunclib("print",1,"S",FLPrintFunc);
  AddFunctionToFunclib("arrayset",3,"SID",FLArraySetFunc);
  AddFunctionToFunclib("array",2,"SI",FLArrayGetFunc);
  AddFunctionToFunclib("rotate",3,"VVV",FLRotateFunc);
  return FuncLib;
}
