/****************************************************************************/
/* Rechnen mit Polynomen aus R[x]  (double - Genauigkeit)                   */
/*              (c) 1997 by Martin Melcher, 4th Dimension Arts              */
/****************************************************************************/

#ifndef POLY_HEADER

#define MAXDEG 10

class TPolynom
{
public:
  double koeff[MAXDEG+1];                          /* koeff[0] = Absolutes Glied         */
  int degree;
  TPolynom();
  TPolynom(int deg, ...);                          /* Koeffizienten, aufsteigend         */
  TPolynom operator +=  (TPolynom const &A);
  TPolynom operator -=  (TPolynom const &A);
  TPolynom operator *=  (TPolynom const &A);
  TPolynom operator >>= (int A);                   /* Rechtsschieben -> Grad veringern   */
  TPolynom operator <<= (int A);                   /* Linksschieben  -> Grad erhhen     */
  TPolynom operator *=  (double A);                /* Alle Koeffizienten                 */
  TPolynom operator /=  (double A);                /* Alle Koeffizienten                 */
  TPolynom operator /   (TPolynom const &A) const; /* Polynomdivision (Rest weglassen)   */
  TPolynom operator %   (TPolynom const &A) const; /* Polynomdivision - Restpolynom      */
  TPolynom operator -   () const;                  /*  * -1                              */
  int      operator ==  (double A) const;          /* Polynom konst. = A                 */
  int      operator !=  (double A) const;          /* Verneinung von ==                  */
  TPolynom Diff         ();                        /* Ableiten                           */
  TPolynom ggT          (TPolynom const &B) const; /* ggT ausrechnen                     */
  double   eval(double x) const;                   /* Wert ausrechnen (nach Horner)      */
private:
  void MinimizeDeg();
};

#define POLY_HEADER
#endif
