/****************************************************************************/
/* Polynomlser - ggf. Sturm'sche Ketten benutzen                           */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include<math.h>
#include<stddef.h>
#include"polysolv.h"

TPolySolver::TPolySolver(TPolynom &A)
{
  Poly=&A;
  if (Poly->degree>2)
    Sturm=new TSturm(*Poly);
  else
    Sturm=NULL;
}

TPolySolver::~TPolySolver()
{
  if (Sturm!=NULL) delete Sturm;
}


char TPolySolver::has0(double start, double max)
{
  if (Poly->degree>2)
    return Sturm->Wechsel(start+DIST)-Sturm->Wechsel(max==DBL_MAX ? Sturm->NullMax() : max);
  else
  {
    if (Poly->degree==1) return 1;
    if (*Poly==0) return 1;
    if (Poly->degree==0 && Poly->koeff[0]!=0) return 0;
    if (Poly->koeff[2]==0) return 1;
    Poly->operator /= (Poly->koeff[2]);
    a=-Poly->koeff[1]/2.0;
    determ=a*a-Poly->koeff[0];
    if (determ<0) return 0;
    determ=sqrt(determ);
    if (a+determ<DIST+start) return 0;
    if (max!=DBL_MAX) if (a-determ>max-DIST) return 0;
    return 1;
  }
}

double TPolySolver::first0(double start, double max, double genau)
{
  double erg;
  if (Poly->degree>2)
  {
    Sturm->First0(erg,start, max, genau);
    return erg;
  }
  erg=a-determ;
  if (erg<DIST+start) erg=a+determ;
  return erg;
}
