/****************************************************************************/
/* 4th RayTrace 2.0 - Die Hochleistungs-RayTrace-Engine                     */
/* Objektorientertes Raytrace-Programmiersystem                             */
/*                Routinen fr die Echtzeit-Preview mit dem 3D-System       */
/* (c) 1996-98 by Martin Melcher, 4th Dimension Arts                        */
/****************************************************************************/

#include<math.h>
#include<stdio.h>
#ifndef IS_LINUX
#include<conio.h>
#endif
#include"ray20.h"
#include"ray20scp.h"
#include"lights.h"
#include"objects.h"
#include"cameras.h"
#include"RT/polygons.h"
#include"RT/create.h"
#include"RT/guroud.h"
#include"RT/glidegfx.h"

//---------------------------- Lichtquellen --------------------------------//

void TLightSource::RT_Create(TLightData *LightData) //Standard: Nix
{
  return;
}

void TOmniLight::RT_Create(TLightData *LightData)
{
  LightData->AddLight(TVector(pos), intensity, clrred, clrgreen, clrblue);
}

void TAmbientLight::RT_Create(TLightData *LightData)
{
  backr=clrred; backg=clrgreen; backb=clrblue;
}

//---------------------------- Objekte -------------------------------------//

TObject_RT *T3dObject::RT_Create(T3dData *Data, TLightData *Lights, int detail) //Standard: Nix
{
  TObject_RT *ret=new TObject_RT(Data);
  return ret;
}

void T3dObject::RT_Transform(T3dData *Data)
{
  Data->scale(scalex, scaley, scalez);
  Data->rotate(TVector(0.0,0.0,0.0), 0, 0, rotatez*M_PI/180.0); //Der Raytracer rotiert in einer anderen Reihenfolge!
  Data->rotate(TVector(0.0,0.0,0.0), 0, rotatey*M_PI/180.0, 0); //Der Raytracer rotiert in einer anderen Reihenfolge!
  Data->rotate(TVector(0.0,0.0,0.0), rotatex*M_PI/180.0, 0, 0); //Der Raytracer rotiert in einer anderen Reihenfolge!
  Data->move(TVector(midx, midy, midz));
}

TObject_RT *TSphere::RT_Create(T3dData *Data, TLightData *Lights, int detail)
{
  defaultmaterial.phongsize=phongsize;
  defaultmaterial.light=light;
  defaultmaterial.flat=flat;

  return Light2Guroud(CreateSphereL(Data, Lights, TVector(0.0,0.0,0.0), 1.0, detail, PACKCOLOR(clrred, clrgreen, clrblue)));
}

TObject_RT *TCube::RT_Create(T3dData *Data, TLightData *Lights, int detail)
{
  TObject_RT *Tmp;
  defaultmaterial.phongsize=phongsize;
  defaultmaterial.light=light;
  defaultmaterial.flat=flat;
  if (detail<=1)
    return CreateCubeLight(Data, Lights, TVector(0.0,0.0,0.0), 0.5, 0.5, 0.5, PACKCOLOR(clrred, clrgreen, clrblue));
  else
  {
    useoldpoints=0;
    Tmp=Light2Guroud(CreateCubeLight(Data, Lights, TVector(0.0,0.0,0.0), 0.5, 0.5, 0.5, PACKCOLOR(clrred, clrgreen, clrblue)));
    useoldpoints=1;
    return Tmp;
  }
}

//----------------------------- Kamera -------------------------------------//
void TNormalCamera::RT_Project(T3dData *Data, int screenresx, int screenresy)
{
  TVector dirvec=TVector(refpoint)-TVector(pos);
  TVector tmp=dirvec;
  double angx,angy;
  tmp.a=0;
  angx=tmp.cosangle(TVector(0,0,1));
  angx=angx<2?acos(angx):0;
  if (tmp.b>0) angx=-angx;
  tmp=dirvec; tmp.rotate(-angx,0,0);
  angy=tmp.cosangle(TVector(0,0,1));
  angy=angy<2?acos(angy):0;
  if (tmp.a<0) angy=-angy;
  Data->move(-TVector(pos));
  Data->rotate(TVector(0.0,0.0,0.0),-angx,-angy,0);
  //  Data->scale(screenresx/xsize, screenresy/ysize, zfp/(double)dirvec);
  if (xsize>ysize*screenresx/screenresy)
  {
    Data->scale(screenresx/xsize, screenresx/xsize, screenresx/xsize);
    zfp=(double)dirvec*screenresx/xsize;
  }
  else
  {
    Data->scale(screenresy/ysize, screenresy/ysize, screenresy/ysize);
    zfp=(double)dirvec*screenresy/ysize;
  }
}

void TNormalCamera::RT_Project(TVector *v, int screenresx, int screenresy)
{
  TVector dirvec=TVector(refpoint)-TVector(pos);
  TVector tmp=dirvec;
  double angx,angy;
  tmp.a=0;
  angx=tmp.cosangle(TVector(0,0,1));
  angx=angx<2?acos(angx):0;
  if (tmp.b>0) angx=-angx;
  tmp=dirvec; tmp.rotate(-angx,0,0);
  angy=tmp.cosangle(TVector(0,0,1));
  angy=angy<2?acos(angy):0;
  if (tmp.a<0) angy=-angy;
  *v-=TVector(pos);
  v->rotate(-angx, -angy, 0);
  if (xsize>ysize*screenresx/screenresy)
    {  v->a*=screenresx/xsize; v->b*=screenresx/xsize; v->c*=screenresx/xsize;}
  else
    {  v->a*=screenresy/ysize; v->b*=screenresy/ysize; v->c*=screenresy/ysize;}

  //  v->a*=screenresx/xsize; v->b*=screenresy/ysize; v->c*=ZFP/(double)dirvec;
}

void TNormalCamera::RT_Project(TLightData *Lights, int screenresx, int screenresy)
{
  int i;
  double factor;
  if (xsize>ysize*screenresx/screenresy)
    factor=(double)screenresx/xsize;
  else
    factor=(double)screenresy/ysize;

  for (i=0;i<Lights->LightNo;++i)
    Lights->Intensity[i]*=factor*factor;

}
 
//------------------------- Hauptroutinen ----------------------------------//


int main(int argc, char *argv[])
{
  T3dWorld *PreviewWorld=new T3dWorld();
  T3dData *Data;
  TLightData *Lights=new TLightData();
  int i;

  printf("\nAnalysieren der Script-Datei...");fflush(stdout);
  if (!compilescript(argv[1]))
  {
    printf("\rFehler");
    if (errorline!=0) printf(" in Zeile %d",errorline);
    printf(":\n%s\n\n",errormsg);
    return 2;
  }
  printf("OK\r\n");

  printf("Lichtquellen umwandeln...\n");

  for (i=0; i<TheTracer->numlight;++i)
    TheTracer->Light[i]->RT_Create(Lights);

  printf("Objekte erzeugen..\n");

  Data=new T3dData[TheTracer->numobj](1);
  for (i=0; i<TheTracer->numobj;++i)
    PreviewWorld->AddObject(TheTracer->Object[i]->RT_Create(Data+i, Lights, 2));

  printf("Lichtquellen tansformieren..\n");

  for (i=0; i<Lights->LightNo; ++i)
    TheTracer->Camera->RT_Project(Lights->Pos+i, 640, 480);

  TheTracer->Camera->RT_Project(Lights, 640, 480);

  printf("Objekte transformieren..\n");

  for (i=0; i<TheTracer->numobj; ++i)
    TheTracer->Object[i]->RT_Transform(Data+i);

  printf("Objekte Projizieren..\n");
  
  for (i=0; i<TheTracer->numobj; ++i)
    TheTracer->Camera->RT_Project(Data+i, 640, 480);

  printf("Darstellen..\n");

  Use_GlideGfx(640,480,GLIDE_MODE_ZBUFFER);
  gfx_init();

  gfx_nextpic();
  ResetGuroud();
  DrawWorld(*PreviewWorld);
  gfx_nextpic();
  ResetGuroud();
  DrawWorld(*PreviewWorld);
  gfx_nextpic();
  getch();

  gfx_done();

  return 0;
}
