/****************************************************************************/
/* RayTrace 3.0 - Die Hochleistungs-RayTrace-Engine                         */
/*                                                                          */
/* Objektorientertes Raytrace-Programmiersystem                             */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include"tvector.h"
#include<math.h>
#include"ray20.h"
#include<stdlib.h>
//#include<dos.h>

#ifdef USE_SHEAP
#include<sheap.h>
#endif
//#pragma inline

unsigned long cuts=0; //Anz. Schnittberechnungen
unsigned long traces=0; //Anz. Lichtstrahlen
unsigned long inobjs=0; //Anz. der "Isinobj"-Berechnungen
unsigned long optimizedcuts=0;  //Anz. wegoptimierter Schnittberechnungen
unsigned long optimizedinobjs=0;//Anz. wegoptimierter "Inobj"-Berechnungen


/****** NextCut: Nchster Schnittpunkt auf dem zuvor mit SetRay angegebenen Strahl
        unter Verwendung der Transformationen*/

char T3dObject::NextCut(double &t)
{
  double myt;

  if (!rayprocessed)
  {
    TVector temp;
    double t, len;

    rayprocessed=1;

    nocuts=0;
    isfirst=1;
    lastt=1e-8;  //Ab hier Schnittpunkte berechnen
    faraway=0;

    if (fabs(scalex)<1e-10||fabs(scaley)<1e-10||fabs(scalez)<1e-10) return 0;

    nstart=start-pos;

    ndir=dir;

    if (!optimized)
      optimize();
  //Rotation

    if (rotatebits&1) /*Roteatex!=0*/
    {
      temp=nstart;
      nstart.y=temp.y*rotcosx-temp.z*rotsinx;
      nstart.z=temp.y*rotsinx+temp.z*rotcosx;

      temp=ndir;
      ndir.y=temp.y*rotcosx-temp.z*rotsinx;
      ndir.z=temp.y*rotsinx+temp.z*rotcosx;
    }

    if (rotatebits&2) /*Rotatey!=0*/
    {
      temp=nstart;
      nstart.x=temp.x*rotcosy+temp.z*rotsiny;
      nstart.z=-temp.x*rotsiny+temp.z*rotcosy;

      temp=ndir;
      ndir.x=temp.x*rotcosy+temp.z*rotsiny;
      ndir.z=-temp.x*rotsiny+temp.z*rotcosy;
    }

    if (rotatebits&4) /*Rotatez!=0*/
    {
      temp=nstart;
      nstart.x=temp.x*rotcosz-temp.y*rotsinz;
      nstart.y=temp.x*rotsinz+temp.y*rotcosz;

      temp=ndir;
      ndir.x=temp.x*rotcosz-temp.y*rotsinz;
      ndir.y=temp.x*rotsinz+temp.y*rotcosz;
    }

  //Skalierung
    if (scalebits)
    {
      if (scalebits&1){  nstart.x/=scalex;  ndir.x/=scalex;}
      if (scalebits&2){  nstart.y/=scaley;  ndir.y/=scaley;}
      if (scalebits&4){  nstart.z/=scalez;  ndir.z/=scalez;}
      len=(double)ndir;  //vectlen(dir);(ist HOFFENTLICH[!] 1)!
      ndir/=len;
      if (maxt!=DBL_MAX) nmaxt=maxt*len-1e-8;
      else nmaxt=DBL_MAX;
      tfactor=1.0/len;
    } else {tfactor=1; nmaxt=(maxt==DBL_MAX)?DBL_MAX:maxt-1e-8;}

  //Optimierkugel berprfen
    if (spherecalculated)
      if (spherem.abstpg2(nstart,ndir)>spherer2+1e-4)
      {
        faraway=1;
        ++optimizedcuts;
        return 0;
      }

  //ggf. Bounding Object berprfen
    if (BoundingObject!=NULL)
    {
      BoundingObject->SetRay(nstart, ndir, nmaxt);
      if (!BoundingObject->NextCut(t))
      {
        faraway=1;
        ++optimizedcuts;
        return 0;
      }
    }
    if (needssubprocessing) SubProcessRay();
  } //if (!rayprocessed)
  if (startset)
  {
    lastt=start_unscaled/tfactor+1e-8;
    startset=0;
  }

  ++cuts;
  if (nocuts||faraway) {++optimizedcuts; return 0;}
  if (!Obj_NextCut(myt)) { nocuts=1;  return 0;}
  isfirst=0;
  t=myt*tfactor;
  lastt=myt+1e-8;
  return 1;
}

/****** GetNormVect: Normalenvektor zurckliefern; dabei zurcktransformieren */
TVector T3dObject::GetNormVect(void)
{
  TVector temp,mynorm=Obj_GetNormVect();

//"Zurck"skalieren
  if (scalebits&1) {  mynorm.x/=scalex;}
  if (scalebits&2) {  mynorm.y/=scaley;}
  if (scalebits&4) {  mynorm.z/=scalez;}

//Der Normvektor mu entsprechend "Auseinandergezogen" werden
  if (scalebits) mynorm.normalize();

//Zurckrotieren
  if (rotatebits&4) //rotatez!=0
  {
    temp=mynorm;
    mynorm.x=temp.x*rotcosz+temp.y*rotsinz;
    mynorm.y=-temp.x*rotsinz+temp.y*rotcosz;
  }
  if (rotatebits&2) //rotatey!=0
  {
    temp=mynorm;
    mynorm.x=temp.x*rotcosy-temp.z*rotsiny;
    mynorm.z=+temp.x*rotsiny+temp.z*rotcosy;
  }
  if (rotatebits&1) //rotatex!=0
  {
    temp=mynorm;
    mynorm.y=temp.y*rotcosx+temp.z*rotsinx;
    mynorm.z=-temp.y*rotsinx+temp.z*rotcosx;
  }
  return mynorm;
}

char T3dObject::InObject(double t)
{
  if (!rayprocessed)
  {
    TVector temp;
    double t, len;

    rayprocessed=1;

    nocuts=0;
    isfirst=1;
    lastt=1e-8;  //Ab hier Schnittpunkte berechnen
    faraway=0;

    if (fabs(scalex)<1e-10||fabs(scaley)<1e-10||fabs(scalez)<1e-10) return 0;

    nstart=start-pos;

    ndir=dir;

    if (!optimized)
      optimize();
  //Rotation

    if (rotatebits&1) /*Roteatex!=0*/
    {
      temp=nstart;
      nstart.y=temp.y*rotcosx-temp.z*rotsinx;
      nstart.z=temp.y*rotsinx+temp.z*rotcosx;

      temp=ndir;
      ndir.y=temp.y*rotcosx-temp.z*rotsinx;
      ndir.z=temp.y*rotsinx+temp.z*rotcosx;
    }

    if (rotatebits&2) /*Rotatey!=0*/
    {
      temp=nstart;
      nstart.x=temp.x*rotcosy+temp.z*rotsiny;
      nstart.z=-temp.x*rotsiny+temp.z*rotcosy;

      temp=ndir;
      ndir.x=temp.x*rotcosy+temp.z*rotsiny;
      ndir.z=-temp.x*rotsiny+temp.z*rotcosy;
    }

    if (rotatebits&4) /*Rotatez!=0*/
    {
      temp=nstart;
      nstart.x=temp.x*rotcosz-temp.y*rotsinz;
      nstart.y=temp.x*rotsinz+temp.y*rotcosz;

      temp=ndir;
      ndir.x=temp.x*rotcosz-temp.y*rotsinz;
      ndir.y=temp.x*rotsinz+temp.y*rotcosz;
    }

  //Skalierung
    if (scalebits)
    {
      if (scalebits&1){  nstart.x/=scalex;  ndir.x/=scalex;}
      if (scalebits&2){  nstart.y/=scaley;  ndir.y/=scaley;}
      if (scalebits&4){  nstart.z/=scalez;  ndir.z/=scalez;}
      len=(double)ndir;  //vectlen(dir);(ist HOFFENTLICH[!] 1)!
      ndir/=len;
      if (maxt!=DBL_MAX) nmaxt=maxt*len-1e-8;
      else nmaxt=DBL_MAX;
      tfactor=1.0/len;
    } else {tfactor=1; nmaxt=(maxt==DBL_MAX)?DBL_MAX:maxt-1e-8;}

  //Optimierkugel berprfen
    if (spherecalculated)
      if (spherem.abstpg2(nstart,ndir)>spherer2+1e-4)
      {
        faraway=1;
        goto InObj_Main;
      }

  //ggf. Bounding Object berprfen
    if (BoundingObject!=NULL)
    {
      BoundingObject->SetRay(nstart, ndir, nmaxt);
      if (!BoundingObject->NextCut(t))
      {
        faraway=1;
        goto InObj_Main;
      }
    }
    if (needssubprocessing) SubProcessRay();
  } //if (!rayprocessed)

InObj_Main:
  ++inobjs;
  if (faraway&&(t<nmaxt)) {++optimizedinobjs; return 0;}
//  if ((t>lastt)&&(t<nmaxt)&&nocuts) {++optimizedinobjs; return 0;}
  if (spherecalculated)
  {
    TVector p=nstart+ndir*(t/tfactor);
    if ((p-spherem).len2()>spherer2) {++optimizedinobjs; return 0;}
  }
  if (BoundingObject!=NULL)
    if (!BoundingObject->InObject(t/tfactor)) {++optimizedinobjs; return 0;}

  return Obj_InObject(t/tfactor);
}

void T3dObject::calcsphere()
{
}

void T3dObject::MakeBoundingObject()
{
  BoundingObject=NULL;
}

void T3dObject::optimize()
{
  optimized=1;
  rotatebits=0;
  if (fabs(rotatex)>1e-10) rotatebits|=1;
  if (fabs(rotatey)>1e-10) rotatebits|=2;
  if (fabs(rotatez)>1e-10) rotatebits|=4;

  rotsinx=sin(-rotatex);
  rotcosx=cos(rotatex);
  rotsiny=sin(-rotatey);
  rotcosy=cos(rotatey);
  rotsinz=sin(-rotatez);
  rotcosz=cos(rotatez);

  scalebits=0;
  if (fabs(scalex-1)>1e-10) scalebits|=1;
  if (fabs(scaley-1)>1e-10) scalebits|=2;
  if (fabs(scalez-1)>1e-10) scalebits|=4;

  if (!nosphere)
    calcsphere();

  MakeBoundingObject();
}

TLightSource::TLightSource(int r, int g, int b, double intens, double x, double y, double z)
{
  clrred=r;clrgreen=g;clrblue=b;
  intensity=intens;
  pos.x=x;pos.y=y;pos.z=z;
  shadows=1;
}

TCamera::TCamera(double x, double y, double z, double xr, double yr, double zr, int xres, int yres)
{
  pos.x=x;pos.y=y;pos.z=z;
  refpoint.x=xr;refpoint.y=yr;refpoint.z=zr;
  resx=xres;resy=yres;
}

TRaytracer::TRaytracer()
{
  Object=NULL;
  Light=NULL;
  Camera=NULL;
  numobj=0;
  numlight=0;
}

TRaytracer::~TRaytracer()
{
  int i;
  for (i=0;i<numobj;++i)
    delete Object[i];
  delete Camera;
  for (i=0;i<numlight;++i)
    delete Light[i];
  free(Object);
  free(Light);
}

PT3dObject lastobject;

void TRaytracer::addobject(PT3dObject NewObject)
{
  Object=(PT3dObject *)realloc(Object,sizeof(PT3dObject)*++numobj);
  lastobject=Object[numobj-1]=NewObject;
}

void TRaytracer::addlight(PTLightSource NewLight)
{
  Light=(PTLightSource *)realloc(Light,sizeof(PTLightSource)*++numlight);
  Light[numlight-1]=NewLight;
}

void TRaytracer::createcamera(PTCamera NewCamera)
{
  Camera=NewCamera;
}

int castshadows=1;
int maxdepth=10;
char radiosity=0;
char nodust=0;
