/****************************************************************************/
/* 4th RayTrace 3.0 - Die Hochleistungs-RayTrace-Engine                     */
/*                                                                          */
/* Objektorientertes Raytrace-Programmiersystem                             */
/* (c) 1996-99 by Martin Melcher, 4th Dimension Arts                        */
/****************************************************************************/

#ifndef RAY20HEADER

#include<stddef.h>
#include<float.h>
#include"types.h"
#include"tvector.h"
#ifdef RTPREVIEW
#include"RT/3dstuff.h"      //Echtzeit-Preview
#include"RT/polygons.h"
#endif

extern int maxdepth;

class TObjectData
{
public:
  int clrred,clrgreen,clrblue; //Oberflchenfarbe

  double reflect,trans,flat,light;  //Oberflcheneingenschaften (0..1)
  double phongsize;                 //Kehrwert des Exponenten fr cos, gibt lichtpunktgre an.

  double scalex,scaley,scalez;
  double rotatex,rotatey,rotatez;

  TVector pos;

  double brech; //Brechungsindex (0=Luft)

  char nodither;

  int type,subtype;
};

typedef TObjectData *PTObjectData;

class T3dObject : public TObjectData
{
public:
// Daten fr die Optimierung: Umgebende Objekte
  char spherecalculated;           // Umgebende Kugel zur Optimierung
  TVector spherem;                 // Mittelpunkt (Relativ zur Objektmitte)
  double spherer2;                 // Quadrat des Kugelradius
  char nosphere;                   // Keine Kugel ausrechnen!
                                   // (z.B. nicht bei jeder Flche eines Wrfels)
  T3dObject *BoundingObject;       //Bei komplizierten Objekten: Umgebendes Objekt; wird in MakeBoundingObject() [von optimize() aufgerufen] erstellt
                                   //und in callfirstcut bzw. callisinobj benutzt
  
//Daten fr die Drehung/Skalierung
  double rotcosx,rotsinx,rotcosy,rotsiny,rotcosz,rotsinz;
  char optimized;
  unsigned char rotatebits;
  unsigned char scalebits;

//Daten fr die Schnittpunktberechnung (Zwischenspeicherung)
  double tfactor, maxt, nmaxt, lastt;
  TVector dir, start;   //Vor Transformation
  TVector ndir, nstart; //Nach Transformation
  char nocuts;  //Dieser Strahl schneidet nicht mehr
  char faraway; //Der Strahl schneidet das Objekt berhaupt nicht
  double start_unscaled; //Wird in SetStart bergeben, dabei wird auch
  char startset;         //<- auf 1 gesetzt, damit bei erfolgter Strahlberechnung lastt
                         //richtig gesetzt werden kann

  char isfirst;
  char rayprocessed;
  char needssubprocessing;

  T3dObject()
  {
    spherecalculated=0;
    scalex=scaley=scalez=1;
    rotatex=rotatey=rotatez=0;
    pos=TVector(0,0,0);
    trans=reflect=light=0;
    flat=1;
    brech=1;
    phongsize=0.5;

    optimized=0;
    nodither=0;
    nosphere=0;
    subtype=-1;
    
    BoundingObject=NULL;

    needssubprocessing=0;
  }

//Schnittpunktberechnung, Aufruffunktionen (fhren Transformationen durch und rufen die Objektfunktionen auf)
  void SetRay(TVector const &pstart, TVector const &pdir, double pmaxt=DBL_MAX)
  {
    start=pstart; dir=pdir; maxt=pmaxt; rayprocessed=0;
  }
                                                         //Auf diesem Strahl mssen demnchst Schnittpunkte berechnet werden
  char NextCut(double &t);                               //Berechne den nchsten Schnittpunkt auf dem zuvor mit SetRay angegebenen Strahl
  TVector GetNormVect(void);                             //Normalenvektor auf den zuletzt berechneten Schnittpunkt

  virtual void SubProcessRay(void) {} //Teile den Unterobjekten nstart und ndir als start und dir mit
                                      //(z.B. bei Containern)

//Schnittpunktberechnung, Objektfunktionen
  virtual char Obj_NextCut(double &t)=0; //Nchster Schnittpunkt hinter lastt
  virtual TVector Obj_GetNormVect(void)=0;
  void SetStart(double t) {start_unscaled=t; startset=1; nocuts=0;}     //setze lastt=t

//Ist der Punkt im Objekt??
  char InObject(double t);
  virtual char Obj_InObject(double t)=0;


  virtual void calcsphere();  //Sollte fr Optimierungen berschrieben werden!
  virtual void MakeBoundingObject(); //Auch fr Optimierungen

  void optimize();
  virtual ~T3dObject() {if (BoundingObject!=NULL) delete BoundingObject;}

#ifdef RTPREVIEW
//----------------- 
  virtual TObject_RT *RT_Create(T3dData *Data, TLightData *Lights, int detail); //Fr Echtzeit-Preview; Ohne rotieren&skalieren
  void RT_Transform(T3dData *Data); //Rotieren, Skalieren, Verschieben
//-----------------
#endif
};

typedef T3dObject *PT3dObject;

class TLightSource
{
public:

  int clrred, clrgreen,clrblue;
  int type;
  double intensity;
  TVector pos;
  char shadows;

  TLightSource(int r, int g, int b, double intens, double x, double y, double z);
  virtual void getcolor(TObjectData *Object, TVector const &cut, TVector const &normvect, double &red, double &green, double &blue, int type=LIGHT)=0;

#ifdef RTPREVIEW
//-----------------
  virtual void RT_Create(TLightData *LightData); //Fr Echtzeit-Preview
//-----------------
#endif
};

#define TYPE_OMNI 20
#define TYPE_AMBIENT 21
#define TYPE_SPOT 22

typedef TLightSource *PTLightSource;

class TCamera
{
public:
  TVector pos;
  TVector refpoint;
  int resx,resy;

  TCamera(double x, double y, double z, double xr, double yr, double zr, int xres, int yres);
  virtual TVector getvector(int x, int y)=0;

#ifdef RTPREVIEW
//-----------------
  virtual void RT_Project(T3dData *Data, int screenresx, int screenresy)=0; //Rotiere&Skaliere so, dass das der Kameraprojektion entspricht
  virtual void RT_Project(TVector *v, int screenresx, int screenresy)=0;
  virtual void RT_Project(TLightData *Lights, int screenresx, int screenresy)=0; //Intensitten der Lichtquellen der Skalierung anpassen
//-----------------
#endif
};

typedef TCamera *PTCamera;

extern PT3dObject lastobject;

//Gesamtstatistik
extern unsigned long cuts; //Anz. Schnittberechnungen
extern unsigned long traces; //Anz. Lichtstrahlen
extern unsigned long inobjs; //Anz. der "Isinobj"-Berechnungen
extern unsigned long optimizedcuts;  //Anz. wegoptimierter Schnittberechnungen
extern unsigned long optimizedinobjs;//Anz. wegoptimierter "Inobj"-Berechnungen

class TRaytracer
{
public:
  PT3dObject *Object;
  PTLightSource *Light;
  PTCamera Camera;
  int numlight,numobj;

  TRaytracer();
  ~TRaytracer();
  void addobject(PT3dObject NewObject);
  void addlight(PTLightSource NewLight);
  void createcamera(PTCamera NewCamera);
  void trace(int x, int y, double &r, double &g, double &b);
  void traceray(TVector &start, TVector &dir, double &r, double &g, double &b, int depth=0);
};

typedef TRaytracer *PTRaytracer;

extern int castshadows;
extern char radiosity;
extern char nodither;
extern char nodust;

#ifndef M_PI
#define M_PI 3.1415926535897932385
#endif

#define RAY20HEADER


#endif



