/****************************************************************************/
/* RAY20MAI.CC     Hauptprogramm fr DOS/Linux                              */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/
#include<stdio.h>
#include"ray20.h"
#include"objects.h"
#include"lights.h"
#include"cameras.h"
#include"ray20scp.h"
#include"bmpwrite.h"

int main(int argc, char *argv[])
{
  double fr,fg,fb;
  int r,g,b,x,y;
  TBMPFile *Mybmp;
  long pix;

  if (argc!=5)
  {
parerror:
    printf("\r\nSyntaxfehler!\n");
    printf("Rufen Sie 4th Raytracer 2.0 folgendermaen auf:\n");
    printf("  RAY20 <dateiname> <resx> <resy> <Ziel-Bitmap>\n");
    printf("     dateiname   Name der RayScript-Datei mit den Objektdefinitionen\n");
    printf("     resx,resy   Gewnschte Bildauflsung\n");
    printf("     Ziel-Bitmap Name der zu schreibenden BMP-Datei\n\n");
    return 1;
  }
  if (!sscanf(argv[2],"%d",&resx)) goto parerror;
  if (!sscanf(argv[3],"%d",&resy)) goto parerror;

  printf("\nAnalysieren der Script-Datei...");fflush(stdout);
  if (!compilescript(argv[1]))
  {
    printf("\rFehler");
    if (errorline!=0) printf(" in Zeile %d",errorline);
    printf(":\n%s\n\n",errormsg);
    return 2;
  }
  printf("OK\r\n");

  Mybmp=new TBMPFile(argv[4],resx,resy,24);
  Mybmp->writeheaders();

  for (y=resy-1;y>=0;--y)
  {
    printf("%6.1lf%%...\r",(double)(resy-y)*100.0/resy);
    fflush(stdout);
    for (x=0;x<resx;++x)
    {
      TheTracer->trace(x,y,fr,fg,fb);
      r=fr; if (fr>255) r=255;
      g=fg; if (fg>255) g=255;
      b=fb; if (fb>255) b=255;
      pix=((long)r<<16)|((long)g<<8)|b;
      Mybmp->writepixel(pix);
    }
  }
  printf("Fertig!\n\n");
  printf("Gesamtstatistik\n");
  printf("===============\n");
  printf("%7d Schnittpunktberechnungen,\n", cuts);
  printf("%7d wegoptimiert\n", optimizedcuts);
  printf("%7d InObject-Berechnungen,\n",inobjs);
  printf("%7d wegoptimiert\n",optimizedinobjs);
  printf("%7d Lichtstrahlen\n\n",traces);

  delete Mybmp;
  return 0;
}