/****************************************************************************/
/* RAY20MAI_LINUX.CC     Hauptprogramm fr Linux                            */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/
#include<stdio.h>
#include<getopt.h>
#include<time.h>
#include"ray20.h"
#include"objects.h"
#include"lights.h"
#include"cameras.h"
#include"ray20scp.h"
#include"bmpwrite.h"

void display_help(void)
{
  fprintf(stderr, "\r\nAufruf: ray20 Script-Datei resx resy Ziel-Bitmap [-s][-d][-h][-r maxrecur][-b debuglevel]\n");
  fprintf(stderr, "   Script-Datei    Script-Datei mit den Objektdefinitionen\n");
  fprintf(stderr, "   resx, resy      Auflsung des Ausgabe-Bitmaps\n");
  fprintf(stderr, "   Ziel-Bitmap     Ausgabe-Datei (Windows TrueColor-Bitmap)\n\n");
  fprintf(stderr, "   -s              Keine Schattenberechnung\n");
  fprintf(stderr, "   -d              Keine Staubatmosphre\n");
  fprintf(stderr, "   -r maxrecur     Rekursionstiefe auf maxrecur beschrnken (standard: 10)\n");
  fprintf(stderr, "   -b debuglevel   Anzeigen beim Durchgehen der Scriptdatei (0..3). Standard:0\n");
  fprintf(stderr, "   -h              Diese Hilfe anzeigen\n");
}

void MessageFunc(int lineno, char *message)
{
  printf("%03d: %s\n", lineno, message);
  fflush(stdout);
}


int main(int argc, char *argv[])
{
  double fr,fg,fb;
  int r,g,b,x,y;
  TBMPFile *Mybmp;
  long pix;
  int curopt;
  int debuglevel=0;
  clock_t time1, time2;

  opterr=0;

  do
  {
    curopt=getopt(argc, argv, "r:sdhb:");
    switch(curopt)
    {
      case '?': case 'h':
        display_help();
        return 1;
      case 's':
        castshadows=0;
        break;
      case 'd':
        nodust=1;
        break;
      case 'r':
        if (sscanf(optarg,"%d", &maxdepth)!=1)
        { display_help(); return 1; }
        break;
      case 'b':
        if (sscanf(optarg,"%d", &debuglevel)!=1)
        { display_help(); return 1; }
        break;
    }
  }while (curopt!=EOF);

  if (argc-optind<4)
  { display_help(); return 1; }

  if (!sscanf(argv[optind+1],"%d",&resx)) {display_help(); return 1;}
  if (!sscanf(argv[optind+2],"%d",&resy)) {display_help(); return 1;}

  printf("\nAnalysieren der Script-Datei...\n");
  if (!compilescript(argv[optind], MessageFunc, debuglevel))
  {
    fprintf(stderr, "Fehler");
    if (errorline!=0) fprintf(stderr, " in Zeile %d",errorline);
    fprintf(stderr, ":\n  %s\n\n",errormsg);
    return 2;
  }
  printf("OK\r\n");

  Mybmp=new TBMPFile(argv[optind+3],resx,resy,24);
  Mybmp->writeheaders();

  time1=clock();

  for (y=resy-1;y>=0;--y)
  {
    printf("%6.1lf%%...\r",(double)(resy-y)*100.0/resy);
    fflush(stdout);
    for (x=0;x<resx;++x)
    {
      TheTracer->trace(x,y,fr,fg,fb);
      r=fr; if (fr>255) r=255;
      g=fg; if (fg>255) g=255;
      b=fb; if (fb>255) b=255;
      pix=((long)r<<16)|((long)g<<8)|b;
      Mybmp->writepixel(pix);
    }
  }
  time2=clock();
  time2-=time1;
  time2/=CLOCKS_PER_SEC;
  printf("Fertig!\n\n");
  printf("Gesamtstatistik\n");
  printf("===============\n");
  printf("%11d Schnittpunktberechnungen,\n", cuts);
  printf("%11d wegoptimiert\n", optimizedcuts);
  printf("%11d InObject-Berechnungen,\n",inobjs);
  printf("%11d wegoptimiert\n",optimizedinobjs);
  printf("%11d Lichtstrahlen\n\n",traces);
  printf("Gebrauchte Rechenzeit: %02d:%02d:%02d\n\n",time2/3600, (time2%3600)/60, time2%60);

  delete Mybmp;
  return 0;
}