/****************************************************************************/
/* RAY20MAI_LINUX.CC     Hauptprogramm fr Linux                            */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/
#include<stdio.h>
#include<getopt.h>
#include<time.h>
#include<stdarg.h>
#include"ray20.h"
#include"objects.h"
#include"lights.h"
#include"cameras.h"
#include"parser.h"
#include"bmpwrite.h"
#include"ppmwrite.h"

int debuglevel=0;

void display_help(void)
{
  fprintf(stderr, "\r\nAufruf: ray3   Script-Datei resx resy Ziel-Bitmap [-s][-d][-h][-r maxrecur][-b debuglevel]\n");
  fprintf(stderr, "   Script-Datei    Script-Datei mit den Objektdefinitionen\n");
  fprintf(stderr, "   resx, resy      Auflsung des Ausgabe-Bitmaps\n");
  fprintf(stderr, "   Ziel-Bitmap     Ausgabe-Datei (Windows TrueColor-Bitmap)\n");
  fprintf(stderr, "                   Bei Animationen Anfang der Ausgabedateinamen\n\n");
  fprintf(stderr, "   -s              Keine Schattenberechnung\n");
  fprintf(stderr, "   -d              Keine Staubatmosphre\n");
  fprintf(stderr, "   -r maxrecur     Rekursionstiefe auf maxrecur beschrnken (standard: 10)\n");
  fprintf(stderr, "   -b debuglevel   Anzeigen beim Durchgehen der Scriptdatei (0..3). Standard:0\n");
  fprintf(stderr, "   -h              Diese Hilfe anzeigen\n");
  fprintf(stderr, "   -a frames       Berechnet eine Animation mit frames Bildern. Die Variable time luft\n");
  fprintf(stderr, "                   von 0 bis 1. Ausgabe im pbm-Format.\n\n");
  fprintf(stderr, "Bsp 1: ray3 test.r3 320 240 test.bmp     #Berechnet test.r3 in 320x240 und speichert\n");
  fprintf(stderr, "                                         #das Ergebnis in test.bmp\n");
  fprintf(stderr, "Bsp 2: ray3 anim.r3 320 240 frame -a 100 #Berechnet eine Animation aus 100 Bilderun\n");
  fprintf(stderr, "                                         #und speichert das Ergebnis in frame1.pbm..frame100.bpm\n\n");


}


void MyMsgFunc(char *filename, int lineno, int level, char *s, ...)
{
  va_list arg;
//  if (level>debuglevel) return;
  va_start(arg, s);
  if (strlen(filename)>0)
  {
    printf("File %s line %03d: ",filename, lineno);
    vprintf(s, arg);
  } else
    vprintf(s, arg);
  printf("\n");
  va_end(arg);
  fflush(stdout);
}

int main(int argc, char *argv[])
{
  double fr,fg,fb;
  int r,g,b,x,y;
  long pix;
  int curopt;
  int debuglevel=0;
  int frames=1;
  int makeanim=0;
  double time1, time2;
  unsigned long secs;
  TRaytracer *TheTracer;
  TScope *MyParser;
  TVariable *MyConst, *VarLauf;

  opterr=0;

  do
  {
    curopt=getopt(argc, argv, "r:sdhb:a:");
    switch(curopt)
    {
      case '?': case 'h':
        display_help();
        return 1;
      case 's':
        castshadows=0;
        break;
      case 'd':
        nodust=1;
        break;
      case 'r':
        if (sscanf(optarg,"%d", &maxdepth)!=1)
        { display_help(); return 1; }
        break;
      case 'b':
        if (sscanf(optarg,"%d", &debuglevel)!=1)
        { display_help(); return 1; }
        break;
      case 'a':
        if (sscanf(optarg,"%d", &frames)!=1)
        { display_help(); return 1;}
        makeanim=1;
        break;
    }
  }while (curopt!=EOF);

  if (argc-optind<4)
  { display_help(); return 1; }

  if (!sscanf(argv[optind+1],"%d",&resx)) {display_help(); return 1;}
  if (!sscanf(argv[optind+2],"%d",&resy)) {display_help(); return 1;}

//---------------------Einzelbild berechnen-------------------------------
  if (!makeanim)
  {
    TBMPFile *Mybmp;

    printf("\nAnalysieren der Script-Datei...\n");

  //--Variablen fr die Script-Sprache
    MyConst=(TVariable *)malloc(sizeof(TVariable));
    strcpy(MyConst->varname,"pi");
    MyConst->isconstant=1;
    MyConst->value.type=VARTYPE_DOUBLE;
    MyConst->value.value.dblval=M_PI;
    VarLauf=MyConst;
    VarLauf->next=(TVariable *)malloc(sizeof(TVariable));
    strcpy(VarLauf->next->varname,"e");
    VarLauf->next->isconstant=1;
    VarLauf->next->value.type=VARTYPE_DOUBLE;
    VarLauf->next->value.value.dblval=M_E;
    VarLauf=VarLauf->next;
    VarLauf->next=NULL;
  //--

    TheTracer=new TRaytracer();
    Parser_TheTracer=TheTracer;
    MessageFunc=MyMsgFunc;
    MyParser=new TScope(argv[optind], MyConst, InitFuncLib());
    if (!parse_error)
      MyParser->Run();
    ClearFuncLib();
    delete MyParser;
    if (parse_error) return 1;

    if (TheTracer->Camera==NULL){
      printf("No camera defined!\n");
      return 1;
    }

    printf("OK\r\n");

    printf("---\r\n%4d objects\r\n%4d container\r\n%4d lights\r\n---\r\n",parser_objectno, parser_containerno, parser_lightno);

    Mybmp=new TBMPFile(argv[optind+3],resx,resy,24);
    Mybmp->writeheaders();

    time1=clock();

    for (y=resy-1;y>=0;--y)
    {
      printf("%6.1lf%%...\r",(double)(resy-y)*100.0/resy);
      fflush(stdout);
      for (x=0;x<resx;++x)
      {
        TheTracer->trace(x,y,fr,fg,fb);
        r=fr; if (fr>255) r=255;
        g=fg; if (fg>255) g=255;
        b=fb; if (fb>255) b=255;
        pix=((long)r<<16)|((long)g<<8)|b;
        Mybmp->writepixel(pix);
      }
    }
    time2=clock();
    time2-=time1;
    time2/=(double)CLOCKS_PER_SEC;
    secs=time2;
    printf("Fertig!\n\n");
    printf("Gesamtstatistik\n");
    printf("===============\n");
    printf("%11d Schnittpunktberechnungen,\n", cuts);
    printf("%11d wegoptimiert\n", optimizedcuts);
    printf("%11d InObject-Berechnungen,\n",inobjs);
    printf("%11d wegoptimiert\n",optimizedinobjs);
    printf("%11d Lichtstrahlen\n\n",traces);
    printf("Gebrauchte Rechenzeit: %02u:%02u:%02u\n\n",secs/3600u, (secs%3600u)/60u, secs%60u);

    delete Mybmp;
    return 0;
  } else {
//--------------Animation berechnen-------------------------------
    TPPMFile *Myppm;
    int frame;
    char framename[100];

    time1=clock();

    for (frame=1; frame<=frames; ++frame)
    {
      printf("\nFrame %d/%3d:\n------------\n", frame, frames);

      printf("Analysieren der Script-Datei...\n");

    //--Variablen fr die Script-Sprache
      MyConst=(TVariable *)malloc(sizeof(TVariable));
      strcpy(MyConst->varname,"pi");
      MyConst->isconstant=1;
      MyConst->value.type=VARTYPE_DOUBLE;
      MyConst->value.value.dblval=M_PI;
      VarLauf=MyConst;
      VarLauf->next=(TVariable *)malloc(sizeof(TVariable));
      strcpy(VarLauf->next->varname,"e");
      VarLauf->next->isconstant=1;
      VarLauf->next->value.type=VARTYPE_DOUBLE;
      VarLauf->next->value.value.dblval=M_E;
      VarLauf=VarLauf->next;
      VarLauf->next=NULL;
      VarLauf->next=(TVariable *)malloc(sizeof(TVariable));
      strcpy(VarLauf->next->varname,"time");
      VarLauf->next->isconstant=1;
      VarLauf->next->value.type=VARTYPE_DOUBLE;
      VarLauf->next->value.value.dblval=(double)(frame-1.0)/(frames>1?(frames-1.0):1.0);
      VarLauf=VarLauf->next;
      VarLauf->next=NULL;
    //--

      parser_resetcounters();
      TheTracer=new TRaytracer();
      Parser_TheTracer=TheTracer;
      MessageFunc=MyMsgFunc;
      MyParser=new TScope(argv[optind], MyConst, InitFuncLib());
      if (!parse_error)
        MyParser->Run();
      ClearFuncLib();
      delete MyParser;
      if (parse_error) return 1;

      if (TheTracer->Camera==NULL){
        printf("No camera defined!\n");
        return 1;
      }

      printf("OK: ");

      printf("%4d objects, %4d container, %4d lights\r\n",parser_objectno, parser_containerno, parser_lightno);

      sprintf(framename,"%s%d.ppm", argv[optind+3], frame);
      Myppm=new TPPMFile(framename,resx,resy);
      Myppm->writeheaders();

      for (y=0; y<=resy-1; ++y)
      {
        printf("%6.1lf%%...\r",(double)y*100.0/(resy-1));
        fflush(stdout);
        for (x=0;x<resx;++x)
        {
          TheTracer->trace(x,y,fr,fg,fb);
          r=fr; if (fr>255) r=255;
          g=fg; if (fg>255) g=255;
          b=fb; if (fb>255) b=255;
          pix=((long)r<<16)|((long)g<<8)|b;
          Myppm->writepixel(pix);
        }
      }
      delete Myppm;
      delete TheTracer;
    }
    time2=clock();
    time2-=time1;
    time2/=(double)CLOCKS_PER_SEC;
    secs=time2;
    printf("Fertig!\n\n");
    printf("Gesamtstatistik\n");
    printf("===============\n");
    printf("%11u Schnittpunktberechnungen,\n", cuts);
    printf("%11u wegoptimiert\n", optimizedcuts);
    printf("%11u InObject-Berechnungen,\n",inobjs);
    printf("%11u wegoptimiert\n",optimizedinobjs);
    printf("%11u Lichtstrahlen\n\n",traces);
    printf("Gebrauchte Rechenzeit: %02u:%02u:%02u\n\n",secs/3600u, (secs%3600u)/60u, secs%60u);
    return 0;

  }
}