/****************************************************************************/
/* Einlesen von BMP-Dateien mit oder ohne Farbpalette                       */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/
#include<stdio.h>
#include<stdlib.h>
#include"readbmp.h"

#ifdef IS_LINUX
#define ATTR __attribute__ ((__packed__))
#else
#define ATTR
#endif

#ifdef __WATCOM__
_Packed struct BMPInputHeader {
#else
struct BMPInputHeader{
#endif
  char stuff1[18] ATTR;
  long xsize ATTR;
  long ysize ATTR;
  char nothing2[2] ATTR;
  short int bits ATTR;
  char nothing3[24] ATTR;
} ;


TBMPInput::TBMPInput(char *filename)
{
  BMPInputHeader MyHeader;
  
  xsize=ysize=0;
  rgb=0;
  FILE *datei=fopen(filename,"rb");
  if (datei==NULL) return;
  fread(&MyHeader, sizeof(BMPInputHeader), 1, datei);
  if ((MyHeader.bits!=24) && (MyHeader.bits!=8))
  {
    fclose(datei);
    return;
  }
  if ((MyHeader.stuff1[0]!='B')||(MyHeader.stuff1[1]!='M'))
  {
    fclose(datei);
    return;
  }
  xsize=MyHeader.xsize;
  ysize=MyHeader.ysize;
  if (MyHeader.bits==24)
  {
    scanlinesize=(int)((3*xsize+3)/4)*4;
    rgb=(char *)malloc(scanlinesize*ysize);
    fread(rgb, 1, scanlinesize*ysize, datei);
  }
  else
  {
    unsigned char palette[4*256];
    unsigned char *buffer;
    scanlinesize=(int)((xsize+3)/4)*4;
    buffer=(char *)malloc(scanlinesize*ysize);
    rgb=(char *)malloc(scanlinesize*3*ysize);
    fread(palette, 1, 4*256, datei);
    fread(buffer, 1, scanlinesize*ysize, datei);
    for (int i=0; i<scanlinesize*ysize; ++i)
    {
      rgb[3*i+0]=palette[4*buffer[i]+0];
      rgb[3*i+1]=palette[4*buffer[i]+1];
      rgb[3*i+2]=palette[4*buffer[i]+2];
    }
    scanlinesize*=3;
    free(buffer);
  }
  fclose(datei);
}

TBMPInput::~TBMPInput()
{
  if (rgb!=NULL) free(rgb);
}

void TBMPInput::GetPixel(int x, int y, int &r, int &g, int &b)
{
  r=rgb[(ysize-y-1)*scanlinesize+3*x+2];
  g=rgb[(ysize-y-1)*scanlinesize+3*x+1];
  b=rgb[(ysize-y-1)*scanlinesize+3*x+0];
}

