/****************************************************************************/
/* SOR.CC  - Surface of Revolution - Rotationskrper aus 1dim. Bezierspline */
/* Basierend auf implizit definierten Oberflchen ("eqnobjs.cc")            */
/* Alle Objekte verden mit Einheitsgre und im Ursprung berechnet,         */
/* Der Rest wird in RAY20.CPP besorgt                                       */
/*     Copyright(c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* In Zusammenarbeit mit Christian Volmer (cvolmer@gmx.de)                  */
/*                                                                          */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/*                                                                          */
/****************************************************************************/

#include"objects.h"

TSorSegment::TSorSegment(double pa, double pb, double pc, double pd)
{
/* Oberflche ist definiert durch x^2+z^2-f(y)^2=0, wobei
   f(y)=a*i^3+b*i^2*j+3*c*i*j^2+d*j^3, wobei i=y, j=(1-y).
   Dieses ausgerechnet ergibt untenstehendes */

  a=pa; b=pb; c=pc; d=pd;
   
  AddKoeff( -a*a, 0,0,0);
  AddKoeff(    1, 0,0,2);
  AddKoeff(    1, 2,0,0);
  AddKoeff(6*a*a-6*a*b,0,1,0);
  AddKoeff(-15*a*a+30*a*b-9*b*b-6*a*c,0,2,0);
  AddKoeff(20*a*a-60*a*b+36*b*b+24*a*c-18*b*c-2*a*d,0,3,0);
  AddKoeff(-15*a*a+60*a*b-54*b*b-36*a*c+54*b*c-9*c*c+6*a*d-6*b*d,0,4,0);
  AddKoeff(6*a*a-30*a*b+36*b*b+24*a*c-54*b*c+18*c*c-6*a*d+12*b*d-6*c*d,0,5,0);
  AddKoeff(-a*a+6*a*b-9*b*b-6*a*c+18*b*c-9*c*c+2*a*d-6*b*d+6*c*d-d*d,0,6,0);

  ri=a; if (b<ri) ri=b; if (c<ri) ri=c; if (d<ri) ri=d;
  ra=a; if (b>ra) ra=b; if (c>ra) ra=c; if (d>ra) ra=d;
}

void TSorSegment::MakeBoundingObject()
{
  BoundingObject=new TTube(0);
  BoundingObject->pos.y=0.5;
  BoundingObject->scaley=0.51;
  BoundingObject->scalex=BoundingObject->scalez=ra*1.01;
}


char TSorSegment::Obj_NextCut(double &t)
{
  TVector cut;
  do{
    if (!TEqnObject::Obj_NextCut(t)) return 0;
    lastt=t;
    cut=nstart+ndir*t;
    if ((cut.y<=1.0)&&(cut.y>=0.0)) return 1;
  } while (1);
}

char TSorSegment::Obj_InObject(double t)
{
  double i,j;
  double f;
  TVector p=nstart+ndir*t;
  if ((p.y>1.0) || (p.y<0.0)) return 0;
  j=p.y; i=1.0-p.y;
  f=a*i*i*i+3*b*i*i*j+3*c*i*j*j+d*j*j*j;
  return p.x*p.x+p.z*p.z < f*f;
}

TSor::TSor(int pointno, double *xvals, double *yvals)
{
  T3dObject *NewSegment;
  double steigung1, steigung2, ctrl_st1, ctrl_st2, height;

  for (int i=1; i<pointno-2; ++i)
  {
      if (i>1)
      {
        steigung1=(xvals[i]-xvals[i-1])/(yvals[i]-yvals[i-1]);
        steigung2=(xvals[i+1]-xvals[i])/(yvals[i+1]-yvals[i]);
        ctrl_st1=(steigung1+steigung2)/2;
      } else {
        ctrl_st1=(xvals[i]-xvals[i-1])/(yvals[i]-yvals[i-1]);
      }
      if (i<pointno-3)
      {
        steigung1=(xvals[i+1]-xvals[i])/(yvals[i+1]-yvals[i]);
        steigung2=(xvals[i+2]-xvals[i+1])/(yvals[i+2]-yvals[i+1]);
        ctrl_st2=(steigung1+steigung2)/2;
      } else {
        ctrl_st2=(xvals[i+2]-xvals[i+1])/(yvals[i+2]-yvals[i+1]);
      }
      height=yvals[i+1]-yvals[i];
      NewSegment=new TSorSegment(xvals[i], xvals[i]+ctrl_st1/3.0*height,
                                  xvals[i+1]-ctrl_st2/3.0*height, xvals[i+1]);
      NewSegment->scaley=height;
      NewSegment->pos.y=yvals[i];
      addobject(NewSegment);
  }
  NewSegment=new TDisk(0);        //Deckel obendrauf
  NewSegment->scalex=NewSegment->scalez=xvals[1];
  NewSegment->pos.y=yvals[1]-1e-10;
  addobject(NewSegment);

  NewSegment=new TDisk(0);        //Boden drunter
  NewSegment->scalex=NewSegment->scalez=xvals[pointno-2];
  NewSegment->pos.y=yvals[pointno-2]+1e-10;
  NewSegment->rotatex=M_PI;
  addobject(NewSegment);
}

char TSor::Obj_NextCut(double &t)
{
  int i;
  double shortestdist=DBL_MAX,dist;

  found=-1;

  for (i=0; i<numobj; ++i) Object[i]->SetStart(lastt);

  for (i=0;i<numobj;++i)
  {
    if (Object[i]->NextCut(dist))
    {
      if (dist<shortestdist)
      {
        shortestdist=dist;
        found=i;
      }
    }
  }
  if (found==-1) return 0;
  t=shortestdist;

  return 1;
}

char TSor::Obj_InObject(double t)
{
  for (int i=0;i<numobj-2;++i) //Die Scheiben oben und unten zhlen nicht
    if (Object[i]->InObject(t)) return 1;
  return 0;
}


