/****************************************************************************/
/* Sturm'sche Ketten / Nullstellenbestimmung von Polynomen                  */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/

#include<math.h>
#include"sturm.h"

TSturm::TSturm(TPolynom A)
{
  Kette[0]=A;
Sturm_Nochmal:
  Kette[1]=Kette[0].Diff();
  len=2;
  while (Kette[len-1]!=0)
  {
    Kette[len]=-(Kette[len-2] % Kette[len-1]);
    ++len;
  }
  if (Kette[len-2].degree>0)
  {
    Kette[0]=A/A.ggT(A.Diff());
    goto Sturm_Nochmal;
  }
  --len;            /* Die 0 am Ende zhlt nicht mehr dazu */
}

int TSturm::Wechsel(double a)
{
  int i,w;
  int sign,oldsign;
  w=0;
  oldsign=1;
  if (Kette[0].eval(a)<0) oldsign=-1;
  for (i=1;i<len;++i)
  {
    sign=1;
    if (Kette[i].eval(a)<0) sign=-1;
    if (sign!=oldsign) ++w;
    oldsign=sign;
  }
  return w;
}

double TSturm::NullMax()
{
  double erg=1;

  for (int i=0;i<=Kette[0].degree;++i)
    erg+=fabs(Kette[0].koeff[i]);
  return erg;
}

int TSturm::First0(double &x, double start, double max, double genau)
{
  int w1,w2,w3;
  double a,b,c;
  double mymax=NullMax();
  a=start+5e-4;
  b=(mymax<max?mymax:max);
  w1=Wechsel(a);
  w2=Wechsel(b);
  if (w1==w2) return 0;
  while (b-a>genau)
  {
    c=(a+b)/2;
    w3=Wechsel(c);
    if (w3!=w1)
    {
      w2=w3;
      b=c;
    }
    else
    {
      w1=w3;
      a=c;
    }
  }
  x=(a+b)/2;
  return 1;
}

/*void main(void)
{
  double x;
  TPolynom  A(1,-3.0,1.0);
  A*=TPolynom(1,-3.0,1.0);
  A*=TPolynom(1,-2.0,1.0);
  A*=TPolynom(1,-1.998,1.0);

  TSturm B(A);
  printf("Max: %lg\r\n",B.NullMax());
  if (!B.First0(x,0.000001))
    printf("Keine 0Stellen!\r\n");
  else
    printf("Erste 0Stelle: %lg\r\n",x);
}*/
