/****************************************************************************/
/* Syntaxanalyse                                                            */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/

#include<ctype.h>
#include<string.h>
//#include<conio.h>
#include<stdlib.h>
#include<stdio.h>
#include<math.h>
#ifdef USE_SHEAP
#include<sheap.h>
#endif
#include"syntax.h"

#define isop(x) (x==S_PLUS||x==S_MINUS||x==S_MAL||x==S_DURCH||x==S_HOCH)

#ifndef M_PI
#define M_PI 3.1415926535897932385
#endif
#define M_E 2.7182818284590452354

#ifdef IS_LINUX
#define stricmp strcasecmp
#endif

char *functions[F_NUM]={"sin","cos","tan","cot","asin","acos","atan",
                        "acot","sinh","cosh","sqrt","log","ln","abs"};


char *constants[K_NUM]={"pi","e"};

double oldfunc=0;
int errorpos;

int xused,yused,tused;

char makeelemlist(char *string, TMathElement **list, int *count)
{
  int strpos=0,elemcount=0;
  char lastdigit=0,lastklammer=0;
  int kl=0,i;
  char fname[256];
  int powten=-1;

  xused=yused=tused=0;
  *list=(TMathElement *)malloc(sizeof(TMathElement));

  while (strpos<strlen(string))
  {
    if (!isdigit(string[strpos]) && powten!=-1 && lastdigit)
    {
      for (i=0;i<powten;++i) (*list)[elemcount].data/=10.0;
    }
    if ((string[strpos]=='.'||string[strpos]==',')&&lastdigit)
      powten=0;
    else if (isdigit(string[strpos]))
    {
      if (elemcount>=1)
        if ((*list)[elemcount-1].type==S_X) goto ml_error;
      if (lastdigit==0)
      {
        (*list)[elemcount].data=(double)(string[strpos]-'0');
        (*list)[elemcount].type=S_ZAHL;
        if (elemcount>0 && lastdigit==0)
          if ((*list)[elemcount-1].type==S_MINUS &&
              !(elemcount>1 && ((*list)[elemcount-2].type==S_KLZU
              || (*list)[elemcount-2].type==S_ZAHL
              || (*list)[elemcount-2].type==S_X)))
          {
            --elemcount;
            (*list)[elemcount].type=S_ZAHL;
            (*list)[elemcount].data=(double)(-string[strpos]+'0');
          }
        lastdigit=1;
        powten=-1;
      }
      else
      {
        (*list)[elemcount].data*=10;
        if ((*list)[elemcount].data>=0)
          (*list)[elemcount].data+=string[strpos]-'0';
        else
          (*list)[elemcount].data-=string[strpos]-'0';
        if (powten!=-1) ++powten;
      }
    }
    else
    if (toupper(string[strpos])=='X' && !isalpha(string[strpos+1]))
    {
      if (lastdigit==1) goto ml_error;
      (*list)[elemcount].type=S_X;
      (*list)[elemcount].data=V_X;
      lastdigit=1;
      xused=1;
    }
    else
    if (toupper(string[strpos])=='Y' && !isalpha(string[strpos+1]))
    {
      if (lastdigit==1) goto ml_error;
      (*list)[elemcount].type=S_X;
      (*list)[elemcount].data=V_Y;
      lastdigit=1;
      yused=1;
    }
    else
    if (toupper(string[strpos])=='T' && !isalpha(string[strpos+1]))
    {
      if (lastdigit==1) goto ml_error;
      (*list)[elemcount].type=S_X;
      (*list)[elemcount].data=V_T;
      lastdigit=1;
      tused=1;
    }
    else
    if (toupper(string[strpos])=='O' && !isalpha(string[strpos+1]))
    {
      if (lastdigit==1) goto ml_error;
      (*list)[elemcount].type=S_X;
      (*list)[elemcount].data=V_O;
      lastdigit=1;
      tused=1;
    }
    else
    if (string[strpos]=='+')
    {
      chklast1;addelem;setnull;
      (*list)[elemcount-1].type=S_PLUS;
    }
    else
    if (string[strpos]=='-')
    {
      if (lastdigit==1 || lastklammer==1)
        elemcount+=2;
      else
        elemcount+=1;
      (*list)=(TMathElement *)realloc(*list,sizeof(TMathElement)*(elemcount+1));
      (*list)[elemcount-1].type=S_MINUS;
      setnull;
    }
    else
    if (string[strpos]=='*')
    {
      chklast1;addelem;setnull;
      (*list)[elemcount-1].type=S_MAL;
    }
    else
    if (string[strpos]=='/')
    {
      chklast1;addelem;setnull;
      (*list)[elemcount-1].type=S_DURCH;
    }
    else
    if (string[strpos]=='^')
    {
      chklast1;addelem;setnull;
      (*list)[elemcount-1].type=S_HOCH;
    }
    else
    if (string[strpos]=='(')
    {
      if (lastdigit==1 || lastklammer==1) goto ml_error;
      elemcount+=1;
      (*list)=(TMathElement *)realloc(*list,sizeof(TMathElement)*(elemcount+1));
      (*list)[elemcount-1].type=S_KLAUF;
      ++kl;
      lastdigit=lastklammer=0;
    }
    else
    if (string[strpos]==')')
    {
      if (lastdigit+lastklammer==0) goto ml_error;
      elemcount+=2;
      (*list)=(TMathElement *)realloc(*list,sizeof(TMathElement)*(elemcount+1));
      (*list)[elemcount-1].type=S_KLZU;
      --kl;
      lastdigit=0;
      --elemcount;
      lastklammer=1;
    }
    else if (isalpha(string[strpos]))
    {
      if (lastdigit||lastklammer) goto ml_error;
      i=0;
      while (isalpha(string[strpos++]))
        fname[i++]=string[strpos-1];
      fname[i]=0;
      strpos-=2;
      (*list)[elemcount].data=-1;
      for (i=0;i<F_NUM;++i)
        if (!stricmp(fname,functions[i])) (*list)[elemcount].data=i;

      if ((*list)[elemcount].data==-1)
      {
        for (i=0;i<K_NUM;++i)
          if (!stricmp(fname,constants[i]))
          {
            (*list)[elemcount].type=S_ZAHL;
            switch(i)
            {
              case 0: (*list)[elemcount].data=M_PI;break;
              case 1: (*list)[elemcount].data=M_E;break;
            }
          }
        if ((*list)[elemcount].data==-1) goto ml_error;
        lastdigit=1;
        if (elemcount>0)
          if ((*list)[elemcount-1].type==S_MINUS)
          {
            --elemcount;
            (*list)[elemcount].data=-(*list)[elemcount+1].data;
            (*list)[elemcount].type=S_ZAHL;
          }
      }
      else
      {
        (*list)[elemcount++].type=S_FUNCTION;
        if (string[strpos+1]!='(') goto ml_error;
      }
    }
    else if (string[strpos]!=32) goto ml_error;
    ++strpos;
  }
  if (lastdigit && powten!=-1)
    for (i=0;i<powten;++i) (*list)[elemcount].data/=10.0;

  if (kl!=0) goto ml_error;
  *count=elemcount+1;
  return 1;
ml_error:
  errorpos=strpos;
  free(*list);
  return 0;
}

//Prioritten
char priolist[5]={0,0,1,1,2}; //Plus,Minus,Mal,Durch,Hoch
#define priority(x) (priolist[x-1])

void insertelement(TMathElement **list, int &curlen, int pos, long data, int type)
// Ein Element zwischen pos-1 und pos einfgen
{
  *list=(TMathElement *)realloc(*list, sizeof(TMathElement)*(++curlen));
  memmove(*list+pos+1,*list+pos,(curlen-pos-1)*sizeof(TMathElement));
  (*list)[pos].data=data;
  (*list)[pos].type=type;
}


void klammern(TMathElement **list, int &nelem) //Punkt vor Strich etc.
{
  int pos,i,klammern;
  char klset; //Wurden vorne Klammern gesetzt? Wenn nicht, dann drfen hinten
              //auch keine mehr kommen

  for (pos=0;pos<nelem;++pos)
  {
    if (isop((*list)[pos].type) && priority((*list)[pos].type)!=0)
    {
      klset=0;
    //Nach vorne, bis Operator mit kleinerer Prioritt oder Anfang oder "("
      for (i=pos-1;i>=0;--i)
      {
        if (i==0 || (*list)[i].type==S_KLAUF) goto kl_nextpos;
        if ((*list)[i].type==S_KLZU)
        {
          klammern=1;
          while (klammern>0)
          {
            if ((*list)[--i].type==S_KLZU) ++klammern;
            if ((*list)[i].type==S_KLAUF)  --klammern;
          }
        }
        if (!isop((*list)[i].type)) continue;
        if (priority((*list)[i].type)<priority((*list)[pos].type))
        {
          insertelement(list,nelem,i+1,0,S_KLAUF);
          ++pos;
          i=-1;
          klset=1;
        }
      }
      if (!klset) continue;
    //Nach hinten, bis s.o.
      for (i=pos+1;i<=nelem;++i)
      {
kl_nexti:
        if ((*list)[i].type==S_KLZU)
        {
          insertelement(list,nelem,i,0,S_KLZU);
          i=nelem+3;//Abbruch
          continue;
        }
        if (i==nelem-1)
        {
          insertelement(list,nelem,nelem,0,S_KLZU);
          i=nelem+3;
          continue;
        }
        if ((*list)[i].type==S_KLAUF)
        {
          klammern=1;
          while (klammern>0)
          {
            if ((*list)[++i].type==S_KLAUF) ++klammern;
            if ((*list)[i].type==S_KLZU)  --klammern;
          }
          goto kl_nexti;
        }
        if (!isop((*list)[i].type)) continue;
        if (priority((*list)[i].type)<priority((*list)[pos].type))
        {
          insertelement(list,nelem,i,0,S_KLZU);
          i=nelem+3;
        }
      }
    }
kl_nextpos:;
  }
}

#define maxop 200
char oplist[maxop];
int oppos=0;
int destpos=0;

#define pushop(a) oplist[oppos++]=(a)
#define popop (oplist[--oppos])
#define adddest(v,t) {destlist=(TMathElement *)realloc(destlist,sizeof(TMathElement)*(destpos+1));destlist[destpos].type=(t);destlist[destpos].data=(v);++destpos;}

int toupn(TMathElement *normlist, int nelem, TMathElement *&destlist, int &delem)
{
  int i,stackpos=0;
  char op;
  char rebegin=1;
  destlist=NULL;
  destpos=0;
  if (normlist[0].type!=S_ZAHL && normlist[0].type!=S_X
      && normlist[0].type!=S_KLAUF && normlist[0].type!=S_FUNCTION && normlist[0].type!=S_MINUS)
    return 0;

  for (i=0;i<nelem;++i)
  {
    if (oppos<0) return 0;
    if (normlist[i].type==S_ZAHL || normlist[i].type==S_X)
    {
      destlist=(TMathElement *)realloc(destlist,sizeof(TMathElement)*(destpos+1));
      destlist[destpos].type=normlist[i].type;
      destlist[destpos].data=normlist[i].data;
      ++destpos;

      if (!rebegin)
        adddest(0,popop);
      rebegin=0;
    }
    else if (normlist[i].type==S_FUNCTION)
    {
      pushop(normlist[i].data);
      if (i==0 || normlist[i-1].type==S_KLAUF) pushop(S_FUNCTION|0x80);
      else pushop(S_FUNCTION);
      rebegin=0;
    }
    else if (normlist[i].type!=S_ZAHL && normlist[i].type!=S_X
             && normlist[i].type!=S_KLAUF && normlist[i].type!=S_KLZU)
      pushop(normlist[i].type);
    else if (normlist[i].type==S_KLAUF)
    {
      if (rebegin==1) pushop(0);
      rebegin=1;
    }
    else if (normlist[i].type==S_KLZU)
    {
toupn_addnext:
      if ((op=popop)!=0) adddest(0,op&0x7F);
      if ((op&0x7F)==S_FUNCTION)
      {
        destlist[destpos-1].data=popop;
        if (op==S_FUNCTION) goto toupn_addnext;
      }
    }
  }
  delem=destpos;
//Check: Alles OK?
  for (i=0;i<delem;++i)
  {
    if (destlist[i].type==S_ZAHL || destlist[i].type==S_X) ++stackpos;
    if (isop(destlist[i].type)) --stackpos;
    if (stackpos<=0) return 0;
  }
  if (stackpos!=1) return 0;
  return 1;
}

#define STACKSIZE 100
double upnstack[STACKSIZE];
int upnstackpos;
#define pushupn(x) upnstack[upnstackpos++]=(x)
#define popupn (upnstack[--upnstackpos])

int matherror=0;

double evaluatexyt(TMathElement **upnlist, int nelem, double x, double y, double t)
{
  int i;
  double a,b;

  upnstackpos=0;
  for (i=0;i<nelem;++i)
  {
    switch ((*upnlist)[i].type)
    {
      case S_X          :
        switch((int)(*upnlist)[i].data)
        {
          case V_X:pushupn(x);break;
          case V_T:pushupn(t);break;
          case V_Y:pushupn(y);break;
          case V_O:pushupn(oldfunc);break;
        }
        break;
      case S_ZAHL       : pushupn((*upnlist)[i].data);break;
      case S_PLUS       : a=popupn;b=popupn;pushupn(a+b);break;
      case S_MINUS      : a=popupn;b=popupn;pushupn(b-a);break;
      case S_MAL        : a=popupn;b=popupn;pushupn(a*b);break;
      case S_DURCH      :
        a=popupn;b=popupn;
        if (a==0) {matherror=MERR_DIVIDE0;return 0;}
        pushupn(b/a);
        break;
      case S_HOCH       :
        a=popupn;b=popupn;
        if (b<0 && (long)a!=a) {matherror=MERR_BEREICH;return 0;}
        pushupn(pow(b,a));break;
      case S_FUNCTION   :
        switch((int)(*upnlist)[i].data)
        {
          case F_SIN    : pushupn(sin(popupn));break;
          case F_COS    : pushupn(cos(popupn));break;
          case F_TAN    :
            if (cos(a=popupn)==0) {matherror=MERR_BEREICH;return 0;}
            pushupn(tan(a));
          break;
          case F_COT    :
            if (sin(a=popupn)==0) {matherror=MERR_BEREICH;return 0;}
            pushupn(1.0/tan(a));break;
          case F_ASIN   :
            a=popupn; if (a<-1 || a>1) {matherror=MERR_BEREICH;return 0;}
            pushupn(asin(a));break;
          case F_ACOS   :
            a=popupn; if (a<-1 || a>1) {matherror=MERR_BEREICH;return 0;}
            pushupn(acos(a));break;
          case F_ATAN   : pushupn(atan(popupn));break;
          case F_ACOT   : pushupn(atan(1.0/popupn));break;
          case F_SINH   : pushupn(sinh(popupn));break;
          case F_COSH   : pushupn(cosh(popupn));break;
          case F_SQRT   :
            if ((a=popupn)<0) {matherror=MERR_SQRT;return 0;}
            pushupn(sqrt(a));break;
          case F_LOG    :
            if ((a=popupn)<=0) {matherror=MERR_LOG;return 0;}
            pushupn(log10(a));break;
          case F_LN     :
            if ((a=popupn)<=0) {matherror=MERR_LOG;return 0;}
            pushupn(log(a));break;
          case F_ABS    : pushupn(fabs(popupn));break;
        }
        break;
    }
  }
  return popupn;
}

int evaluateconstant(char *string, double &dst)
{
  int mxused,myused,mtused;
  TMathElement *ElemList,*UpnList;
  int elemnum,upnnum;
  mxused=xused;myused=yused;mtused=tused;
  if (!makeelemlist(string,&ElemList,&elemnum))
  {
    xused=mxused;yused=myused;tused=mtused;
    return 0;
  }
  klammern(&ElemList,elemnum);
  if (!toupn(ElemList,elemnum,UpnList,upnnum))
  {
    free(ElemList);
    xused=mxused;yused=myused;tused=mtused;
    if (UpnList!=NULL) free(UpnList);
    return 0;
  }
  if (xused || yused || tused)
  {
    free(ElemList);
    free(UpnList);
    return 0;
  }
  dst=evaluatexyt(&UpnList,upnnum,0,0,0);
  xused=mxused;yused=myused;tused=mtused;
  return 1;
}
