#ifndef TEXTBASE_H

#include"tvector.h"
#include"ray20.h"
#include"readbmp.h"
#include<stdlib.h>

class TTextureBase
{
public:
  virtual void GetSurface(TVector const &point, TObjectData *surface)=0;
};

typedef TTextureBase *PTTextureBase;


class TText_Cubes:public TTextureBase //Gewuerfelt
{
  int r1,g1,b1,r2,g2,b2;
public:
  TText_Cubes(int pr1, int pg1, int pb1, int pr2, int pg2, int pb2)
  {
    r1=pr1;g1=pg1;b1=pb1;
    r2=pr2;g2=pg2;b2=pb2;
  }
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_Wood:public TTextureBase //Ringe
{
  int r1,g1,b1,r2,g2,b2;
public:
  TText_Wood(int pr1, int pg1, int pb1, int pr2, int pg2, int pb2)
  {
    r1=pr1;g1=pg1;b1=pb1;
    r2=pr2;g2=pg2;b2=pb2;
  }
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_Marble:public TTextureBase //Marmor
{
  int r1,g1,b1,r2,g2,b2;
  double pot;
public:
  TText_Marble(int pr1, int pg1, int pb1, int pr2, int pg2, int pb2, double ppot=1)
  {
    r1=pr1;g1=pg1;b1=pb1;
    r2=pr2;g2=pg2;b2=pb2;
    pot=ppot;
  }
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_Star:public TTextureBase //Nach auen zunehmende Transparenz
{
  double r1,r2;
public:
  TText_Star(double pr1, double pr2)
  {
    r1=pr1;r2=pr2;
  }
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_Cloud:public TTextureBase //Streifenmuster in der Transparenz
{
  double pot;
public:
  TText_Cloud(double ppot) {pot=ppot;}
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_Landscape:public TTextureBase //Mehrere Farbverufe (fr Landschaften)
{
  unsigned char *r1,*r2,*g1,*g2,*b1,*b2;
  double *pos1,*pos2;
  int num;
public:
  TText_Landscape() {num=0;pos1=pos2=NULL;r1=r2=g1=g2=b1=b2=NULL;}
  ~TText_Landscape() {free(pos1);free(pos2);free(r1);free(r2);free(g1);free(g2);free(b1);free(b2);}
  void AddColors(char pr1, char pg1, char pb1, char pr2, char pg2, char pb2, double ppos1, double ppos2);
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_MapBmpXY: public TTextureBase //BMP-Datei in 2D abbilden
{
public:
  TBMPInput *Bmp;
  TText_MapBmpXY(char *filename);
  ~TText_MapBmpXY();
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_MapBmpCylindrical: public TText_MapBmpXY //Zylindrisch Projizieren
{
public:
  TText_MapBmpCylindrical(char *filename):TText_MapBmpXY(filename){};
  void GetSurface(TVector const &point, TObjectData *surface);
};

class TText_MapBmpSpherical: public TText_MapBmpXY //Kugelkoordinaten
{
public:
  TText_MapBmpSpherical(char *filename):TText_MapBmpXY(filename){};
  void GetSurface(TVector const &point, TObjectData *surface);
};

#define TEXTBASE_H
#endif