/****************************************************************************/
/* TEXTURES.CPP - Texturen                                                  */
/* Texturen bestehen aus Grund-3D-Texturen (z.B. auch 2Dto3D-Projektionen)  */
/* und 3D-Mofifizierern wie Translation, Rotation, Noise etc.               */
/* Eine 3D-Textur ist prinzipiell das Gleiche wie ein Container             */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/

#include<stdlib.h>
#include<math.h>
#include"ray20.h"
#include"tvector.h"
#include"textures.h"

#define sqr(x) ((x)*(x))

void TTexture::addmodifier(PTModifier Modifier)
{
  Modifiers=(PTModifier *)realloc(Modifiers,(++num_modifiers)*sizeof(PTModifier));
  Modifiers[num_modifiers-1]=Modifier;
}

TTexture::~TTexture()
{
  for (int i=0;i<num_modifiers;++i) delete Modifiers[i];
  free(Modifiers);
  delete BaseAlgo;
}

char TTexture::Obj_NextCut(double &t)
{
  int i;
  TVector textv;

  if (!TContainer::Obj_NextCut(t)) return 0;
  textv=nstart+ndir*t;

/*---------------------Ab hier wird an der Textur rumgerechnet--------------*/
  for (i=0;i<num_modifiers;++i)
    Modifiers[i]->modify3d(textv);

  BaseAlgo->GetSurface(textv,this);

  return 1;
}

