/****************************************************************************/
/* TRACE.CPP - Die Raytrace-Prozedur                                        */
/* Hier werden die Lichtstrahlen verfolgt                                   */
/*  Copyright   (c) 1999 Martin Melcher                                     */
/* martin@raytracer.de      Gluckstr. 24/42655 Solingen/Germany             */
/* This program is free software; you can redistribute it and/or modify it  */
/* under the terms of the GNU General Public License as published by the    */
/* Free Software Foundation; either version 2 of the License, or (at your   */
/* option) any later version.                                               */
/* This Program is distributed in the hope that it will be useful, but      */
/* WITHOUT ANY WARRANTY; without even the implied warranty of               */
/* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPUOSE. See the GNU General*/
/* Public License for more details.                                         */
/* You should have received a copy of the GNU General Publiv License along  */
/* with this program; if not, write to the Free Software Foundation, Inc.,  */
/* 675 Mass Ave, Cambridge, MA 02139, USA.                                  */
/****************************************************************************/

#include"ray20.h"
#include"tvector.h"
#include<math.h>

char nodither=0;

void TRaytracer::trace(int x, int y, double &r, double &g, double &b)
{
  traceray(Camera->pos,Camera->getvector(x,y),r,g,b);
}


//Ausgelagert, um Stack zu sparen:
double nearestdist,dist;
TVector nv,cp,distvect,lightdir,spiegelv,brechv;
double multr,multg,multb;
double len;

void TRaytracer::traceray(TVector &start, TVector &dir, double &r, double &g, double &b, int depth)
{
  int i,j;
  TVector cutpoint;
  TVector normvect;
  int found;
  double r2,g2,b2;
  TObjectData ObjectData;

  nearestdist=DBL_MAX;
  found=-1;

  ++traces;
  r=g=b=0;
  if (depth>=maxdepth) return;
  dir.normalize();
// Nchstgelegenen Schnittpunkt berechnen
  for (i=0;i<numobj;++i)
  {
    Object[i]->SetRay(start, dir);
    if (Object[i]->NextCut(dist))
    {
      if (dist>=nearestdist) continue;
      found=i;
      nearestdist=dist;
    }
  }

//Keinen gefunden???
  if (found==-1) return;

  ObjectData=*Object[found];
  cutpoint=start+dir*nearestdist;
  normvect=Object[found]->GetNormVect();

//Wieviel Licht fllt auf das Objekt??
  for (i=0;i<numlight;++i)
  {
    multr=multg=multb=1;
    //Lichtvektor ausrechnen (wird auch fr weiteres bentigt)
    lightdir=cutpoint-Light[i]->pos;
    if (Light[i]->shadows && castshadows)
    {
      len=(double)lightdir;
      lightdir/=len;                //Normalisieren

      //1. Fllt berhaupt Licht auf das Objekt (oder ist es im Schatten???)
      //   ->Liegt irgendein Objekt dazwischen?
      for (j=0;j<numobj;++j)
      {
        Object[j]->SetRay(Light[i]->pos, lightdir, len);
        if (Object[j]->NextCut(dist))
        {
          if (Object[j]->trans==0) goto trace_schatten;
          multr*=Object[j]->trans*Object[j]->clrred/255;
          multg*=Object[j]->trans*Object[j]->clrgreen/255;
          multb*=Object[j]->trans*Object[j]->clrblue/255;
        }
      }
    }

//Diffuse Lichtreflexion
    if (ObjectData.flat>0)
    {
      Light[i]->getcolor(&ObjectData,cutpoint,normvect,r2,g2,b2,DIFFUS);
      r+=multr*r2*ObjectData.flat;
      g+=multg*g2*ObjectData.flat;
      b+=multb*b2*ObjectData.flat;
    }
//Spiegelnde Lichtreflexion
    if (ObjectData.light>0 && Light[i]->type!=TYPE_AMBIENT)
    {
      spiegelv=-lightdir.spiegel(normvect);
      spiegelv.normalize();
      Light[i]->getcolor(&ObjectData,cutpoint,spiegelv,r2,g2,b2,LIGHT);
      r+=multr*r2*ObjectData.light;
      g+=multg*g2*ObjectData.light;
      b+=multb*b2*ObjectData.light;
    }
trace_schatten:;
  }

//Transparenz
  if (ObjectData.trans>0)
  {
    if (ObjectData.brech==1)
      traceray(cutpoint,dir,r2,g2,b2,depth+1);
    else //Lichtbrechung
    {
      brechv=dir.brech(normvect, ObjectData.brech);
      brechv.normalize();
      traceray(cutpoint,brechv,r2,g2,b2,depth+1);
    }
    r+=r2*ObjectData.trans;
    g+=g2*ObjectData.trans;
    b+=b2*ObjectData.trans;
  }
//Reflexion
  if (ObjectData.reflect>0)
  {
    dir=-dir;
    spiegelv=dir.spiegel(normvect);
    spiegelv.normalize();
    traceray(cutpoint,spiegelv,r2,g2,b2,depth+1);
    r+=r2*ObjectData.reflect;
    g+=g2*ObjectData.reflect;
    b+=b2*ObjectData.reflect;
  }

/*  if (r>255) r=255;
  if (g>255) g=255;
  if (b>255) b=255;*/
  nodither=ObjectData.nodither;
}
